package com.yeejoin.amos.boot.module.jg.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 
 *
 * @author system_generator
 * @date 2023-12-12
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tzs_jg_use_registration")
public class JgUseRegistration extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 设备监管码
     */
	@TableField("supervisory_code")
    private String supervisoryCode;



    /**
     * 使用单位名称
     */
	@TableField("use_unit_name")
    private String useUnitName;

    /**
     * 申请编号
     */
	@TableField("apply_no")
    private String applyNo;

    /**
     * 办理状态
     */
	@TableField("audit_status")
    private String auditStatus;



    /**
     * 接收机构
     */
	@TableField("receive_org_name")
    private String receiveOrgName;



    /**
     * 检验单位
     */
	@TableField("inspect_unit_name")
    private String inspectUnitName;

    /**
     * 检验结果照片
     */
	@TableField("inspect_result_photo")
    private String inspectResultPhoto;

    /**
     * 检验结果
     */
	@TableField("inspect_result")
    private String inspectResult;

    /**
     * 终审通过时间
     */
	@TableField("audit_pass_date")
    private Date auditPassDate;

    /**
     * 登记类别（1：历史设备登记，0：other）
     */
	@TableField("reg_type")
    private String regType;

    /**
     * 注册登记日期
     */
	@TableField("reg_date")
    private Date regDate;

    /**
     * 注册登记人员ID
     */
	@TableField("reg_person_id")
    private String regPersonId;

    /**
     * 注册登记人员
     */
	@TableField("reg_person_name")
    private String regPersonName;



    /**
     * 安装单位名称
     */
	@TableField("install_unit_name")
    private String installUnitName;

    /**
     * 状态
     */
	@TableField("status")
    private String status;

    /**
     * 备注
     */
	@TableField("remark")
    private String remark;

    /**
     * 创建人ID
     */
	@TableField("create_user_id")
    private String createUserId;

    /**
     * 创建人姓名
     */
    @TableField("create_user_name")
    private String createUserName;

    /**
     * 创建时间
     */
	@TableField("create_date")
    private Date createDate;

    /**
     * 录入单位ID
     */
	@TableField("input_unit_no")
    private String inputUnitNo;

    @TableField("use_registration_code")
    private String useRegistrationCode;

    @TableField("instance_id")
    private String instanceId;

    @TableField("use_unit_credit_code")
    private String useUnitCreditCode;

    @TableField("inspect_unit_credit_code")
    private String inspectUnitCreditCode;

    @TableField("instance_status")
    private String instanceStatus;

    @TableField("receive_org_code")
    private String receiveOrgCode;

    @TableField("receive_company_code")
    private String receiveCompanyCode;

    @TableField("next_execute_ids")
    private String nextExecuteIds;


    @TableField(value = "promoter")
    private String promoter;


    @TableField(value = "next_task_id")
    private String nextTaskId;

    @TableField(exist = false)
    private String equipId;


    @TableField(value = "next_execute_user_ids")
    private String nextExecuteUserIds;

    @TableField(value = "is_xixian")
    private String isXixian;

    @TableField(value = "use_address")
    private String useAddress;

    @TableField(value = "transfer_to_user_ids")
    private String transferToUserIds;

    /**
     * 其他附件
     */
    @TableField(value = "other_accessories")
    private String otherAccessories;

    /**
     * 办理类型，unit(单位) set(台套)
     */
    @TableField(value = "manage_type")
    private String manageType;

    /**
     * 接收机构公司的org_code
     */
    @TableField("receive_company_org_code")
    private String receiveCompanyOrgCode;

    /**
     * 作废日期
     */
    @TableField("cancel_date")
    private Date cancelDate;

    /**
     * 作废人员id
     */
    @TableField("cancel_user_id")
    private String cancelUserId;

    /**
     * 作废原因
     */
    @TableField("cancel_reason")
    private String cancelReason;

    /**
     * 是否增补
     */
    @TableField("is_add_equip")
    private String isAddEquip;

    /**
     * 工程装置名称
     */
    @TableField("project_contraption")
    private String projectContraption;

    /**
     * 气瓶类别(液化石油气瓶、工业气瓶、其他)
     * 0：液化石油气瓶
     * 1：工业气瓶
     * 2：其他
     */
    @TableField("cylinder_category")
    private String cylinderCategory;

    /**
     * 监察处置机构代码
     */
    @TableField("supervision_org_code")
    private String supervisionOrgCode;

    /**
     * 工程装置id ( 主键sequence_nbr )
     */
    @TableField("project_contraption_id")
    private String projectContraptionId;

    /**
     * 原始需合并工程装置id集合
     */
    @TableField("origin_project_contraption_ids")
    private String originProjectContraptionIds;

    /**
     * 使用登记表url
     */
    @TableField("use_registration_form_url")
    private String useRegistrationFormUrl;

    /**
     * 使用登记表附件
     */
    @TableField("use_registration_form_file")
    private String useRegistrationFormFile;
}
