package com.yeejoin.amos.boot.module.jg.biz.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jg.api.dto.ShCarDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgUseRegistrationManage;
import com.yeejoin.amos.boot.module.jg.api.entity.ShCar;
import com.yeejoin.amos.boot.module.jg.api.service.IShCarService;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgUseRegistrationManageServiceImpl;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.ShCarEquServiceImpl;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.ShCarServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * @author system_generator
 * @date 2024-11-08
 */
@RestController
@Api(tags = "Api")
@RequestMapping(value = "/sh-car")
public class ShCarController extends BaseController {

    @Autowired
    ShCarEquServiceImpl shCarEquService;

    @Autowired
    ShCarServiceImpl shCarServiceImpl;

    @Autowired
    IShCarService iShCarService;

    @Autowired
    JgUseRegistrationManageServiceImpl jgUseRegistrationManageServiceImpl;

    /**
     * 新增
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
    public ResponseModel<ShCar> save(@RequestBody ShCar shCar) {
        shCar = shCarServiceImpl.createWithModel(shCar);
        return ResponseHelper.buildResponse(shCar);
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新", notes = "根据sequenceNbr更新")
    public ResponseModel<ShCar> updateBySequenceNbrShCar(@RequestBody ShCar entity, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        // entity.setSequenceNbr(sequenceNbr);
        entity.setSequenceNbr(String.valueOf(sequenceNbr));
        return ResponseHelper.buildResponse(shCarServiceImpl.updateWithModel(entity));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除", notes = "根据sequenceNbr删除")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(shCarServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个", notes = "根据sequenceNbr查询单个")
    public ResponseModel<ShCar> selectOne(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(shCarServiceImpl.queryBySeq(sequenceNbr));
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param size    每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "分页查询", notes = "分页查询")
    public ResponseModel<Page<ShCarDto>> queryForPage(@RequestParam(value = "current") int current,
                                                      @RequestParam(value = "size") int size,
                                                      ShCarDto dto) {
        Page<ShCarDto> page = new Page<>(current, size);
        Page<ShCarDto> shCarDtoPage = iShCarService.queryForShCarPage(page, dto);
        Optional.ofNullable(shCarDtoPage.getRecords()).ifPresent(records ->
                records.forEach(record -> {
                    if ("1".equals(record.getClaimedFlag())) {
                        record.setClaimedFlag("是");
                        JgUseRegistrationManage manage = jgUseRegistrationManageServiceImpl.getBaseMapper()
                                .selectOne(new LambdaQueryWrapper<JgUseRegistrationManage>()
                                        .eq(JgUseRegistrationManage::getUseRegistrationCode, record.getUseRegistrationCode())
                                        .eq(JgUseRegistrationManage::getIsDelete, false));
                        record.setCertificateSeq(manage != null ? String.valueOf(manage.getSequenceNbr()) : null);
                    } else if ("0".equals(record.getClaimedFlag())) {
                        record.setClaimedFlag("否");
                    }
                })
        );
        return ResponseHelper.buildResponse(shCarDtoPage);
    }

    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "列表全部数据查询", notes = "列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<ShCar>> selectForList() {
        return ResponseHelper.buildResponse(shCarServiceImpl.queryForShCarList());
    }

    /**
     * 数据查询，校验是否是三环系统数据
     *
     * @return 结果
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "数据查询，校验是否是三环系统数据", notes = "数据查询，校验是否是三环系统数据")
    @GetMapping(value = "/searchForSanHan")
    public ResponseModel<ShCar> searchForSanHan(@RequestParam Map<?, ?> map) {
        // 检查 map 是否为空
        if (map == null || map.isEmpty()) {
            return ResponseHelper.buildResponse(new ShCar()); // 返回空对象
        }
        return ResponseHelper.buildResponse(shCarServiceImpl.searchForSanHan(map));
    }

    /**
     * 数据查询，校验是否是三环系统数据 （三个入参必须同时满足）
     *
     * @param useRegistrationCode 使用登记证编号
     * @param carNumber           车牌号
     * @param identificationCode  车辆VIN码
     * @return result
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "数据查询，校验是否是三环系统数据", notes = "数据查询，校验是否是三环系统数据")
    @GetMapping(value = "/searchForSanHanAllParams")
    public ResponseModel<ShCar> searchForSanHan(@ApiParam(name = "使用登记证编号") @RequestParam String useRegistrationCode,
                                                @ApiParam(name = "车牌号") @RequestParam(value = "carNumber", required = false) String carNumber,
                                                @ApiParam(name = "单位内编号") @RequestParam(value = "USE_INNER_CODE", required = false) String useInnerCode,
                                                @ApiParam(name = "车辆VIN码") @RequestParam String identificationCode) {
        if (StringUtils.isEmpty(carNumber) && !StringUtils.isEmpty(useInnerCode)) {
            carNumber = useInnerCode;
        }
        if (StringUtils.isEmpty(useRegistrationCode) || StringUtils.isEmpty(carNumber) || StringUtils.isEmpty(identificationCode))
            return ResponseHelper.buildResponse(new ShCar());
        LambdaQueryWrapper<ShCar> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(ShCar::getClaimedFlag, Boolean.FALSE);
        wrapper.eq(ShCar::getCarNumber, carNumber.trim());
        wrapper.eq(ShCar::getUseRegistrationCode, useRegistrationCode.trim());
        wrapper.eq(ShCar::getFrameNumber, identificationCode.trim());
        ShCar shCar = shCarServiceImpl.getBaseMapper().selectList(wrapper)
                .stream()
                .findFirst()
                .orElse(new ShCar());
        if (StringUtils.isEmpty(shCar.getSequenceNbr()))
            return ResponseHelper.buildResponse(new ShCar());
        return ResponseHelper.buildResponse(shCar);
    }


    /**
     * 认领三环系统数据
     *
     * @return result
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "认领三环系统数据", notes = "认领三环系统数据")
    @PostMapping(value = "/claim")
    public ResponseModel<Boolean> claim(@RequestParam(value = "claimOneself",defaultValue = "true")String claimOneself,
                                        @RequestBody Map<String, Object> paramMap) {
        return ResponseHelper.buildResponse(shCarServiceImpl.claim(claimOneself,paramMap));
    }
}
