package com.yeejoin.amos.boot.module.jyjc.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author Administrator
 */

@AllArgsConstructor
@Getter
public enum InspectionCompanyType {
    /**
     * 检验单位分类
     */
    LEGAL("legal", "法定"),
    THIRD("third", "第3方"),
    DESIGNATED("designated", "定向单位"),
    ALL("all", "全部机构"),
    ALL_OR_APP("allOrApp", "所有机构和发起者");

    private final String code;
    private final String name;

    public static InspectionCompanyType getByCode(String code) {
        for (InspectionCompanyType e : InspectionCompanyType.values()) {
            if (e.getCode().equals(code)) {
                return e;
            }
        }
        throw new RuntimeException("未知的单位类型" + code);
    }
}
