package com.yeejoin.amos.boot.module.tcm.biz.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.tcm.api.dto.RiskProcessesDto;
import com.yeejoin.amos.boot.module.tcm.api.dto.RiskReportDto;
import com.yeejoin.amos.boot.module.tcm.api.entity.RiskReport;
import com.yeejoin.amos.boot.module.tcm.api.service.IRiskReportService;
import com.yeejoin.amos.feign.systemctl.model.DictionarieValueModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;

/**
 *
 * @author system_generator
 * @date 2025-08-08
 */
@RestController
@Api(tags = "Api")
@RequiredArgsConstructor
@RequestMapping(value = "/risk-report")
public class RiskReportController extends BaseController {

    private final IRiskReportService iRiskReportService;

    /**
     * 包含全部监管机构及企业的分页列表
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/allAgency/page")
    @ApiOperation(httpMethod = "GET", value = "包含全部监管机构及企业的分页列表", notes = "包含全部监管机构及企业的分页列表")
    public ResponseModel<Page<Map<String, String>>> allAgencyWithPage(@RequestParam(value = "current") int current,
                                                                      @RequestParam(value = "size") int size,
                                                                      @RequestParam(value = "isAdmin", required = false) String isAdmin,
                                                                      @RequestParam(value = "companyName", required = false) String companyName) {
        return ResponseHelper.buildResponse(iRiskReportService.allAgencyWithPage(current, size, Boolean.parseBoolean(isAdmin), companyName));
    }

    /**
     * 查询企业的监管机构
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/superviseOrgForEnter")
    @ApiOperation(httpMethod = "GET", value = "查询企业的监管机构", notes = "查询企业的监管机构")
    public ResponseModel<JSONObject> superviseOrgForEnter(@RequestParam(value = "enterSeq") String enterSeq) {
        return ResponseHelper.buildResponse(iRiskReportService.superviseOrgForEnter(enterSeq));
    }


    /**
     * 根据是否有权限返回风险类型列表
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/riskTypeByPermission")
    @ApiOperation(httpMethod = "GET", value = "根据是否有权限返回风险类型列表", notes = "根据是否有权限返回风险类型列表")
    public ResponseModel<List<DictionarieValueModel>> riskTypeByPermission() {
        return ResponseHelper.buildResponse(iRiskReportService.riskTypeByPermission());
    }

    /**
     * 风险报送列表分页查询
     *
     * @param current 当前页
     * @param size    每页大小
     * @return result
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/page")
    @ApiOperation(httpMethod = "POST", value = "分页查询", notes = "分页查询")
    public ResponseModel<Page<RiskReport>> queryForRiskReportPage(@RequestParam(value = "current") int current,
                                                                  @RequestParam(value = "size") int size,
                                                                  @RequestBody RiskReportDto reportDto) {
        return ResponseHelper.buildResponse(iRiskReportService.queryForRiskReportPage(reportDto, current, size));
    }

    /**
     * 风险上报 新增
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/saveOrUpdateReport")
    @ApiOperation(httpMethod = "POST", value = "风险上报", notes = "风险上报")
    public ResponseModel<RiskReport> saveOrUpdateReport(@RequestBody RiskReportDto dto) {
        return ResponseHelper.buildResponse(iRiskReportService.saveOrUpdateReport(dto));
    }

    /**
     * 根据sequenceNbr查询详情
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个", notes = "根据sequenceNbr查询单个")
    public ResponseModel<RiskReportDto> selectRiskDetail(@PathVariable String sequenceNbr) {
        return ResponseHelper.buildResponse(iRiskReportService.selectRiskDetail(Long.parseLong(sequenceNbr)));
    }

    /**
     * 根据sequenceNbr查询详情中的操作流水
     *
     * @param riskSeqNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/flowingWater")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询详情中的操作流水", notes = "根据sequenceNbr查询详情中的操作流水")
    public ResponseModel<List<JSONObject>> flowingWater(@RequestParam(value = "riskSeqNbr") String riskSeqNbr) {
        return ResponseHelper.buildResponse(iRiskReportService.flowingWater(Long.parseLong(riskSeqNbr)));
    }

    /**
     * 转办
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/forWarde/{sequenceNbr}")
    @ApiOperation(httpMethod = "PUT", value = "转办", notes = "转办")
    public ResponseModel<Boolean> forWardeBySeq(@PathVariable String sequenceNbr,
                                                @RequestBody RiskProcessesDto riskProcessesDto) {
        return ResponseHelper.buildResponse(iRiskReportService.forWardeBySeq(Long.parseLong(sequenceNbr), riskProcessesDto));
    }


    /**
     * 风险详情中的按钮权限（保存/保存提交/转办/处置/提交整改）
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/permissionButton/{sequenceNbr}")
    @ApiOperation(httpMethod = "PUT", value = "风险详情中的按钮权限", notes = "风险详情中的按钮权限")
    public ResponseModel<List<String>> permissionButton(@PathVariable(value = "sequenceNbr") String sequenceNbr) {
        return ResponseHelper.buildResponse(iRiskReportService.permissionButton(Long.parseLong(sequenceNbr)));
    }


    /**
     * 风险处置
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/riskDisposal/{sequenceNbr}")
    @ApiOperation(httpMethod = "POST", value = "风险处置", notes = "风险处置")
    public ResponseModel<Boolean> riskDisposal(@PathVariable(value = "sequenceNbr") String sequenceNbr,
                                               @RequestBody RiskProcessesDto riskProcessesDto) {
        return ResponseHelper.buildResponse(iRiskReportService.riskDisposal(Long.parseLong(sequenceNbr), riskProcessesDto));
    }

}
