package com.yeejoin.amos.boot.module.ymt.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 
 * <pre>
 * 警情信息ES dto对象
 * </pre>
 *
 * @author gwb
 * @version $Id: ESAlertCalledDto.java, v 0.1 2021年6月23日 下午1:52:07 gwb Exp $
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="ESAlertCalledDto", description="ES警情信息")
public class ESAlertCalledDto extends BaseDto {

    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;
    /**
     * 警情状态
     */
    @ApiModelProperty(value = "警情状态")
    private Boolean alertStatus;

    /**
     * 警情阶段
     */
    @ApiModelProperty(value = "警情阶段")
    private String alertStage;
    /**
     * 联系人姓名
     */
    @ApiModelProperty(value = "联系人姓名")
    private String contactUser;
    /**
     * 联系人电话
     */
    @ApiModelProperty(value = "联系人电话")
    private String contactPhone;
    /**
     * 接警时间
     */
    @ApiModelProperty(value = "接警时间")
    private Date callTime;
    /**
     * 接警时间
     */
    @ApiModelProperty(value = "接警时间戳")
    private Long callTimeLong;
    /**
     * 警情类型
     */
    @ApiModelProperty(value = "警情类型")
    private String alarmType;
    /**
     * 警情类型code
     */
    @ApiModelProperty(value = "警情类型code")
    private String alarmTypeCode;
    /**
     * 事发单位
     */
    @ApiModelProperty(value = "使用单位")
    private String useUnit;
    /**
     * 地址
     */
    @ApiModelProperty(value = "地址")
    private String address;

    /**
     * 设备识别码
     */
    @ApiModelProperty(value = "设备识别码")
    private String deviceId;

    /**
     * 求援人电话
     */
    @ApiModelProperty(value = "求援人电话")
    private String emergencyCall;

    /**
     * 响应级别
     */
    @ApiModelProperty(value = "响应级别")
    private String responseLevel;

}
