package com.yeejoin.precontrol.common.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.precontrol.common.entity.PersonExam;
import com.yeejoin.precontrol.common.entity.UserRegistration;
import com.yeejoin.precontrol.common.enums.MessageTypeEnum;
import com.yeejoin.precontrol.common.exception.BaseException;
import com.yeejoin.precontrol.common.mapper.PersonExamMapper;
import com.yeejoin.precontrol.common.service.IPersonExamService;
import org.springframework.stereotype.Service;

import java.util.Date;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author duanwei
 * @since 2020-10-26
 */
@Service
public class PersonExamServiceImpl extends ServiceImpl<PersonExamMapper, PersonExam> implements IPersonExamService {

    @Override
    public void saveExam(UserRegistration userRegistration) {
        FeignClientResult<AgencyUserModel> userModel = Privilege.agencyUserClient
                .queryByUserId(String.valueOf(userRegistration.getUserId()));
        Long personId = null;
        if (userModel.getResult() != null) {
            personId = userModel.getResult().getSequenceNbr();
        } else {
            throw new BaseException("账号不存在,userId: " + userRegistration.getUserId());
        }
        PersonExam personExam = new PersonExam();
        personExam.setPersonId(personId);
        personExam.setType(MessageTypeEnum.THREE_LEVEL_EXAM.getName());
        personExam.setScore(Integer.valueOf(String.valueOf(userRegistration.getExamineScore())));
        personExam.setQualified(userRegistration.getQualified() == 1 ? Boolean.TRUE : Boolean.FALSE);
        personExam.setExamSubjectType("THREE_LEVEL_EXAM");
        personExam.setCreateDate(new Date());
        this.save(personExam);
    }
}
