package com.yeejoin.amos.boot.module.statistics.api.vo;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

@Data
public class TzsUserInfoVo {

    /**
     * 主键
     */
    @TableId(value = "sequence_nbr")
    protected Long sequenceNbr;

    /**
     * 姓名
     */
    @TableField("name")
    private String name;


    /**
     * 证件类型
     */
    @TableField("certificate_type")
    private String certificateType;

    /**
     * 证件编号
     */
    @TableField("certificate_num")
    private String certificateNum;

    /**
     * 性别
     */
    @TableField("gender")
    private String gender;

    /**
     * 岗位
     */
    @TableField("post")
    @Deprecated
    private JSONArray post;

    /**
     * 岗位 （后期post迁移数组至此）
     */
    @TableField("new_post")
    private JSONArray newPost;

    /**
     * 联系电话
     */
    @TableField("phone")
    private String phone;

    /**
     * 出生日期
     */
    @TableField("birthday")
    private String birthday;

    /**
     * 学历
     */
    @TableField("education")
    private String education;
    /**
     * 学历
     */
    @TableField("education_required")
    private String education_required;
    /**
     * 专业
     */
    @TableField("speciality")
    private String speciality;
    /**
     * 专业
     */
    @TableField("speciality_required")
    private String speciality_required;

    /**
     * 邮箱
     */
    @TableField("email")
    private String email;

    /**
     * 住址
     */
    @TableField("address")
    private String address;

    /**
     * 证件照片
     */
    @TableField(value = "identification")
    private List identification;

    /**
     * 任命文件
     */
    @TableField(value = "appoint_doc")
    private List appointDoc;


    /**
     * 账户名
     */
    @TableField("amos_user_name")
    private String amosUserName;

    /**
     * 单位名称
     */
    @TableField("unit_name")
    private String unitName;

    /**
     * 单位code
     */
    @TableField("unit_code")
    private String unitCode;

    /**
     * 头像
     */
    @TableField(value = "profile")
    private List profile;


    /**
     * 平台账号id
     */
    @TableField("amos_user_id")
    private String amosUserId;


    /**
     * 平台账号锁定状态
     */
    @TableField("lock_status")
    private String lockStatus;

    /**
     * 设备类型
     */
    @ApiModelProperty(value = "设备类型")
    private JSONArray equipType;

    /**
     * 内部人员编码
     */
    @ApiModelProperty(value = "内部人员编码")
    private String innerPersonCode;

    /**
     * 其他附件
     */
    @ApiModelProperty(value = "其他附件")
    private List<?> otherAccessories;

    /**
    * 单位类型
    * */
    private String companyType;

    /**
     * 职称
     */
    @TableField("job_title")
    private String jobTitle;
    /**
     * 职称
     */
    @TableField("job_title_required")
    private String jobTitle_required;

    @ApiModelProperty(value = "人员类型名称")
    private String postName;

    @ApiModelProperty("岗位子类型（多个逗号分割）")
    private JSONArray subPost;

    @ApiModelProperty("岗位子类型名称（多个逗号分割）")
    private String subPostName;


    @ApiModelProperty(value = "执业注册")
    private List practiceRegistration;

    @ApiModelProperty(value = "劳动合同")
    private List laborContract;
}
