package com.yeejoin.amos.boot.module.common.api.dto;

import java.util.List;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.yeejoin.amos.boot.biz.common.constants.CommonConstant;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.module.common.api.entity.DynamicFormInstance;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @author fengwang
 * @date 2021-06-18.
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="OrgUsr对象", description="人员信息")
public class OrgPersonDto extends BaseDto {


    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "人员名称")
    private String bizOrgName;

    @ApiModelProperty(value = "人员编码")
    private String bizOrgCode;

    @ApiModelProperty(value = "amos中公司/部门ID")
    private String amosOrgId;

    @ApiModelProperty(value = "amos中公司/部门编码")
    private String amosOrgCode;

    @ApiModelProperty(value = "机构类型（部门：DEPARTMENT，单位：COMPANY，人员：PERSON）")
    private String bizOrgType = CommonConstant.BIZ_ORG_TYPE_PERSON;

    @ApiModelProperty(value = "所属建筑名称")
    private String buildName;

    @ApiModelProperty(value = "所属建筑ID")
    private String buildId;

    @ApiModelProperty(value = "归属机构/部门/人员")
    private String parentId;
    
    @ApiModelProperty(value = "归属机构/部门/人员名称")
    private String parentName;

    @ApiModelProperty(value = "扩展属性1")
    private String orgExpandAttr1;

    @ApiModelProperty(value = "扩展属性2")
    private String orgExpandAttr2;

    @ApiModelProperty(value = "扩展属性3")
    private String orgExpandAttr3;

    @ApiModelProperty(value = "扩展属性4")
    private String orgExpandAttr4;

    private String orgExpandAttr5;

    private String orgExpandAttr6;

    private String orgExpandAttr7;

    private String orgExpandAttr8;

    @ApiModelProperty(value = "更新人")
    @TableField(fill= FieldFill.INSERT_UPDATE)
    private String recUserName;
    
    @ApiModelProperty(value = "动态表单值")
    private List<DynamicFormInstance> dynamicFormValue;

}
