package com.yeejoin.equipmanage.common.entity.dto;

import com.yeejoin.equipmanage.common.entity.EquipmentSpecific;
import com.yeejoin.equipmanage.common.entity.publics.BaseDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author ZeHua Li
 * @date 2020/12/18 14:56
 * @since v2.0
 */
@Data
public class EquipTypeAmountPageDTO extends BaseDTO<EquipmentSpecific> {

    @ApiModelProperty(value = "分类编码")
    private String equipmentClassificationCode;

    @ApiModelProperty(value = "设备编码")
    private String code;

    @ApiModelProperty(value = "物联编码")
    private String iotCode;

    @ApiModelProperty(value = "系统id")
    private Long systemId;

    @ApiModelProperty(value = "生产厂家id")
    private Long manufacturerId;

    @ApiModelProperty(value = "设备名称")
    private String equipmentName;

    @ApiModelProperty(value = "进口/国产")
    private Integer isImport;

    @ApiModelProperty(value = "入库状态 1 入库 0未入库 不传全部")
    private Integer status;

    @ApiModelProperty(value = "类型 car：车辆，equipment：设备")
    private String type;

    @ApiModelProperty(value = "所在位置")
    private Long warehouseStructureId;

    @ApiModelProperty(value = "行业编码")
    private String industryCode;
}
