package com.yeejoin.amos.patrol.common.enums;

public enum LatentDangerExcuteTypeEnum {
    填写隐患完成("填写隐患完成", 1, ExecuteStateEnum.通过, LatentDangerStateEnum.待评审,
            "{\"action\": \"complete\"}"),
    隐患评审通过("隐患评审通过", 2, ExecuteStateEnum.通过, LatentDangerStateEnum.待治理,
            "{\"reviewResult\": \"通过\"}"),
    隐患评审拒绝("隐患评审拒绝", 3, ExecuteStateEnum.驳回, LatentDangerStateEnum.已撤销,
            "{\"reviewResult\": \"不通过\"}"),
    隐患常规治理("隐患常规治理", 4, ExecuteStateEnum.通过, LatentDangerStateEnum.待验证,
            "{\"rectifyResult\": \"常规整改\"}"),
    隐患安措计划("隐患安措计划", 5, ExecuteStateEnum.通过, LatentDangerStateEnum.安措计划中,
            "{\"action\": \"complete\",\"variables\": [{\"name\": \"rectification\",\"value\": \"plan\"}]}"),
    隐患延期治理("隐患延期治理", 15, ExecuteStateEnum.通过, LatentDangerStateEnum.延期治理申请待车间部门审核,
            "{\"rectifyResult\": \"延期\"}"),
    隐患延期治理车间部门审核通过("隐患延期治理车间部门审核通过", 16, ExecuteStateEnum.通过, LatentDangerStateEnum.待治理,
            "{\"approveResult\": \"通过\"}"),
    隐患延期治理车间部门审核拒绝("隐患延期治理车间部门审核拒绝", 17, ExecuteStateEnum.驳回, LatentDangerStateEnum.待治理,
            "{\"approveResult\": \"不通过\"}"),

    隐患延期治理公司审核通过("隐患延期治理公司审核通过", 18, ExecuteStateEnum.通过, LatentDangerStateEnum.待治理,
            "{\"approveResult\": true}"),
    隐患延期治理公司审核拒绝("隐患延期治理公司审核拒绝", 19, ExecuteStateEnum.驳回, LatentDangerStateEnum.延期治理申请待车间部门审核,
            "{\"approveResult\": false}"),
    填写安措计划完成("填写安措计划完成", 6, ExecuteStateEnum.通过, LatentDangerStateEnum.安措计划中,
            "{\"action\": \"complete\"}"),
    车间部门审核通过("车间部门审核通过", 7, ExecuteStateEnum.通过, LatentDangerStateEnum.安措计划中,
            "{\"action\": \"complete\",\"variables\": [{\"name\": \"rejected\",\"value\": false}]}"),
    车间部门审核拒绝("车间部门审核拒绝", 8, ExecuteStateEnum.驳回, LatentDangerStateEnum.待治理,
            "{\"action\": \"complete\",\"variables\": [{\"name\": \"rejected\",\"value\": true}]}"),
    总工程师审核通过("总工程师审核通过", 9, ExecuteStateEnum.通过, LatentDangerStateEnum.安措计划中,
            "{\"action\": \"complete\",\"variables\": [{\"name\": \"rejected\",\"value\": false}]}"),
    总工程师审核拒绝("总工程师审核拒绝", 10, ExecuteStateEnum.驳回, LatentDangerStateEnum.待治理,
            "{\"action\": \"complete\",\"variables\": [{\"name\": \"rejected\",\"value\": true}]}"),
    公司负责人审核通过("公司负责人审核通过", 11, ExecuteStateEnum.通过, LatentDangerStateEnum.待验证,
            "{\"action\": \"complete\",\"variables\": [{\"name\": \"rejected\",\"value\": false}]}"),
    公司负责人审核拒绝("公司负责人审核拒绝", 12, ExecuteStateEnum.驳回, LatentDangerStateEnum.待治理,
            "{\"action\": \"complete\",\"variables\": [{\"name\": \"rejected\",\"value\": true}]}"),
    隐患验证通过("隐患验证通过", 13, ExecuteStateEnum.通过, LatentDangerStateEnum.治理完毕,
            "{\"validationResult\": \"通过\"}"),
    隐患验证拒绝("隐患验证拒绝", 14, ExecuteStateEnum.驳回, LatentDangerStateEnum.待治理,
            "{\"validationResult\": \"不通过\"}");

    /**
     * 名称，描述
     */
    private String name;
    /**
     * 编码
     */
    private Integer code;

    /**
     * 执行状态
     */
    private ExecuteStateEnum excuteState;

    private String requestBody;

    private LatentDangerStateEnum nextState;

    LatentDangerExcuteTypeEnum(String name, Integer code, ExecuteStateEnum excuteState, LatentDangerStateEnum nextState, String requestBody) {
        this.name = name;
        this.code = code;
        this.excuteState = excuteState;
        this.requestBody = requestBody;
        this.nextState = nextState;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public ExecuteStateEnum getExcuteState() {
        return excuteState;
    }

    public void setExcuteState(ExecuteStateEnum excuteState) {
        this.excuteState = excuteState;
    }

    public String getRequestBody() {
        return requestBody;
    }

    public void setRequestBody(String requestBody) {
        this.requestBody = requestBody;
    }

    public LatentDangerStateEnum getNextState() {
        return nextState;
    }

    public void setNextState(LatentDangerStateEnum nextState) {
        this.nextState = nextState;
    }

    public static LatentDangerExcuteTypeEnum getByCode(Integer code) {
        for (LatentDangerExcuteTypeEnum e : LatentDangerExcuteTypeEnum.values()) {
            if (e.getCode().equals(code)) {
                return e;
            }
        }
        return null;
    }
}
