package com.yeejoin.equipmanage.controller;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import com.yeejoin.equipmanage.common.entity.Industry;
import com.yeejoin.equipmanage.service.IIndustryService;

import io.swagger.annotations.Api;

@RestController
@Api(tags = "行业分类Industry")
@RequestMapping(value = "/industry")
public class IndustryController {
    @Autowired
    IIndustryService industryService;

    @GetMapping(value = "/list")
    public List<Industry> listAll() {
        return industryService.list();
    }
}
