package com.yeejoin.equipmanage.controller;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.equipmanage.common.datasync.enums.MonitorViewPollingPeriodEnum;
import com.yeejoin.equipmanage.common.entity.dto.MonitorViewDto;
import com.yeejoin.equipmanage.common.entity.dto.MonitorViewTreeDto;
import com.yeejoin.equipmanage.common.entity.vo.VideoListVo;
import com.yeejoin.equipmanage.service.impl.MonitorViewService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 
 * <pre>
 * 前端控制器
 * </pre>
 *
 * @author gwb
 * @version $Id: MonitorViewController.java, v 0.1 2021年9月13日 上午11:27:13 gwb Exp
 *          $
 */

@RestController
@Api(tags = "在岗监测视频轮询Api")
@RequestMapping(value = "/monitorView")
public class MonitorViewController {

	@Autowired
	private MonitorViewService monitorViewService;

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "创建视频视图")
	@RequestMapping(value = "", method = RequestMethod.POST)
	public ResponseModel<MonitorViewDto> create(@RequestBody MonitorViewDto model) throws Exception {

		if (ValidationUtil.isEmpty(model) || ValidationUtil.isEmpty(model.getViewName()))
			throw new BadRequest("参数校验失败.");

		return ResponseHelper.buildResponse(monitorViewService.createMonitorView(model));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "编辑视频视图")
	@RequestMapping(value = "/{id}", method = RequestMethod.PUT)
	public ResponseModel<MonitorViewDto> updateAgency(@RequestBody MonitorViewDto model, @PathVariable("id") Long id) {

		model.setId(id);
		return ResponseHelper.buildResponse(monitorViewService.udpateMonitorView(model, id));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "获取单个视频视图信息")
	@RequestMapping(value = "/{id}", method = RequestMethod.GET)
	public ResponseModel<MonitorViewDto> seleteOne(@PathVariable("id") Long id) {
		return ResponseHelper.buildResponse(monitorViewService.queryById(id));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "查询监测事件树结构")
	@RequestMapping(value = "/tree", method = RequestMethod.GET)
	public ResponseModel<List<MonitorViewTreeDto>> queryTree() throws Exception {

		return ResponseHelper.buildResponse(monitorViewService.queryForViewTree());
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "查询未绑定视图的视频列表")
	@RequestMapping(value = "/list/uncheckedvideo", method = RequestMethod.GET)
	public ResponseModel<List<VideoListVo>> queryUncheckedVideoList() throws Exception {

		return ResponseHelper.buildResponse(monitorViewService.queryUncheckedVideoList());
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "分页查询视图下的视频列表")
	@RequestMapping(value = "/video/page", method = RequestMethod.GET)
	public ResponseModel<Page<VideoListVo>> queryUncheckedVideoList(@RequestParam(value = "viewId") Long viewId,
			@RequestParam(value = "videoName", required = false) String videoName,
			@RequestParam(value = "videoCode", required = false) String videoCode,
			@RequestParam(value = "current") int current, @RequestParam(value = "size") int size) throws Exception {
		Page<VideoListVo> page = new Page<VideoListVo>();
		page.setCurrent(current);
		page.setSize(size);
		return ResponseHelper
				.buildResponse(monitorViewService.queryVideoPageByViewId(page, viewId, videoName, videoCode));
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "查询视图轮询周期")
	@RequestMapping(value = "/pollingPeriod", method = RequestMethod.GET)
	public ResponseModel<LinkedList<Map<String, Object>>> queryPollingPeriodList() throws Exception {
		LinkedList<Map<String, Object>> returnList = new LinkedList<>();
		MonitorViewPollingPeriodEnum[] enums = MonitorViewPollingPeriodEnum.values();
		for (MonitorViewPollingPeriodEnum monitorViewPollingPeriodEnum : enums) {
			Map<String, Object> enumObj = new HashMap<String, Object>();
			enumObj.put("value", monitorViewPollingPeriodEnum.getValue());
			enumObj.put("name", monitorViewPollingPeriodEnum.getName());

			returnList.add(enumObj);
		}
		return ResponseHelper.buildResponse(returnList);
	}

	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(value = "删除视频视图")
	@RequestMapping(value = "/{ids}", method = RequestMethod.DELETE)
	public ResponseModel<List<Long>> delete(@PathVariable("ids") String ids) {

		return ResponseHelper.buildResponse(monitorViewService.deleteMonitorView(ids));
	}

}
