package com.yeejoin.equipmanage.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.equipmanage.common.entity.AnalysisReportLog;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;
import com.yeejoin.equipmanage.common.enums.AnalysisReportEnum;
import com.yeejoin.equipmanage.mapper.AnalysisReportLogMapper;
import com.yeejoin.equipmanage.service.IAnalysisReportLogService;
import org.springframework.stereotype.Service;

import java.util.Calendar;
import java.util.Date;

/**
 * 报告流水表 服务实现类
 *
 * @author duanwei
 * @date 2021-05-26
 */
@Service
public class AnalysisReportLogServiceImpl extends ServiceImpl<AnalysisReportLogMapper, AnalysisReportLog> implements IAnalysisReportLogService {

    @Override
    public IPage<AnalysisReportLog> listPage(Page page, AnalysisReportLog analysisReportLog) {

        LambdaQueryWrapper<AnalysisReportLog> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(AnalysisReportLog::getReportType, analysisReportLog.getReportType());
        if (analysisReportLog.getStartDate() != null && analysisReportLog.getEndDate() != null) {
            queryWrapper.ge(AnalysisReportLog::getStartDate, analysisReportLog.getStartDate());
            queryWrapper.le(AnalysisReportLog::getEndDate, analysisReportLog.getEndDate());
        }
        queryWrapper.select().orderByDesc(BaseEntity::getCreateDate);

        return this.baseMapper.selectPage(page, queryWrapper);
    }

    @Override
    public void generateReport(AnalysisReportEnum reportEnum, Date beginDate, Date endDate) {
        AnalysisReportLog reportLog = new AnalysisReportLog();
        reportLog.setName(reportEnum.getName());
        reportLog.setReportType(reportEnum.getType());
        reportLog.setStartDate(beginDate);
        reportLog.setEndDate(endDate);
        reportLog.setReportDateDesc(buildReportDateDesc(reportEnum,beginDate,endDate));
        this.save(reportLog);
    }

    private String buildReportDateDesc(AnalysisReportEnum reportEnum, Date beginDate, Date endDate) {
        StringBuilder desc = new StringBuilder();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(beginDate);
        switch (reportEnum){
            case DAY_REPORT:
                desc.append(calendar.get(Calendar.YEAR));
                desc.append("年");
                desc.append(calendar.get(Calendar.MONTH) + 1);
                desc.append("月");
                desc.append(calendar.get(Calendar.DAY_OF_MONTH));
                desc.append("日");
                break;
            case WEEK_REPORT:
                desc.append(calendar.get(Calendar.YEAR));
                desc.append("年");
                desc.append(calendar.get(Calendar.MONTH) + 1);
                desc.append("月");
                desc.append(calendar.get(Calendar.DAY_OF_MONTH));
                desc.append(" - ");
                calendar.setTime(endDate);
                desc.append(calendar.get(Calendar.YEAR));
                desc.append("年");
                desc.append(calendar.get(Calendar.MONTH) + 1);
                desc.append("月");
                desc.append(calendar.get(Calendar.DAY_OF_MONTH));
                desc.append("日");
                break;
            case MONTH_REPORT:
                desc.append(calendar.get(Calendar.YEAR));
                desc.append("年");
                desc.append(calendar.get(Calendar.MONTH) + 1);
                desc.append("月");
                break;
            default:
                break;
        }
        return desc.toString();
    }
}
