package com.yeejoin.amos.latentdanger.business.dao.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.annotations.DataAuth;
import com.yeejoin.amos.latentdanger.business.entity.mybatis.extend.LatentDangerBo;
import com.yeejoin.amos.latentdanger.business.entity.mybatis.extend.LatentDangerNoticeBo;
import com.yeejoin.amos.latentdanger.business.param.LatentDangerListParam;
import com.yeejoin.amos.latentdanger.business.param.PageParam;
import com.yeejoin.amos.latentdanger.core.common.response.DangerListResponse;
import com.yeejoin.amos.latentdanger.dao.entity.LatentDanger;
import org.apache.ibatis.annotations.Param;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface LatentDangerMapper extends BaseMapper<LatentDanger> {

    Integer save(LatentDangerBo latentDangerBo);

    List<LatentDangerBo> listByMap(Map<String, Object> map);

    Long countByMap(Map<String, Object> map);

    LatentDangerBo getById(Long id);

    Integer update(LatentDangerBo latentDangerBo);

    LatentDangerBo getByInstanceId(String instanceId);

    List<LatentDangerBo> listOfOvertime(@Param("dangerStateList") List<String> dangerStateList);

    Integer countNotFinishByFlowId(String flowId);

    List<LatentDangerBo> listNotFinishByPointId(HashMap<String, Object> params);

    Long countByFlowUserIds(String userId);

    Long countNotFinishByTypeAndDeptId(@Param("type") Integer type, @Param("departmentId") String departmentId);

    String getNotFinishIdsByTypeAndDeptId(@Param("type") Integer type, @Param("departmentId") String departmentId);

    void deleteByIds(List<Long> dangerIds);

    /**
     * 查询治理期限即将到期的隐患
     *
     * @param dangerState 隐患状态（逗号分割字符串）
     * @return
     */
    List<LatentDangerNoticeBo> listNeedNoticeDanger(@Param("dangerState") String dangerState);

    /**
     * 根据隐患id获取评审信息
     *
     * @param dangerId
     * @return
     */
    List<HashMap<String, Object>> getReViewInfo(Long dangerId);

    List<DangerListResponse> dangerListByMap(PageParam pageParam);

    Long countDangerListByMap(PageParam pageParam);

    List<LatentDangerBo> getByBathBusinessKeys(@Param("businessKeys") List<String> businessKeys, @Param("latentDangerListParam") LatentDangerListParam latentDangerListParam);

    int countByBathBusinessKeys(@Param("businessKeys") List<String> businessKeys, @Param("latentDangerListParam") LatentDangerListParam latentDangerListParam);

    int countByStatus(@Param("businessKeys") List<String> businessKeys);

    void updateCheckInputDangerState(@Param("id") Long id, @Param("code") int code);

    LatentDangerBo getByBusinessKey(@Param("businessKey") String businessKey);

    /**
     * 根据参数分页查询
     *
     * @param paramMap
     * @return
     */
    @DataAuth(interfacePath = "latent/danger/page/list")
    IPage<LatentDanger> selectPageByParam(@Param("page") Page<LatentDanger> page, @Param("paramMap") Map<String, Object> paramMap);

    Integer selectUnFinishedCount(@Param("dangerState1") List<String> dangerState1, @Param("dangerState2") List<String> dangerState2);
}
