package com.yeejoin.equipmanage.common.enums;
/**
 * 
 */
public enum JournalTypeEnum {
	
	RK("01", "入库")
	,CK("02", "出库")
	,WX("03", "维修")
	,WXWC("04","维修完成")
	,BF("05", "报废")
	,BY("06", "保养")
	,CZ("07", "车载")
	,XZ("08", "卸载")
	,SH("09", "损耗");
	
	/**
	 * code
	 */
	private String code;
	
	/**
	 * 名称
	 */
	private String name;
	
	/**
	 * 类型
	 */
	private String type;
	
	private JournalTypeEnum(String code, String name) {
		this.setCode(code);
		this.setName(name);
		this.setType("JournalType");
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}
	
	public static JournalTypeEnum getEnum(String code) {
		JournalTypeEnum journalTypeEnum = null;
		for(JournalTypeEnum type: JournalTypeEnum.values()) {
			if (type.getCode().equals(code)) {
				journalTypeEnum = type;
				break;
			}
		}
		
		return journalTypeEnum;
	}
	
	public static JournalTypeEnum getEnumByName(String name) {
		JournalTypeEnum journalTypeEnum = null;
		for(JournalTypeEnum type: JournalTypeEnum.values()) {
			if (type.getName().equals(name)) {
				journalTypeEnum = type;
				break;
			}
		}
		
		return journalTypeEnum;
	}
}
