package com.yeejoin.equipmanage.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.yeejoin.equipmanage.common.entity.EquipmentDetail;
import com.yeejoin.equipmanage.common.entity.EquipmentQrcode;
import com.yeejoin.equipmanage.mapper.EquipmentDetailMapper;
import com.yeejoin.equipmanage.mapper.EquipmentQrcodeMapper;
import com.yeejoin.equipmanage.common.utils.QRCodeUtil;
import com.yeejoin.equipmanage.service.ProductionQRCode;

/**
 * 装备二维码
 * 
 **/
@Service
public class EquipmentProductionQRCode implements ProductionQRCode {
	@Autowired
	EquipmentDetailMapper equipmentDetailMapper;
	@Autowired
	EquipmentQrcodeMapper equipmentQrcodeMapper;

	@Override
	public List<EquipmentQrcode> getProductionQRCode(Long id, Integer amount,Date productDate) {
		List<EquipmentQrcode> list = new ArrayList<EquipmentQrcode>();
		for (int i = 1; i <= amount; i++) {
			EquipmentQrcode code = new EquipmentQrcode();
			code.setCreateDate(new Date());
			code.setEquipmentDetailId(id);
			code.setQRCode(QRCodeUtil.generateQRCode());
			code.setFullQRCode("01#" + code.getQRCode());
			code.setProductDate(productDate);
			equipmentQrcodeMapper.insert(code);
			list.add(code);
		}
		return list;
	}

}
