package com.yeejoin.amos.boot.module.jxiop.biz.controller;

import com.yeejoin.amos.boot.module.jxiop.api.dto.StationInfoDto;
import com.yeejoin.amos.boot.module.jxiop.api.entity.StationBasic;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.HouseholdPvDistrictServiceImpl;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.HouseholdPvServiceImpl;
import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.StationCoordinateServiceImpl;
import com.yeejoin.amos.component.feign.config.InnerInvokException;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;

import java.util.List;

import com.yeejoin.amos.boot.module.jxiop.biz.service.impl.StationBasicServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;

import javax.servlet.http.HttpServletRequest;

import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jxiop.api.dto.StationBasicDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 场站基础信息表
 *
 * @author system_generator
 * @date 2023-04-20
 */
@RestController
@Api(tags = "场站基础信息表Api")
@RequestMapping(value = "/station-basic")
public class StationBasicController extends BaseController {
    @Autowired
    HouseholdPvDistrictServiceImpl householdPvDistrictServiceImpl;

    @Autowired
    StationBasicServiceImpl stationBasicServiceImpl;

    /**
     * 新增场站基础信息表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增场站基础信息表", notes = "新增场站基础信息表")
    public ResponseModel<Object> save(@RequestBody StationBasic model) {
        try {
            stationBasicServiceImpl.add(model);
            return ResponseHelper.buildResponse(null);
        } catch (InnerInvokException e) {
            return this.buildResponseFalse(e.getMessage().replace("公司","场站"));
        }
    }

    public ResponseModel buildResponseFalse(String message) {
        ResponseModel response = new ResponseModel();
        response.setResult(null);
        response.setDevMessage("FAILURE");
        response.setStatus(HttpStatus.BAD_REQUEST.value());
        response.setMessage(message);
        response.setDevMessage(message);
        return response;
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/update")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新场站基础信息表", notes = "根据sequenceNbr更新场站基础信息表")
    public ResponseModel<StationBasicDto> updateBySequenceNbrStationBasic(@RequestBody StationBasic model, @RequestParam(value = "sequenceNbr") Long sequenceNbr) {
        try {
            model.setSequenceNbr(sequenceNbr);


            stationBasicServiceImpl.update(model);
            return ResponseHelper.buildResponse(null);
        } catch (InnerInvokException e) {
            return this.buildResponseFalse(e.getMessage().replace("公司","场站"));
        }
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param ids 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/delete")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除场站基础信息表", notes = "根据sequenceNbr删除场站基础信息表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @RequestParam(value = "ids") String ids) {
        String checkResult = householdPvDistrictServiceImpl.removeCheck(Long.valueOf(ids));
        if(!("ok".equals(checkResult))){
            return  this.buildResponseFalse(checkResult);
        }
        if (stationBasicServiceImpl.getStationPersonByStationID(ids) > 0) {
            return this.buildResponseFalse("请删除场站下的人员后再删除场站！");
        }
        int num = stationBasicServiceImpl.deleteList(ids);
        return ResponseHelper.buildResponse(num > 0 ? true : false);
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "/getById")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个场站基础信息表", notes = "根据sequenceNbr查询单个场站基础信息表")
    public ResponseModel<StationBasic> selectOne(@RequestParam Long sequenceNbr) {
        StationBasic stationBasic = stationBasicServiceImpl.getById(sequenceNbr);
        return ResponseHelper.buildResponse(stationBasic);
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "场站基础信息表分页查询", notes = "场站基础信息表分页查询")
    public ResponseModel<Page<StationBasicDto>> queryForPage(@RequestParam(value = "current") int current,
                                                             @RequestParam(value = "size") int size,
                                                             @RequestParam(value = "stationMasterName", required = false) String stationMasterName,
                                                             @RequestParam(value = "stationName", required = false) String stationName,
                                                             @RequestParam(value = "stationType", required = false) String stationType,
                                                             @RequestParam(value = "orgCode", required = false) String orgCode

    ) {
        Page<StationBasicDto> page = new Page<StationBasicDto>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(stationBasicServiceImpl.queryPage(page, stationMasterName,
                stationName,
                stationType,
                orgCode
        ));
    }

    /**
     * 场站地图接口
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "场站基础信息表列表全部数据查询", notes = "场站基础信息表列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<StationBasicDto>> selectForList() {
        return ResponseHelper.buildResponse(stationBasicServiceImpl.queryForStationBasicList());
    }

    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "场站地图数据", notes = "场站地图数据")
    @GetMapping(value = "/listforMap")
    public ResponseModel<List<StationInfoDto>> getStationList(@RequestParam(value = "areaCode", required = false) String areaCode,@RequestParam(value = "type", required = false,defaultValue = "qj") String type) {
        return ResponseHelper.buildResponse(stationBasicServiceImpl.getStationList(areaCode,type));
    }
}
