package com.yeejoin.amos.boot.module.jg.biz.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jg.api.dto.JgUseRegistrationDto;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgUseRegistrationServiceImpl;
import com.yeejoin.amos.boot.module.jg.flc.api.fegin.WorkFlowFeginService;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.workflow.Workflow;
import com.yeejoin.amos.feign.workflow.model.ActWorkflowStartDTO;
import com.yeejoin.amos.feign.workflow.model.AjaxResult;
import com.yeejoin.amos.feign.workflow.model.TaskResultDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author system_generator
 * @date 2023-12-12
 */
@RestController
@Api(tags = "Api")
@RequestMapping(value = "/jg-use-registration")
public class JgUseRegistrationController extends BaseController {

    @Autowired
    JgUseRegistrationServiceImpl jgUseRegistrationServiceImpl;


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "批量删除", notes = "批量删除")
    public ResponseModel<Object> save(@RequestBody JSONObject map) {
        jgUseRegistrationServiceImpl.save(map);
        return ResponseHelper.buildResponse("ok");
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/deleteBatch")
    @ApiOperation(httpMethod = "POST", value = "批量删除", notes = "批量删除")
    public ResponseModel<Object> deleteBatch(@RequestBody JSONObject map) {
        List<Long> ids = (List<Long>) map.get("ids");
        jgUseRegistrationServiceImpl.deleteBatch(ids);
        return ResponseHelper.buildResponse("ok");
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/deleteMessage")
    @ApiOperation(httpMethod = "POST", value = "批量删除", notes = "批量删除")
    public ResponseModel<Object> deleteMessage(@RequestParam("id") Long id) {
        ArrayList<Long> ids = new ArrayList<>();
        ids.add(id);
        jgUseRegistrationServiceImpl.deleteBatch(ids);
        return ResponseHelper.buildResponse("ok");
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "列表全部数据查询", notes = "列表全部数据查询")
    @GetMapping(value = "/getList")
    public ResponseModel<Page<Map<String, Object>>> getList(JgUseRegistrationDto dto,
                                                            @RequestParam(value = "current") int current,
                                                            @RequestParam(value = "size") int size) {
        Page<Map<String, Object>> page = new Page<>(current, size);
        return ResponseHelper.buildResponse(jgUseRegistrationServiceImpl.getList(dto, page));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "列表全部数据查询", notes = "列表全部数据查询")
    @GetMapping(value = "/getEquipList")
    public ResponseModel<Page<Map<String, Object>>> getEquipList(
            @RequestParam(value = "current") int current,
            @RequestParam(value = "size") int size,
            @RequestParam(value = "factoryNum", required = false) String factoryNum,
            @RequestParam(value = "equList", required = false) String equList,
            @RequestParam(value = "equCategory", required = false) String equCategory) {
        Page<Map<String, Object>> page = new Page<>(current, size);
        return ResponseHelper.buildResponse(jgUseRegistrationServiceImpl.getEquipList(page, factoryNum, equList, equCategory));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "列表全部数据查询", notes = "列表全部数据查询")
    @GetMapping(value = "/getDetail")
    public ResponseModel<Map<String, Object>> getDetail(@RequestParam("id") String id) {
        return ResponseHelper.buildResponse(jgUseRegistrationServiceImpl.getDetail(id));
    }

@Autowired
    WorkFlowFeginService workFlowFeginService;
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/test")
    @ApiOperation(httpMethod = "GET", value = "", notes = "")
    public ResponseModel test(@RequestParam("op") String op) {
        String instanceId = "";
        //启动流程
        try {
            ActWorkflowStartDTO dto = new ActWorkflowStartDTO();
            dto.setProcessDefinitionKey("useRegistration");
            dto.setBusinessKey("1");
            AjaxResult ajaxResult = Workflow.taskClient.startByVariable(dto);
            instanceId = ((Map) ajaxResult.get("data")).get("id").toString();

        } catch (Exception e) {
            e.printStackTrace();
        }

        return ResponseHelper.buildResponse(instanceId);
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/test1")
    @ApiOperation(httpMethod = "GET", value = "", notes = "")
    public void overProjectFlowExecute(@RequestParam("op") String op, @RequestParam("instanceId") String instanceId) {

        try {
            AjaxResult ajaxResult = Workflow.taskClient.getTask(instanceId);
            JSONObject dataObject = JSON.parseObject(JSON.toJSONString(ajaxResult.get("data")));
            String taskId = dataObject.getString("id");
//            JSONObject taskNoAuth = workFlowFeginService.getTaskNoAuth(instanceId);
//            FeignClientResult<JSONObject> nodeInfo = workFlowFeginService.getNodeInfo(taskId);

            //组装信息
            TaskResultDTO dto = new TaskResultDTO();
//            dto.setResult(op);
            dto.setResultCode("approvalStatus");
            dto.setTaskId(taskId);
            dto.setComment("啦啦啦啦！！！！！");
            HashMap<String, Object> map = new HashMap<>();
            map.put("approvalStatus", op);
            dto.setVariable(map);
//            FeignClientResult reject = Workflow.taskV2Client.reject(taskId, dto);
            //执行流程
            AjaxResult ajaxResult1 = Workflow.taskClient.completeByTask(taskId, dto);

            if (ObjectUtils.isEmpty(ajaxResult1)) {

            }

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
