package com.yeejoin.amos.boot.module.jyjc.api.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.typroject.tyboot.core.rdbms.model.BaseModel;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 
 *
 * @author system_generator
 * @date 2023-12-14
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="JyjcInspectionApplicationModel", description="")
public class JyjcInspectionApplicationModel extends BaseModel {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "检验检测单位编码")
    private String inspectionUnitCode;

    @ApiModelProperty(value = "检验检测类型")
    private String inspectionType;

    @ApiModelProperty(value = "设备种类")
    private String equipClassify;

    @ApiModelProperty(value = "报检单号")
    private String applicationNo;

    @ApiModelProperty(value = "申请日期")
    private Date applicationDate;

    @ApiModelProperty(value = "检验检测类别")
    private String inspectionClassify;

    @ApiModelProperty(value = "申请联系人")
    private String applicationContactName;

    @ApiModelProperty(value = "申请联系人电话")
    private String applicationContactPhone;

    @ApiModelProperty(value = "申请说明")
    private String applicationRemark;

    @ApiModelProperty(value = "项目负责人(检验员)")
    private String inspectionChargePerson;

    @ApiModelProperty(value = "项目负责人联系电话（检验员联系电话）")
    private String inspectionChargePhone;

    @ApiModelProperty(value = "说明（受理说明、退回原因、转办说明）")
    private String processDescription;

    @ApiModelProperty(value = "原始报检单号")
    private String originalApplicationNo;

    @ApiModelProperty(value = "受理日期")
    private Date acceptDate;

    @ApiModelProperty(value = "报检单位编号")
    private String applicationUnitCode;

    @ApiModelProperty(value = "包含设备数量（冗余）")
    private Integer numberOfEquip;

    @ApiModelProperty(value = "工作流执行角色")
    private String workflowRole;

    @ApiModelProperty(value = "工作流实例ID")
    private String processInstanceId;

    @ApiModelProperty(value = "申请单二维码")
    private String applicationQrcode;

    @ApiModelProperty(value = "状态")
    private String status;

    @ApiModelProperty(value = "备注(无用预留)")
    private String remark;

    @ApiModelProperty(value = "业务类型（与菜单对应拆表使用）")
    private String bizType;

}
