package com.yeejoin.amos.boot.module.jyjc.api.model;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.yeejoin.amos.boot.module.common.api.dto.AttachmentDto;
import com.yeejoin.amos.boot.module.tcm.api.dto.TzBaseUnitLicenceDto;
import com.yeejoin.amos.boot.module.tcm.api.dto.TzsUserInfoDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.typroject.tyboot.core.rdbms.model.BaseModel;
import java.util.Date;
import java.util.List;

/**
 * @author system_generator
 * @date 2023-12-13
 */
@Data
@EqualsAndHashCode (callSuper = true)
@ApiModel (value = "JyjcOpeningApplicationModel", description = "")
public class JyjcOpeningApplicationModel extends BaseModel {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty (value = "单位编码")
    private String unitCode;

    @ApiModelProperty (value = "单位编码Name")
    private String unitCodeName;

    @ApiModelProperty (value = "检测区域编码")
    @TableField(value = "detection_region", typeHandler = FastjsonTypeHandler.class)
    private List<String> detectionRegion;

    @ApiModelProperty (value = "检测区域名称（冗余）")
    private String detectionRegionName;

    @ApiModelProperty (value = "申请单号")
    private String applicationSeq;

    @ApiModelProperty (value = "检验结果方式")
    private String resultType;

    @ApiModelProperty (value = "有效期至")
    private Date expiryDate;

    @ApiModelProperty (value = "受理日期（接收日期）")
    private Date acceptDate;

    @ApiModelProperty (value = "状态")
    private String status;

    @ApiModelProperty (value = "备注")
    private String remark;

    @ApiModelProperty (value = "申请时间")
    private String applyTime;

    @ApiModelProperty (value = "工作流执行角色")
    private String workflowRole;

    @ApiModelProperty (value = "工作流实例ID")
    private String workflowProstanceId;
    /* ----------------  -------------- */
    @ApiModelProperty (value = "企业资质信息")
    List<TzBaseUnitLicenceDto> baseUnitLicences;

    @ApiModelProperty (value = "检验人员信息")
    List<TzsUserInfoDto> userInfos;

    @ApiModelProperty (value = "使用单位联系人")
    private String useContact;

    @ApiModelProperty (value = "联系人联系电话")
    private String contactPhone;

    @ApiModelProperty (value = "行业主管部门")
    private String industrySupervisor;

    @ApiModelProperty (value = "单位地理坐标经度")
    private String longitude;

    @ApiModelProperty (value = "单位地理坐标纬度")
    private String latitude;

    @ApiModelProperty ("企业营业执照")
    private List<AttachmentDto> unitBusinessLicense;
}
