package com.yeejoin.amos.boot.module.jg.api.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.github.pagehelper.util.StringUtil;
import com.yeejoin.amos.boot.module.jg.api.dto.PipingExcelDto;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import static com.yeejoin.amos.boot.module.jg.api.common.BizCommonConstant.PIPE_LENGTH;
import static com.yeejoin.amos.boot.module.jg.api.common.BizCommonConstant.PIPE_LENGTH_SPILT;

/**
 * 管道长度计算公共类-便于统一维护口
 */
public final class PipLenCalUtils {

    public static double getPipLen(JSONArray oldPipData) {
        return oldPipData.stream()
                .map(p -> JSON.parseObject(p.toString()))
                .filter(s -> StringUtil.isNotEmpty(s.getString(PIPE_LENGTH)))
                .map(d ->
                        Arrays.stream(d.getString(PIPE_LENGTH).split(PIPE_LENGTH_SPILT))  // 分割字符串
                                .map(BigDecimal::new)                           // 转 BigDecimal
                                .reduce(BigDecimal.ZERO, BigDecimal::add)       // 分段求和
                )
                .reduce(BigDecimal.ZERO, BigDecimal::add).stripTrailingZeros()               // 全局求和
                .doubleValue();
    }



    public static double getPipLen(List<PipingExcelDto> equLists) {
        return equLists.stream()
                .map(PipingExcelDto::getPipeLength)
                .filter(StringUtil::isNotEmpty)
                .map(d ->
                        Arrays.stream(d.split(PIPE_LENGTH_SPILT))  // 分割字符串
                                .map(BigDecimal::new)                           // 转 BigDecimal
                                .reduce(BigDecimal.ZERO, BigDecimal::add)       // 分段求和
                )
                .reduce(BigDecimal.ZERO, BigDecimal::add).stripTrailingZeros()                  // 全局求和
                .doubleValue();
    }

    public static String cal(String pipeLengthText) {
        return Optional.ofNullable(pipeLengthText).filter(StringUtils::isNotEmpty).map(l -> Arrays.stream(l.split(PIPE_LENGTH_SPILT)).map(BigDecimal::new).reduce(BigDecimal.ZERO, BigDecimal::add)).orElse(BigDecimal.ZERO).stripTrailingZeros().toPlainString();
    }

    public static BigDecimal calBigDecimal(String pipeLengthText) {
        return Optional.ofNullable(pipeLengthText).filter(StringUtils::isNotEmpty).map(l -> Arrays.stream(l.split(PIPE_LENGTH_SPILT)).map(BigDecimal::new).reduce(BigDecimal.ZERO, BigDecimal::add)).orElse(BigDecimal.ZERO).setScale(3,  RoundingMode.HALF_UP);
    }
}
