package com.yeejoin.amos.boot.module.hygf.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * 农户信息
 *
 * @author system_generator
 * @date 2023-07-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="PeasantHouseholdDto", description="农户信息")
public class PeasantHouseholdDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "勘察表id")
    private Long surveyInformationId;

    @ApiModelProperty(value = "农户信息编号")
    private String peasantHouseholdNo;

    @ApiModelProperty(value = "业主姓名")
    private String ownersName;

    @ApiModelProperty(value = "联系电话")
    private String telephone;

    @ApiModelProperty(value = "开发方名称")
    private String developerName;

    @ApiModelProperty(value = "开发方code")
    private String developerCode;

    @ApiModelProperty(value = "定金")
    private Float deposit;

    @DateTimeFormat(pattern = "yyyy-MM-dd HH")
    @ApiModelProperty(value = "创建时间")
    private Date creationTime;

    @ApiModelProperty(value = "项目地址")
    private String projectAddress;

    @ApiModelProperty(value = "项目地址Arr")
    private List<Integer> projectAddressArr;

    @ApiModelProperty(value = "常住是否相同")
    private List<String> isPermanent;

    @ApiModelProperty(value = "常住地址")
    private String permanentAddress;

    @ApiModelProperty(value = "常住地址Arr")
    private List<Integer> permanentAddressArr;

    @ApiModelProperty(value = "是否勘察 0,1")
    private Integer surveyOrNot;

    @ApiModelProperty(value = "身份证号")
    private String idCard;

    @ApiModelProperty(value = "邮箱")
    private String mailbox;

    @ApiModelProperty(value = " 审核状态 0未审核,1审核中，2审核结束")
    private Integer review;

    @ApiModelProperty(value = "项目详细地址")
    private String projectAddressDetail;

    @ApiModelProperty(value = "常住详细地址")
    private String permanentAddressDetail;
    @ApiModelProperty(value = "开发人")
    private String developer;

    @ApiModelProperty(value = "常住地址")
    private String permanentAddressName;

    @ApiModelProperty(value = "项目地址")
    private String projectAddressName;
}
