package com.yeejoin.amos.boot.module.jg.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 移装造告知
 *
 * @author system_generator
 * @date 2023-12-19
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tzs_jg_transfer_notice")
public class JgTransferNotice extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 申请编号
     */
	@TableField("apply_no")
    private String applyNo;

    /**
     * 告知日期
     */
	@TableField("notice_date")
    private Date noticeDate;

    /**
     * 告知状态
     */
	@TableField("notice_status")
    private String noticeStatus;

    /**
     * 施工单位统一信用代码
     */
	@TableField("install_unit_credit_code")
    private String installUnitCreditCode;

    /**
     * 施工单位名称
     */
	@TableField("install_unit_name")
    private String installUnitName;

    /**
     * 设备数量
     */
	@TableField("equip_num")
    private Integer equipNum;

    /**
     * 流程实例id
     */
	@TableField("instance_id")
    private String instanceId;

    /**
     * 下步执行角色/人id
     */
	@TableField("next_executor_ids")
    private String nextExecutorIds;

    /**
     * 流程执行顺序标识
     */
	@TableField("execute_sequence")
    private String executeSequence;

    /**
     * 创建时间
     */
	@TableField("create_date")
    private Date createDate;

    /**
     * 创建人id 
     */
	@TableField("create_user_id")
    private String createUserId;

    /**
     * 创建人
     */
	@TableField("create_user_name")
    private String createUserName;

    /**
     * 备注
     */
	@TableField("remark")
    private String remark;

    /**
     * 流程状态
     */
	@TableField("instance_status")
    private String instanceStatus;

    /**
     * 受理完成日期
     */
	@TableField("accept_date")
    private Date acceptDate;

    /**
     * 施工区域-省
     */
	@TableField("province")
    private String province;

    /**
     * 施工区域-市
     */
	@TableField("city")
    private String city;

    /**
     * 施工区域-区/县
     */
	@TableField("county")
    private String county;

    /**
     * 施工区域-街道（镇）
     */
	@TableField("street")
    private String street;

    /**
     * 施工设备详细地址
     */
	@TableField("address")
    private String address;

    /**
     * 计划施工日期
     */
	@TableField("plan_date")
    private Date planDate;

    /**
     * 接收机构单位代码
     */
	@TableField("receive_company_code")
    private String receiveCompanyCode;

    /**
     * 接收机构
     */
	@TableField("receive_org_name")
    private String receiveOrgName;

    /**
     * 施工负责人
     */
	@TableField("construction_manager")
    private String constructionManager;

    /**
     * 施工负责人id
     */
	@TableField("construction_manager_id")
    private String constructionManagerId;

    /**
     * 施工负责人手机
     */
	@TableField("construction_manager_phone")
    private String constructionManagerPhone;

    /**
     * 检验单位统一信用代码
     */
	@TableField("inspection_unit_credit_code")
    private String inspectionUnitCreditCode;

    /**
     * 检验单位名称
     */
	@TableField("inspection_unit_name")
    private String inspectionUnitName;

    /**
     * 委托单位统一信用代码
     */
	@TableField("entrusting_unit_credit_code")
    private String entrustingUnitCreditCode;

    /**
     * 委托单位名称
     */
	@TableField("entrusting_unit_name")
    private String entrustingUnitName;

    /**
     * 委托书附件
     */
	@TableField("power_of_attorney")
    private String powerOfAttorney;

    /**
     * 施工合同附件
     */
	@TableField("construction_contract")
    private String constructionContract;

    /**
     * 施工合同是否本单位与甲方直接签署
     */
	@TableField("is_signed_with_a")
    private String isSignedWithA;

    /**
     * 使用单位统一信用代码
     */
	@TableField("use_unit_credit_code")
    private String useUnitCreditCode;

    /**
     * 使用单位名称
     */
	@TableField("use_unit_name")
    private String useUnitName;

    /**
     * 是否已报检
     */
	@TableField("is_inspected")
    private String isInspected;

    /**
     * 移装类型（1区内移装，2跨区移装）
     */
	@TableField("transfer_type")
    private String transferType;

    /**
     * 接收机构机构代码
     */
	@TableField("receive_org_code")
    private String receiveOrgCode;

    /**
     * 是否西咸
     */
    @TableField("is_xixian")
    private String isXixian;

    /**
     *  	 * 设备使用地点-街道（镇）
     *      */

    @TableField(value ="\"factory_use_site_street\"")
    private String factoryUseSiteStreet;

    /**
     *  	 * 设备使用地点-街道（镇）-名称
     *      */

    @TableField(value ="\"street_name\"")
    private String streetName;

    @TableField("county_name")
    private String countyName;

    @TableField("city_name")
    private String cityName;

    @TableField("province_name")
    private String provinceName;

    @TableField("next_execute_ids")
    private String nextExecuteIds;

    @TableField("notice_report_url")
    private String noticeReportUrl;

    @TableField("status")
    private String status;

    @TableField(value = "promoter")
    private String promoter;

    @TableField(exist = false)
    private String equipCateName;

    @TableField(value = "handle_date")
    private Date handleDate;

    @TableField(value = "\"create_user_company_name\"")
    private String createUserCompanyName;

    //下一步任务ID
    @TableField(value = "\"next_taskId\"")
    private String nextTaskId;


    @TableField(exist = false)
    private String supervisoryCode;


    @TableField(exist = false)
    private String equList;

    /**
     * 下一节点可执行人
     */
    @TableField("\"next_execute_user_ids\"")
    private String nextExecuteUserIds;

    @TableField(exist = false)
    private String equAddress;


    @TableField(value = "transfer_to_user_ids")
    private String transferToUserIds;

}
