package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jg.api.dto.*;
import com.yeejoin.amos.boot.module.jg.api.entity.*;
import com.yeejoin.amos.boot.module.jg.api.enums.BusinessTypeEnum;
import com.yeejoin.amos.boot.module.jg.api.enums.EquipTypeEnum;
import com.yeejoin.amos.boot.module.jg.api.enums.WorkFlowStatusEnum;
import com.yeejoin.amos.boot.module.jg.api.mapper.*;
import com.yeejoin.amos.boot.module.jg.api.service.IJgChangeRegistrationUnitService;
import com.yeejoin.amos.boot.module.jg.biz.feign.TzsServiceFeignClient;
import com.yeejoin.amos.boot.module.jg.biz.service.ICommonService;
import com.yeejoin.amos.boot.module.jg.flc.api.fegin.WorkFlowFeignService;
import com.yeejoin.amos.boot.module.ymt.api.entity.*;
import com.yeejoin.amos.boot.module.ymt.api.enums.ApplicationFormTypeEnum;
import com.yeejoin.amos.boot.module.ymt.api.enums.EquipmentClassifityEnum;
import com.yeejoin.amos.boot.module.ymt.api.enums.FlowStatusEnum;
import com.yeejoin.amos.boot.module.ymt.api.mapper.*;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.systemctl.model.TaskV2Model;
import com.yeejoin.amos.feign.workflow.Workflow;
import com.yeejoin.amos.feign.workflow.model.*;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.time.LocalDate;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 单位变更登记服务实现类
 *
 * @author system_generator
 * @date 2023-12-22
 */
@Service
public class JgChangeRegistrationUnitServiceImpl extends BaseService<JgChangeRegistrationUnitDto, JgChangeRegistrationUnit, JgChangeRegistrationUnitMapper> implements IJgChangeRegistrationUnitService {
    private static final String SUBMIT_TYPE_FLOW = "1";
    private static final String PROCESS_DEFINITION_KEY = "unitChange";
    private static final String TABLE_PAGE_ID = "1734141426742095873";


    @Autowired
    EquipmentCategoryMapper equipmentCategoryMapper;
    @Autowired
    private RedisUtils redisUtils;

    @Autowired
    JgChangeRegistrationUnitEqMapper JgChangeRegistrationUnitEqMapper;

    @Autowired
    CmWorkflowServiceImpl cmWorkflowService;
    @Autowired
    private JgChangeRegistrationUnitMapper JgChangeRegistrationUnitMapper;
    //    @Autowired
//    private EquipmentCategoryServiceImpl equipmentCategoryService;
    @Autowired
    RegistrationInfoMapper tzsJgRegistrationInfoMapper;
    @Autowired
    OtherInfoMapper tzsJgOtherInfoMapper;
    @Autowired
    UseInfoMapper useInfoMapper;
    @Autowired
    TzsServiceFeignClient tzsServiceFeignClient;
    @Autowired
    SupervisoryCodeInfoMapper supervisoryCodeInfoMapper;
    @Autowired
    CommonServiceImpl commonServiceImpl;

    @Autowired
    WorkFlowFeignService workFlowFeginService;

    @Autowired
    private JgRegistrationHistoryMapper jgRegistrationHistoryMapper;

    @Autowired
    private IdxBizJgRegisterInfoMapper idxBizJgRegisterInfoMapper;

    //改造登记关系表mapper
    @Autowired
    private JgChangeRegistrationReformEqMapper jgChangeRegistrationReformEqMapper;
    //移装登记关系表
    @Autowired
    private JgChangeRegistrationTransferEqMapper jgChangeRegistrationTransferEqMapper;
    //使用登记关系表mapper
    @Autowired
    private JgUseRegistrationEqMapper jgUseRegistrationEqMapper;
    //单位变更登记关系表mapper
    @Autowired
    private JgChangeRegistrationUnitEqMapper jgChangeRegistrationUnitEqMapper;
    //更名变更登记关系表mapper
    @Autowired
    private JgChangeRegistrationNameEqMapper jgChangeRegistrationNameEqMapper;

    @Autowired
    private IdxBizJgUseInfoServiceImpl idxBizJgUseInfoService;
    @Autowired
    private IdxBizJgRegisterInfoServiceImpl idxBizJgRegisterInfoService;
    @Autowired
    private IdxBizJgFactoryInfoServiceImpl idxBizJgFactoryInfoService;

    @Autowired ICommonService commonService;


    public static byte[] file2byte(File file) {
        try {
            FileInputStream in = new FileInputStream(file);
            //当文件没有结束时，每次读取一个字节显示
            byte[] data = new byte[in.available()];
            in.read(data);
            in.close();
            return data;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return 单位变更
     */
    @Override
    public Map<String, Map<String, Object>> queryBySequenceNbr(Long sequenceNbr) {
        // 变更单位信息
        JgChangeRegistrationUnit notice = JgChangeRegistrationUnitMapper.selectById(sequenceNbr);
        if (Objects.isNull(notice)) {
            return null;
        }
        Map<String, Object> changeInfo = BeanUtil.beanToMap(notice);

        if (!ValidationUtil.isEmpty(notice.getReceiveOrgCode()) && !ValidationUtil.isEmpty(notice.getReceiveOrgName())) {
            changeInfo.put("receiveOrgCode", notice.getReceiveOrgCode() + "_" + notice.getReceiveOrgName());
        }
        if (!ValidationUtil.isEmpty(notice.getUseUnitCreditCode()) && !ValidationUtil.isEmpty(notice.getUseUnitName())) {
            changeInfo.put("useUnitCreditCode", notice.getUseUnitCreditCode() + "_" + notice.getUseUnitName());
        }
        if (!ValidationUtil.isEmpty(notice.getNewUseUnitCreditCode()) && !ValidationUtil.isEmpty(notice.getNewUseUnitName())) {
            changeInfo.put("newUseUnitCreditCode", notice.getNewUseUnitCreditCode() + "_" + notice.getNewUseUnitName());
        }
        changeInfo.put("changeCertificateList", notice.getChangeCertificate());

        String[] fields = {"productPhoto", "designDoc", "designStandard", "factoryStandard",
                "productQualityYieldProve", "insUseMaintainExplain", "inspectReport",
                "proxyStatementAttachment", "installContractAttachment", "changeCertificateList"};

        // 设备信息
        List<Map<String, Object>> equipmentInfos = JgChangeRegistrationUnitMapper.queryEquipInformation(sequenceNbr);

        for (String s : fields) {
            if (changeInfo.containsKey(s) && !ObjectUtils.isEmpty(changeInfo.get(s))) {
                changeInfo.put(s, JSON.parseArray(changeInfo.get(s).toString()));
            }
            if (equipmentInfos.get(0).containsKey(s)  && !ObjectUtils.isEmpty(equipmentInfos.get(0).get(s))) {
                equipmentInfos.get(0).put(s, JSON.parseArray(equipmentInfos.get(0).get(s).toString()));
            }
        }

        Map<String, Object> newMap = new HashMap<>();
        newMap.putAll(changeInfo);
        newMap.putAll(equipmentInfos.get(0));

        return new HashMap<String, Map<String, Object>>() {{
            this.put("changeRegisInfo", newMap);
        }};
    }

    /**
     * 更新单位变更
     *
     * @param noticeDto 单位变更
     */
    @SuppressWarnings({"rawtypes", "Duplicates"})
    public JgChangeRegistrationUnitDto updateInstallationNotice(String submitType, JgChangeRegistrationUnitDto noticeDto, String op) {
        if (Objects.isNull(noticeDto) || StringUtils.isEmpty(submitType)) {
            throw new IllegalArgumentException("参数不能为空");
        }
        String[] taskName = new String[]{"流程结束"};
        // 字段转换
        this.convertField(noticeDto);
        ArrayList<String> roleListAll = new ArrayList<>();
        ArrayList<String> roleListNext = new ArrayList<>();
        if (SUBMIT_TYPE_FLOW.equals(submitType)) {
            AjaxResult ajaxResult;
            // 发起流程
            if (!StringUtils.hasText(noticeDto.getInstanceId())) {
                List<ProcessTaskDTO> processTasks = new ArrayList<>();
                ActWorkflowBatchDTO actWorkflowBatchDTO = new ActWorkflowBatchDTO();
                List<ActWorkflowStartDTO> list = new ArrayList<>();
                ActWorkflowStartDTO dto = new ActWorkflowStartDTO();
                dto.setProcessDefinitionKey(PROCESS_DEFINITION_KEY);
                dto.setBusinessKey(String.valueOf(new Date().getTime()));
                dto.setCompleteFirstTask(true);
                list.add(dto);
                actWorkflowBatchDTO.setProcess(list);
                dto.setNextExecuteUserCompanyCode(noticeDto.getReceiveOrgCode());
                processTasks = cmWorkflowService.startBatch(actWorkflowBatchDTO);
                String instanceId = processTasks.get(0).getProcessInstance().getId();
                String nextTaskId = processTasks.get(0).getNextTask().get(0).getId();
                String taskname = processTasks.get(0).getNextTask().get(0).getName();
                this.buildRoleList(processTasks, roleListNext, roleListAll);
                List<WorkflowResultDto> workflowResultDtos = commonServiceImpl.buildWorkFlowInfo(processTasks);
                String nextUserIds = workflowResultDtos.get(0).getNextExecutorUserIds();

                JgChangeRegistrationUnit notice = new JgChangeRegistrationUnit();
            //    JgChangeRegistrationUnit noticeOld = JgChangeRegistrationUnitMapper.selectById(noticeDto.getSequenceNbr());
                BeanUtils.copyProperties(noticeDto, notice);
       //         boolean submit = submit(notice, op);
                notice.setChangeCertificate(noticeDto.getChangeCertificate());
                notice.setRemark(noticeDto.getRemark());
              //  notice.setStatus(taskName[0]);
                if (!ObjectUtils.isEmpty(notice.getInstanceStatus())) {
                    notice.setInstanceStatus(notice.getInstanceStatus() + "," + roleListAll);
                } else {
                    notice.setInstanceStatus(String.join(",", roleListAll));
                }
                notice.setInstanceId(instanceId);
                notice.setNextTaskId(nextTaskId);
                notice.setSupervisoryCode(noticeDto.getSupervisoryCode());
                notice.setPromoter(RequestContext.getExeUserId());
                notice.setNextExecutorIds(String.join(",", roleListNext));
                notice.setStatus(WorkFlowStatusEnum.UNITCHANGE_RECEIVE.getPass());
                notice.setNextExecuteUserIds(nextUserIds);
                JgChangeRegistrationUnitMapper.updateById(notice);
                commonServiceImpl.deleteTaskModel(notice.getSequenceNbr()+"");
                createTaskModel(notice,taskname,"1", nextUserIds);
            }else {
                ArrayList<String> roleList = new ArrayList<>();
                String taskId = noticeDto.getNextTaskId();
                //组装信息
                TaskResultDTO task = new TaskResultDTO();
                task.setResultCode("approvalStatus");
                task.setTaskId(taskId);
                task.setComment("");
                HashMap<String, Object> map = new HashMap<>();
                map.put("approvalStatus", op);
                if (!ObjectUtils.isEmpty(noticeDto.getInstanceStatus()) &&
                        (noticeDto.getStatus().equals(WorkFlowStatusEnum.UNIT_RENAME_SUBMIT.getReject()) ||
                                noticeDto.getStatus().equals(WorkFlowStatusEnum.UNIT_RENAME_SUBMIT.getRollBack()))) {
                    map.put("approvalStatus", "提交");
                }
                task.setVariable(map);
                //执行流程
                task.setNextExecuteUserCompanyCode(noticeDto.getReceiveOrgCode());
                ProcessTaskDTO processTaskDTO = cmWorkflowService.completeOrReject(taskId, task, op);
                JgChangeRegistrationUnit bean = new JgChangeRegistrationUnit();
                BeanUtils.copyProperties(noticeDto, bean);
                String taskCode = FlowStatusEnum.TO_BE_FINISHED.getName();
                String taskName1 = "";
                String nextTaskId = "";
                this.buildRoleList(Collections.singletonList(processTaskDTO), roleList, roleListAll);
                List<WorkflowResultDto> workflowResultDtos = commonServiceImpl.buildWorkFlowInfo(Collections.singletonList(processTaskDTO));
                String nextUserIds = workflowResultDtos.get(0).getNextExecutorUserIds();
                if(processTaskDTO != null && processTaskDTO.getNextTask() != null && processTaskDTO.getNextTask().size() >0){
                    taskCode = processTaskDTO.getNextTask().get(0).getKey();
                    taskName1 = processTaskDTO.getNextTask().get(0).getName();
                    nextTaskId = processTaskDTO.getNextTask().get(0).getId();
                }
                bean.setNextExecutorIds(String.join(",", roleList));
                if (!ObjectUtils.isEmpty(bean.getInstanceStatus())) {
                    bean.setInstanceStatus(bean.getInstanceStatus() + "," + String.join(",", roleList));
                } else {
                    bean.setInstanceStatus(String.join(",", roleList));
                }
                bean.setNextTaskId(nextTaskId);
                bean.setPromoter(RequestContext.getExeUserId());
                bean.setStatus(WorkFlowStatusEnum.getMessage(taskCode).getPass());
                executeOneStep(bean, taskName1, nextUserIds, op);
                bean.setNextExecuteUserIds(nextUserIds);
                JgChangeRegistrationUnitMapper.updateById(bean);
        }
        } else {
            JgChangeRegistrationUnit bean = new JgChangeRegistrationUnit();
            BeanUtils.copyProperties(noticeDto, bean);
            JgChangeRegistrationUnitMapper.updateById(bean);
        }
        return noticeDto;
    }


    /**
     * 分页查询
     *
     * @param page  分页对象
     * @param model 查询参数
     * @param type  类型：enterprise-企业端、supervision-监管端
     * @return 单位变更列表
     */
    @Override
    public Page<JgChangeRegistrationUnitDto> queryForJgChangeRegistrationUnitPage(Page<JgChangeRegistrationUnit> page, JgChangeRegistrationUnitDto model, String type, ReginParams reginParams) {

        String orgCode;
        orgCode = reginParams.getCompany().getCompanyCode();
        String currentUserId = reginParams.getUserModel().getUserId();
        Page<JgChangeRegistrationUnit> noticePage = JgChangeRegistrationUnitMapper.queryForPage(page, model, type, orgCode, model.getRoleIds(),currentUserId);

        Page<JgChangeRegistrationUnitDto> noticeDtoPage = new Page<>();
        BeanUtils.copyProperties(noticePage, noticeDtoPage, "records");
        List<JgChangeRegistrationUnitDto> records = noticePage.getRecords().stream().map(notice -> {
            JgChangeRegistrationUnitDto noticeDto = new JgChangeRegistrationUnitDto();
            BeanUtils.copyProperties(notice, noticeDto);
            return noticeDto;
        }).collect(java.util.stream.Collectors.toList());
        noticeDtoPage.setRecords(records);

        return noticeDtoPage;
    }

    /**
     * 列表查询 示例
     */
    public List<JgChangeRegistrationUnitDto> queryForJgChangeRegistrationUnitList() {
        return this.queryForList("", false);
    }

    /**
     * 批量删除
     *
     * @param sequenceNbrs 主键
     * @return 是否删除成功
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean deleteForBatch(Long[] sequenceNbrs) {
        if (Objects.isNull(sequenceNbrs) || sequenceNbrs.length == 0) {
            return false;
        }
        Collection<JgChangeRegistrationUnit> JgChangeRegistrationUnits = this.listByIds(Arrays.asList(sequenceNbrs));
        JgChangeRegistrationUnits.forEach(notice -> {
            notice.setIsDelete(true);
        });
        return this.updateBatchById(JgChangeRegistrationUnits);
    }


    @Override
    @SuppressWarnings({"Duplicates", "rawtypes"})
    @Transactional(rollbackFor = Exception.class)
    public List<JgChangeRegistrationUnit> saveNotice(String submitType, JSONObject map, ReginParams reginParams) {
        JgChangeRegistrationUnitDto model = BeanUtil.toBeanIgnoreError(map.get("changeRegisInfo"), JgChangeRegistrationUnitDto.class);
        String[] taskName = new String[]{"流程结束"};

        // 字段转换
        convertField(model);

        // 获取单位变更设备列表
        List<Map<String, Object>> deviceList = model.getDeviceList();
        if (CollectionUtils.isEmpty(deviceList)) {
            throw  new BadRequest("设备不能为空");
          //  return new ArrayList<>();
        }

        // 获取单位变更单号
        ResponseModel<List<String>> listResponseModel = tzsServiceFeignClient.applicationFormCode(ApplicationFormTypeEnum.DWBG.getCode(), deviceList.size());
        List<String> applyNoList = listResponseModel.getResult();
        if (CollectionUtils.isEmpty(applyNoList)) {
            log.error("生成申请变更单位编失败");
            return new ArrayList<>();
        }

        ArrayList<String> roleListFirst = new ArrayList<>();
        ArrayList<String> roleListSecond = new ArrayList<>();

        // 判断当前是否为提交
        List<String> instanceIdList = new ArrayList<>();
        List<String> nextExecutorUserIds = new ArrayList<>();
        List<String> taskIds = new ArrayList<>();
        List<WorkflowResultDto> workflowResultDtos = new ArrayList<>();
        String nextExecutorRoleIds = "";
        if (SUBMIT_TYPE_FLOW.equals(submitType)) {
            // 发起流程
            // ActWorkflowStartDTO dto = new ActWorkflowStartDTO();
            ActWorkflowBatchDTO actWorkflowBatchDTO = new ActWorkflowBatchDTO();
            List<ActWorkflowStartDTO> list = new ArrayList<>();
            for (int i = 0; i < deviceList.size(); i++
            ) {
                ActWorkflowStartDTO dto = new ActWorkflowStartDTO();
                dto.setProcessDefinitionKey(PROCESS_DEFINITION_KEY);
                dto.setBusinessKey(String.valueOf(i));
                dto.setNextExecuteUserCompanyCode(model.getReceiveOrgCode());
                 dto.setCompleteFirstTask(true);
                list.add(dto);
            }
            actWorkflowBatchDTO.setProcess(list);
            List<ProcessTaskDTO> processTaskDTOS = cmWorkflowService.startBatch(actWorkflowBatchDTO);
            workflowResultDtos = commonServiceImpl.buildWorkFlowInfo(processTaskDTOS);
            nextExecutorRoleIds = workflowResultDtos.get(0).getNextExecutorRoleIds();
            nextExecutorUserIds.add(workflowResultDtos.get(0).getNextExecutorUserIds());
            for (WorkflowResultDto processTaskDTO : workflowResultDtos) {
                instanceIdList.add(processTaskDTO.getInstanceId());
                taskIds.add(processTaskDTO.getNextTaskId());
            }
//          if (CollectionUtil.isNotEmpty(processTaskDTOS)){
//              for (ProcessTaskDTO processTaskDTO : processTaskDTOS) {
//                  instanceIdList.add(processTaskDTO.getProcessInstance().getId());
//              }
//              roleListFirst.addAll(processTaskDTOS.get(0).getCandidateGroups());
//              Map<String, List<String>> nextCandidateGroups = processTaskDTOS.get(0).getNextCandidateGroups();
//              for (String s : nextCandidateGroups.keySet()) {
//                  roleListSecond.addAll(nextCandidateGroups.get(s));
//              }
//              String id = processTaskDTOS.get(0).getNextTask().get(0).getId();
//              List<AgencyUserModel> agencyUserModels = processTaskDTOS.get(0).getNextTaskExecutor().get(id);
//              if ()
//          }
//            try {
//                FeignClientResult result = Workflow.taskV2Client.startByVariableBatch(actWorkflowBatchDTO);
//                List<Object> returnList = (List<Object>) result.getResult();
//                for (Object obj : returnList
//                ) {
//                    JSONObject jsonObject = JSON.parseObject(JSONObject.toJSONString(obj));
//                    String instanceId = jsonObject.getString("id");
//                    instanceIdList.add(instanceId);
//                    // 查询下节点任务
//                    if (returnList.get(0).equals(obj)) {
//                        getNext(roleListFirst, instanceId, taskName);
//                    }
//                    // 推动下一个节点
//                    AjaxResult ajaxResult = Workflow.taskClient.getTask(instanceId);
//                    JSONObject dataObject = JSON.parseObject(JSON.toJSONString(ajaxResult.get("data")));
//                    String taskId = dataObject.getString("id");
//                    //组装信息
//                    TaskResultDTO dto = new TaskResultDTO();
//                    dto.setResultCode("approvalStatus");
//                    dto.setTaskId(taskId);
//                    dto.setComment("");
//                    HashMap<String, Object> stringObjectHashMap = new HashMap<>();
//                    stringObjectHashMap.put("approvalStatus", "0");
//                    dto.setVariable(stringObjectHashMap);
//                    //执行流程
//                    AjaxResult ajaxResult1 = null;
//                    try {
//                        ajaxResult1 = Workflow.taskClient.completeByTask(taskId, dto);
//                        if (ajaxResult1.get("code").equals(200)) {
//                            getNext(roleListSecond, instanceId, taskName);
//                        } else {
//                            log.error("提交失败");
//                        }
//                    } catch (Exception e) {
//                        log.error("提交失败：{}", e);
//                    }
//                }
//            } catch (Exception e) {
//                log.error("提交失败：{}", e);
//            }
        }

        List<JgChangeRegistrationUnit> list = new ArrayList<>();
        List<JgChangeRegistrationUnitEq> equipList = new ArrayList<>();
        String finalNextExecutorRoleIds = nextExecutorRoleIds;
        deviceList.forEach(obj -> {
            JgChangeRegistrationUnitEq jgRelationEquip = new JgChangeRegistrationUnitEq();
            JgChangeRegistrationUnit dto = new JgChangeRegistrationUnit();
            BeanUtils.copyProperties(model, dto);
            int i = deviceList.indexOf(obj);
            String applyNo = applyNoList.get(i);
            dto.setApplyNo(applyNo);
            dto.setApplyDate(new Date());
            if (SUBMIT_TYPE_FLOW.equals(submitType)) {
                dto.setNextExecutorIds(finalNextExecutorRoleIds);
                dto.setInstanceStatus(String.join(",", roleListFirst));
                dto.setPromoter(reginParams.getUserModel().getUserId());
                dto.setStatus(taskName[0]);
            }
            dto.setNewUseUnitName(reginParams.getCompany().getCompanyName());
            dto.setNewUseUnitCreditCode(reginParams.getCompany().getCompanyCode());
            dto.setEquType((String.valueOf(obj.get("EQU_CATEGORY"))));
            dto.setProductNameB((String.valueOf(obj.get("PRODUCT_NAME"))));
            dto.setEquCodeB((String.valueOf(obj.get("EQU_CODE"))));
            dto.setUseInnerCode(ValidationUtil.isEmpty(obj.get("USE_INNER_CODE")) ? "" : String.valueOf(obj.get("USE_INNER_CODE")));
            dto.setEquAddress((String.valueOf(obj.get("ADDRESS"))));
            dto.setSupervisoryCode(String.valueOf(obj.get("SUPERVISORY_CODE")));
            dto.setEquList(String.valueOf(obj.get("EQU_LIST")));
            jgRelationEquip.setEquId(String.valueOf(obj.get("SEQUENCE_NBR")));
            jgRelationEquip.setUnitChangeRegistrationId(applyNo);
            if (!CollectionUtils.isEmpty(nextExecutorUserIds)) {
                dto.setNextExecuteUserIds(nextExecutorUserIds.get(0));
            }
            if (!CollectionUtils.isEmpty(instanceIdList)) {
                dto.setInstanceId(instanceIdList.get(i));
                dto.setStatus(WorkFlowStatusEnum.UNITCHANGE_RECEIVE.getPass());
            } else {
                dto.setStatus(WorkFlowStatusEnum.UNITCHANGE_SUBMIT.getPass());
            } if (!CollectionUtils.isEmpty(taskIds)) {
                dto.setNextTaskId(taskIds.get(i));
            } else {
            }
            list.add(dto);
            equipList.add(jgRelationEquip);
        });

        WorkflowResultDto workDto = new WorkflowResultDto();
        JgChangeRegistrationUnitMapper.insertBatchSomeColumn(list);

        List<TaskModelDto> modelDtos = new ArrayList<>();
        if (SUBMIT_TYPE_FLOW.equals(submitType)) {
            for (JgChangeRegistrationUnit obj : list) {
                TaskModelDto dto = new TaskModelDto();

                TaskMessageDto ta = new TaskMessageDto();
                ta.setInstanceId(obj.getInstanceId());
                ta.setStatus(obj.getStatus());
                ta.setPromoter(obj.getPromoter());
                ta.setNextExecuteUserIds(obj.getNextExecuteUserIds());
                ta.setSequenceNbr(obj.getSequenceNbr());
                ta.setNextTaskId(obj.getNextTaskId());
                dto.setModel(ta);
               // dto.setModel(obj);
                dto.setFlowCreateDate(new Date());
                dto.setTaskName(workflowResultDtos.get(0).getNextTaskName());
                dto.setFlowCode(obj.getNextTaskId());
                dto.setTaskContent("来自"+obj.getEquList()+"【"+obj.getSupervisoryCode()+"】的业务办理,【申请单号:"+obj.getApplyNo()+"】");
                dto.setTaskCode(obj.getApplyNo());
                dto.setTaskType(BusinessTypeEnum.JG_COMPANY_CHANGE_REGISTRATION.getCode());
                dto.setTaskTypeLabel(BusinessTypeEnum.JG_COMPANY_CHANGE_REGISTRATION.getName());
                dto.setRelationId(obj.getInstanceId());
                dto.setExecuteUserIds(workflowResultDtos.get(0).getNextExecutorUserIds());
                dto.setTaskStatusLabel("未处理");
                dto.setFlowStatus(commonServiceImpl.getDictionaryCodeByName(WorkFlowStatusEnum.UNITCHANGE_RECEIVE.getPass()));
                dto.setFlowStatusLabel(WorkFlowStatusEnum.UNITCHANGE_RECEIVE.getPass());
                dto.setStartUserId(RequestContext.getExeUserId());
                dto.setStartUser(workflowResultDtos.get(0).getStartUserName());
                dto.setStartUserCompanyName(reginParams.getCompany().getCompanyName());
                dto.setStartDate(new Date());
                dto.setNextExecuteUser(workflowResultDtos.get(0).getNextExecutorRoleIds());
                modelDtos.add(dto);
            }
        }else {
            for (JgChangeRegistrationUnit obj : list) {
                TaskModelDto dto = new TaskModelDto();
                //行数据
                dto.setModel(obj);
                //摘要 按原有规则组装
                dto.setTaskContent("来自"+obj.getEquList()+"【"+obj.getSupervisoryCode()+"】的业务办理,【申请单号:"+obj.getApplyNo()+"】");
                //申请单号
                dto.setTaskCode(obj.getApplyNo());
                //业务类型枚举code值
                dto.setTaskType(BusinessTypeEnum.JG_COMPANY_CHANGE_REGISTRATION.getCode());
                ////业务主键
                dto.setRelationId(obj.getSequenceNbr()+"");
                modelDtos.add(dto);
            }
        }


        commonServiceImpl.buildTaskModel(modelDtos);


        List<JgChangeRegistrationUnitEq> jgRelationEquipList = equipList.stream().map(jgRelationEquip -> {
            List<JgChangeRegistrationUnit> collect = list.stream().filter(JgChangeRegistrationUnit -> jgRelationEquip.getUnitChangeRegistrationId().equals(JgChangeRegistrationUnit.getApplyNo())).collect(Collectors.toList());
            Long sequenceNbr = collect.get(0).getSequenceNbr();
            insertOrUpdateHis(JSON.parseObject(JSONObject.toJSONString(collect.get(0))), jgRelationEquip.getEquId());
            return jgRelationEquip.setUnitChangeRegistrationId(String.valueOf(sequenceNbr));
        }).collect(Collectors.toList());

        JgChangeRegistrationUnitEqMapper.insertBatchSomeColumn(jgRelationEquipList);
        return list;
    }

    void getNext(ArrayList<String> roleListFirst, String instanceId, String[] taskName) {
        AjaxResult aj = Workflow.taskClient.getTaskNoAuth(instanceId);
        JSONObject taskNoAuth = JSON.parseObject(JSON.toJSONString(aj.get("data")));
        if (!ObjectUtils.isEmpty(taskNoAuth)) {
            String nextTaskId = taskNoAuth.getString("id");
            FeignClientResult<JSONObject> nodeInfo = workFlowFeginService.getNodeInfo(nextTaskId);
            JSONObject result = nodeInfo.getResult();
            Map<String, Object> taskInfo = (Map<String, Object>) result.get("taskInfo");
            taskName[0] = String.valueOf(taskInfo.get("taskDefinitionKey"));
            AjaxResult taskGroupName = Workflow.taskClient.getTaskGroupName(nextTaskId);
            JSONArray data = JSON.parseArray(JSON.toJSONString(taskGroupName.get("data")));
            for (Object datum : data) {
                if (((Map) datum).containsKey("groupId")) {
                    roleListFirst.add(((Map) datum).get("groupId").toString());
                }
            }
        }
    }

    private void convertField(JgChangeRegistrationUnitDto model) {
        // 处理图片
        if (!ValidationUtil.isEmpty(model.getChangeCertificateList())) {
            model.setChangeCertificate(JSON.toJSONString(model.getChangeCertificateList()));
        }


        // 分割单位
        String useUnitId = model.getUseUnitCreditCode();
        if (!ObjectUtils.isEmpty(useUnitId)) {
            String[] useUnitList = useUnitId.split("_");
            if (useUnitList.length > 1) {
                model.setUseUnitCreditCode(useUnitList[0]);
                model.setUseUnitName(useUnitList[1]);
            }
        }

        String newUseUnitId = model.getNewUseUnitCreditCode();
        if (!ObjectUtils.isEmpty(newUseUnitId)) {
            String[] newUseUnitList = newUseUnitId.split("_");
            if (newUseUnitList.length > 1) {
                model.setNewUseUnitCreditCode(newUseUnitList[0]);
                model.setNewUseUnitName(newUseUnitList[1]);
            }
        }

        String receiveOrgCode = model.getReceiveOrgCode();
        if (!ObjectUtils.isEmpty(receiveOrgCode)) {
            String[] receiveOrgCodeList = receiveOrgCode.split("_");
            if (receiveOrgCodeList.length > 1) {
                model.setReceiveOrgCode(receiveOrgCodeList[0]);
                model.setReceiveOrgName(receiveOrgCodeList[1]);
            }
        }

    }

    private String convertImageUrl(List<Map<String, String>> urlList) {
        String urls = "";
        if (!CollectionUtils.isEmpty(urlList)) {
            urls = urlList.stream().map(map -> map.get("url")).collect(Collectors.joining(","));
        }
        return urls;
    }

    public void insertOrUpdateHis(JSONObject map, String equipId) {
        JgRegistrationHistory jgRegistrationHistory = new JgRegistrationHistory();
        //使用登记编号
        jgRegistrationHistory.setUseRegistrationCode(idxBizJgRegisterInfoMapper.getUseOrgCodeByEquip(equipId));
        //登记类别
        jgRegistrationHistory.setRegistrationClass("单位变更登记");
        //设备id
        jgRegistrationHistory.setEquId(equipId);
        //修改数据
        jgRegistrationHistory.setChangeData(JSONObject.toJSONString(map));
        //设备监管码
        LambdaQueryWrapper<OtherInfo> queryWrapper1 = new LambdaQueryWrapper<>();
        queryWrapper1.eq(OtherInfo::getRecord, equipId);
        OtherInfo tzsJgOtherInfo = tzsJgOtherInfoMapper.selectOne(queryWrapper1);
        jgRegistrationHistory.setSupervisoryCode(tzsJgOtherInfo.getSupervisoryCode());
        if (map.containsKey("type") && "edit".equals(String.valueOf(map.get("type")))) {
            jgRegistrationHistory.setSequenceNbr(jgRegistrationHistoryMapper.getSequenceNbrByEquidAndDocumentId(equipId, String.valueOf(map.get("sequenceNbr"))));
            jgRegistrationHistoryMapper.updateById(jgRegistrationHistory);
        } else {
            //当前单据id
            jgRegistrationHistory.setCurrentDocumentId(map.get("applyNo").toString());
            jgRegistrationHistoryMapper.insert(jgRegistrationHistory);
        }
    }

    public boolean submit(JgChangeRegistrationUnit notice, String op) {

        AjaxResult ajaxResult = Workflow.taskClient.getTask(notice.getInstanceId());
        JSONObject dataObject = JSON.parseObject(JSON.toJSONString(ajaxResult.get("data")));
        String taskId = dataObject.getString("id");
        //组装信息
        TaskResultDTO dto = new TaskResultDTO();
        dto.setResultCode("approvalStatus");
        dto.setTaskId(taskId);
        if (!ValidationUtil.isEmpty(notice.getProcessAdvice())) {
            dto.setComment(notice.getProcessAdvice());
        }
        HashMap<String, Object> map = new HashMap<>();
        if (notice.getStatus().equals(WorkFlowStatusEnum.UNIT_RENAME_SUBMIT.getReject()) || notice.getStatus().equals(WorkFlowStatusEnum.UNIT_RENAME_SUBMIT.getRollBack())) {
            map.put("approvalStatus", "提交");
        } else {
            map.put("approvalStatus", op);
        }
        dto.setVariable(map);
        //执行流程
        AjaxResult ajaxResult1 = null;
        try {
            ajaxResult1 = Workflow.taskClient.completeByTask(taskId, dto);
            if (ajaxResult1.get("code").equals(200)) {
                return true;
            } else {
                return false;
            }
        } catch (Exception e) {
            log.error("提交失败：{}", e);
            return false;
        }
    }

    public void cancel(JgChangeRegistrationUnitDto noticeDto) {
        String taskCode = FlowStatusEnum.TO_BE_FINISHED.getName();
        String[] taskName = new String[]{"流程结束"};
       // FeignClientResult ajaxResult = Workflow.taskV2Client.rollBack(noticeDto.getInstanceId());
        List<String> roleListNext = new ArrayList<>();
        List<String> roleListAll = new ArrayList<>();
        ProcessTaskDTO processTaskDTO = cmWorkflowService.rollBack(noticeDto.getInstanceId());
        String nextTaskId = processTaskDTO.getNextTask().get(0).getId();
        this.buildRoleList(Collections.singletonList(processTaskDTO), roleListNext, roleListAll);
        List<WorkflowResultDto> workflowResultDtos = commonServiceImpl.buildWorkFlowInfo(Collections.singletonList(processTaskDTO));

        // 待调整
        taskCode = processTaskDTO.getNextTask().get(0).getKey();
        JgChangeRegistrationUnit JgChangeRegistrationUnit = this.baseMapper.selectById(noticeDto.getSequenceNbr());
        JgChangeRegistrationUnit.setStatus(WorkFlowStatusEnum.getMessage(taskCode).getRollBack());
        JgChangeRegistrationUnit.setPromoter("");
        JgChangeRegistrationUnit.setNextTaskId(nextTaskId);
        JgChangeRegistrationUnit.setNextExecuteUserIds(workflowResultDtos.get(0).getNextExecutorUserIds());
        JgChangeRegistrationUnit.setNextExecutorIds(String.join(",", roleListNext));
        JgChangeRegistrationUnitMapper.updateById(JgChangeRegistrationUnit);
        JSONObject jsonObject = JSONObject.parseObject(JSONObject.toJSONString(JgChangeRegistrationUnit));
        jsonObject.put("nextTaskId", JgChangeRegistrationUnit.getNextTaskId());
        jsonObject.put("nextExecuteUser", JgChangeRegistrationUnit.getNextExecutorIds());
        jsonObject.put("taskType", BusinessTypeEnum.JG_COMPANY_CHANGE_REGISTRATION.getCode());
        jsonObject.put("flowStatus", this.getTaskCodeByName(JgChangeRegistrationUnit.getStatus()));
        jsonObject.put("flowStatusLabel", JgChangeRegistrationUnit.getStatus());

        commonServiceImpl.rollbackTask(noticeDto.getInstanceId(), jsonObject);
    }

    @Transactional
    public void accept(JgChangeRegistrationUnitDto dto, String op) {
        String[] taskName = new String[]{"已完成"};
        String userId = RequestContext.getExeUserId();
        String taskId = dto.getNextTaskId();
        JgChangeRegistrationUnit jgChangeRegistrationUnit = this.JgChangeRegistrationUnitMapper.selectById(dto.getSequenceNbr());
        jgChangeRegistrationUnit.setProcessAdvice(dto.getProcessAdvice());
        List<String> roleListNext = new ArrayList<>();
        List<String> roleListAll = new ArrayList<>();
        ArrayList<String> roleList = new ArrayList<>();
//        boolean submit = submit(jgChangeRegistrationUnit, op);
//        if (submit) {
           // getNext(roleList, dto.getInstanceId(), taskName);

        //组装信息
        TaskResultDTO task = new TaskResultDTO();
        task.setResultCode("approvalStatus");
        task.setTaskId(taskId);
        task.setComment(StringUtils.isEmpty(dto.getProcessAdvice())?"":dto.getProcessAdvice());
        task.setNextExecuteUserCompanyCode(this.getNextUserOrgCode(op,jgChangeRegistrationUnit));

        HashMap<String, Object> map = new HashMap<>();
        map.put("approvalStatus", op);
        if (!ObjectUtils.isEmpty(jgChangeRegistrationUnit.getInstanceStatus()) &&
                (jgChangeRegistrationUnit.getStatus().equals(WorkFlowStatusEnum.UNIT_RENAME_SUBMIT.getReject()) ||
                        jgChangeRegistrationUnit.getStatus().equals(WorkFlowStatusEnum.UNIT_RENAME_SUBMIT.getRollBack()))) {
            map.put("approvalStatus", "提交");
        }
        task.setVariable(map);
        //执行流程
        ProcessTaskDTO processTaskDTO = cmWorkflowService.completeOrReject(taskId, task, op);
        String taskCode = FlowStatusEnum.TO_BE_FINISHED.getName();
        String taskName1 = "";
        String nextTaskId = "";
        this.buildRoleList(Collections.singletonList(processTaskDTO), roleList, roleListAll);
        List<WorkflowResultDto> workflowResultDtos = commonServiceImpl.buildWorkFlowInfo(Collections.singletonList(processTaskDTO));
        String nextUserIds = workflowResultDtos.get(0).getNextExecutorUserIds();
        if(processTaskDTO != null && processTaskDTO.getNextTask() != null && processTaskDTO.getNextTask().size() >0){
            taskCode = processTaskDTO.getNextTask().get(0).getKey();
            taskName1 = processTaskDTO.getNextTask().get(0).getName();
            nextTaskId = processTaskDTO.getNextTask().get(0).getId();
        }

        jgChangeRegistrationUnit.setStatus(taskName[0]);
            if ("0".equals(op)) {
                if (roleList.size() == 0) {
                    jgChangeRegistrationUnit.setStatus(taskName[0]);
                    jgChangeRegistrationUnit.setAuditPassDate(new Date());

                    // 生成新的使用登记编号，使用登记证  修改设备的使用登记信息表，使用单位名称，使用单位统一信用代码，使用登记证编号，更新ES
                    LambdaQueryWrapper<JgChangeRegistrationUnitEq> queryWrapper = new LambdaQueryWrapper<>();
                    queryWrapper.eq(JgChangeRegistrationUnitEq::getUnitChangeRegistrationId, dto.getSequenceNbr());
                    JgChangeRegistrationUnitEq jgChangeRegistrationUnitEq = JgChangeRegistrationUnitEqMapper.selectOne(queryWrapper);
                    String equipId = jgChangeRegistrationUnitEq.getEquId();
                    LambdaQueryWrapper<OtherInfo> queryWrapper1 = new LambdaQueryWrapper<>();
                    queryWrapper1.eq(OtherInfo::getRecord, jgChangeRegistrationUnitEq.getEquId());
                    OtherInfo tzsJgOtherInfo = tzsJgOtherInfoMapper.selectOne(queryWrapper1);

                    LambdaQueryWrapper<UseInfo> queryWrapper2 = new LambdaQueryWrapper<>();
                    queryWrapper2.eq(UseInfo::getRecord, jgChangeRegistrationUnitEq.getEquId());
                    UseInfo useInfo = useInfoMapper.selectOne(queryWrapper2);
                    useInfo.setUseUnitName(jgChangeRegistrationUnit.getNewUseUnitName());
                    useInfo.setUseUnitCreditCode(jgChangeRegistrationUnit.getNewUseUnitCreditCode());


                    String code = getCode(tzsJgOtherInfo.getSupervisoryCode());
                    if (ValidationUtil.isEmpty(code)) {
                        log.error("生成新的使用登记证编号失败");
                        return;
                    }

                    jgChangeRegistrationUnit.setUseRegistCode(code);
                    //更新使用注册登记证编号
                    idxBizJgRegisterInfoMapper.updateUseOrgCodeByEquip(equipId, code);
                    useInfoMapper.updateById(useInfo);
                    //es中的编号信息
                    Map<String, Map<String, Object>> resultMap = new HashMap<>();
                    Map<String, Object> map1 = new HashMap<>();
                    map1.put("USE_ORG_CODE", code);
                    map1.put("USE_UNIT_CREDIT_CODE", jgChangeRegistrationUnit.getNewUseUnitCreditCode());
                    map1.put("USE_UNIT_NAME", jgChangeRegistrationUnit.getNewUseUnitName());
                    resultMap.put(equipId, map1);
                    tzsServiceFeignClient.commonUpdateEsDataByIds(resultMap);
                    //修改各类告知列表，置为废弃
                    this.updataInvalidStatusByHistory(jgChangeRegistrationUnitEq.getEquId(), jgChangeRegistrationUnit.getApplyNo());

                    updateTaskModel(jgChangeRegistrationUnit, op);
//                    TransactionSynchronizationManager.registerSynchronization(new TransactionSynchronization() {
//                        @Override
//                        public void afterCommit() {
//                            generateInstallationNoticeReport(JgChangeRegistrationUnit.getSequenceNbr());
//                        }
//                    });
                } else {
                    jgChangeRegistrationUnit.setNextExecutorIds(String.join(",", roleList));
                    if (!ObjectUtils.isEmpty(jgChangeRegistrationUnit.getInstanceStatus())) {
                        jgChangeRegistrationUnit.setInstanceStatus(jgChangeRegistrationUnit.getInstanceStatus() + "," + String.join(",", roleList));
                    } else {
                        jgChangeRegistrationUnit.setInstanceStatus(String.join(",", roleList));
                    }
                    jgChangeRegistrationUnit.setPromoter(userId);
                    jgChangeRegistrationUnit.setNextExecuteUserIds(nextUserIds);
                    jgChangeRegistrationUnit.setNextTaskId(nextTaskId);
                    jgChangeRegistrationUnit.setStatus(WorkFlowStatusEnum.getMessage(taskCode).getPass());
                    executeOneStep(jgChangeRegistrationUnit, taskName1, nextUserIds, op);                }
            } else {
                jgChangeRegistrationUnit.setPromoter("");
                jgChangeRegistrationUnit.setNextExecutorIds(String.join(",", roleList));
                jgChangeRegistrationUnit.setNextTaskId(nextTaskId);
                jgChangeRegistrationUnit.setNextExecuteUserIds(nextUserIds);
                jgChangeRegistrationUnit.setStatus(WorkFlowStatusEnum.getMessage(taskCode).getReject());
                executeOneStep(jgChangeRegistrationUnit, taskName1, nextUserIds, op);
            }
            JgChangeRegistrationUnitMapper.updateById(jgChangeRegistrationUnit);
       // }
    }

    private Integer getTaskCodeByName(String auditStatus) {
        return commonServiceImpl.getDictionaryCodeByName(auditStatus);
    }


    /**
     * 修改各类告知列表，置为废弃
     *
     * @param equId           设备id
     * @param equipTransferId 当前告知单Id
     */
    public void updataInvalidStatusByHistory(String equId, String equipTransferId) {
        //改造变更登记
        jgChangeRegistrationReformEqMapper.updateEquipIsVaildByEquipIdAndCurrentDocumentId(equId, equipTransferId);
        //移装变更登记
        jgChangeRegistrationTransferEqMapper.updateEquipIsVaildByEquipIdAndCurrentDocumentId(equId, equipTransferId);
        //使用登记
        jgUseRegistrationEqMapper.updateEquipIsVaildByEquipIdAndCurrentDocumentId(equId, equipTransferId);
        //单位变更登记
        jgChangeRegistrationUnitEqMapper.updateEquipIsVaildByEquipIdAndCurrentDocumentId(equId, equipTransferId);
        //更名变更登记
        jgChangeRegistrationNameEqMapper.updateEquipIsVaildByEquipIdAndCurrentDocumentId(equId, equipTransferId);
    }


    public String getCode(String supervisoryCode) {
        if (!ObjectUtils.isEmpty(supervisoryCode) && supervisoryCode.length() > 5) {
            String name = EquipTypeEnum.getMessage(supervisoryCode.substring(1, 2));
            String type = supervisoryCode.substring(2, 4);
            String city = supervisoryCode.substring(0, 1);
            ResponseModel<String> stringResponseModel = tzsServiceFeignClient.useRegistrationCode(name + type + "陕" + city);
            return stringResponseModel.getResult();
        }
        return null;
    }


    /**
     * 导出使用登记证
     *
     * @param sequenceNbr
     */
    public void exportUseRegistrationCertificate(String sequenceNbr, HttpServletResponse response) {
        Map<String, Object> exportParamsMap = new HashMap<>();
        //查询移装变更详情
        JgChangeRegistrationUnit transfer = this.getById(sequenceNbr);
        LambdaQueryWrapper<JgChangeRegistrationUnitEq> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(JgChangeRegistrationUnitEq::getUnitChangeRegistrationId, transfer.getSequenceNbr());
        JgChangeRegistrationUnitEq jgChangeRegistrationUnitEq = JgChangeRegistrationUnitEqMapper.selectOne(queryWrapper);
        if (ValidationUtil.isEmpty(transfer) || ValidationUtil.isEmpty(jgChangeRegistrationUnitEq)) {
            throw new BadRequest("使用登记证导出失败,请稍后重试!");
        }
        //是否废弃
        exportParamsMap.put("isInvalid", ValidationUtil.isEmpty(jgChangeRegistrationUnitEq.getIsInvalid()) ? "0" : jgChangeRegistrationUnitEq.getIsInvalid());
        //登记机关
        exportParamsMap.put("receiveOrgName", transfer.getReceiveOrgName());
        //使用登记证编号
        exportParamsMap.put("useRegistrationCode", ValidationUtil.isEmpty(transfer.getUseRegistCode()) ? "" : transfer.getUseRegistCode());
        //使用单位名称
        exportParamsMap.put("useUnitName", transfer.getUseUnitName());
        //监管码
        LambdaQueryWrapper<OtherInfo> queryWrapper1 = new LambdaQueryWrapper<>();
        queryWrapper1.eq(OtherInfo::getRecord, jgChangeRegistrationUnitEq.getEquId());
        OtherInfo tzsJgOtherInfo = tzsJgOtherInfoMapper.selectOne(queryWrapper1);
        exportParamsMap.put("supervisoryCode", tzsJgOtherInfo.getSupervisoryCode());
        //发证日期（当前时间）
        LocalDate today = LocalDate.now();
        exportParamsMap.put("giveOutYear", today.getYear());
        exportParamsMap.put("giveOutMonth", today.getMonthValue());
        exportParamsMap.put("giveOutDay", today.getDayOfMonth());
        //设备使用地址


        //查询设备注册信息
        IdxBizJgRegisterInfo registerInfo = idxBizJgRegisterInfoService.getOne(new QueryWrapper<IdxBizJgRegisterInfo>().eq("RECORD", jgChangeRegistrationUnitEq.getEquId()));
        if (!ValidationUtil.isEmpty(registerInfo)) {
            //设备种类、类别、品种
            String equList = registerInfo.getEquList();//设备种类
            String equCategory = registerInfo.getEquCategory();//设备类别
            String equDefine = registerInfo.getEquDefine();//设备品种
            List<EquipmentCategory> categoryList0 = commonService.getEquipmentCategoryList(equList, null);
            List<EquipmentCategory> categoryList1 = commonService.getEquipmentCategoryList(equCategory, null);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(categoryList1)) {
                exportParamsMap.put("equList", categoryList0.get(0).getName());
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(categoryList1)) {
                exportParamsMap.put("equCategory", categoryList1.get(0).getName());
            }
            if (!ValidationUtil.isEmpty(equDefine)) {
                List<EquipmentCategory> categoryList2 = commonService.getEquipmentCategoryList(equDefine, null);
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(categoryList2)) {
                    exportParamsMap.put("equDefine", categoryList2.get(0).getName());
                }
            }
            //设备代码
            exportParamsMap.put("equCode", registerInfo.getEquCode());
        }

        //单位内部编码
        IdxBizJgUseInfo useInfo = idxBizJgUseInfoService.getOneData(jgChangeRegistrationUnitEq.getEquId());
        if (!ValidationUtil.isEmpty(useInfo)) {
            exportParamsMap.put("useInnerCode", useInfo.getUseInnerCode());

            String fullAddress = "";
            String province = ValidationUtil.isEmpty(useInfo.getProvinceName()) ? "" : useInfo.getProvinceName();
            String city = ValidationUtil.isEmpty(useInfo.getCityName()) ? "" : useInfo.getCityName();
            String county = ValidationUtil.isEmpty(useInfo.getCountyName()) ? "" : useInfo.getCountyName();
            String street = ValidationUtil.isEmpty(useInfo.getStreetName()) ? "" : useInfo.getStreetName();
            String address = ValidationUtil.isEmpty(useInfo.getAddress()) ? "" : useInfo.getAddress();
            fullAddress = province + city + county + street + address;
            exportParamsMap.put("fullAddress", fullAddress);
        }
        IdxBizJgFactoryInfo factoryInfo = idxBizJgFactoryInfoService.getOneData(jgChangeRegistrationUnitEq.getEquId());
        //产品编号(出厂编号)
        if (!ValidationUtil.isEmpty(factoryInfo)) {
            exportParamsMap.put("factoryNum", factoryInfo.getFactoryNum());
        }
        //调用生成使用登记证
        commonService.generateCertificateReport(exportParamsMap, response);
    }


    private String buildTaskContent(JgChangeRegistrationUnit obj) {
        return "来自"+ EquipmentClassifityEnum.getNameByCode(obj.getEquList()) +"【"+obj.getSupervisoryCode()+"】的业务办理,【申请单号:"+obj.getApplyNo()+"】";
    }




    private void createTaskModel(JgChangeRegistrationUnit dto, String taskName, String submitType, String nextUserIds) {
        ReginParams reginParams = JSON.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        if ("1".equals(submitType)) {
            TaskModelDto taskModelDto = new TaskModelDto();
            taskModelDto.setFlowCreateDate(dto.getApplyDate());
            taskModelDto.setTaskName(taskName);
            taskModelDto.setTaskCode(dto.getApplyNo());
            taskModelDto.setTaskContent(this.buildTaskContent(dto));
            taskModelDto.setTaskDesc("");
            taskModelDto.setTaskType(BusinessTypeEnum.JG_COMPANY_CHANGE_REGISTRATION.getCode());
            taskModelDto.setTaskTypeLabel(BusinessTypeEnum.JG_COMPANY_CHANGE_REGISTRATION.getName());
            taskModelDto.setRelationId(dto.getInstanceId());
            taskModelDto.setExecuteUserIds(nextUserIds);
            taskModelDto.setFlowStatus(this.getTaskStatusByName(dto.getStatus()));
            taskModelDto.setFlowStatusLabel(dto.getStatus());
            taskModelDto.setTaskStatusLabel(dto.getAuditStatus());
            taskModelDto.setStartUserId(RequestContext.getExeUserId());
            taskModelDto.setStartUser(reginParams.getUserModel().getRealName());
            taskModelDto.setStartUserCompanyName(dto.getUseUnitName());
            taskModelDto.setNextExecuteUser(dto.getNextExecutorIds());
            taskModelDto.setStartDate(dto.getCreateDate());
            TaskMessageDto obj = new TaskMessageDto();
            obj.setInstanceId(dto.getInstanceId());
            obj.setStatus(dto.getStatus());
            obj.setPromoter(dto.getPromoter());
            obj.setNextExecuteUserIds(dto.getNextExecuteUserIds());
            obj.setSequenceNbr(dto.getSequenceNbr());
            obj.setNextTaskId(dto.getNextTaskId());
            taskModelDto.setModel(obj);
            commonServiceImpl.buildTaskModel(Collections.singletonList(taskModelDto));
        }
    }

    private void buildRoleList(List<ProcessTaskDTO> processTasks, List<String> roleListNext, List<String> roleListAll) {
        processTasks.forEach(p -> {
            p.getNextCandidateGroups().values().forEach(e -> {
                roleListNext.addAll(e);
                roleListAll.addAll(e);
            });
            roleListAll.addAll(p.getCandidateGroups());
        });
    }

//    private void executeOneStep(JgChangeRegistrationUnit jgChangeRegistrationName, String taskName, String nextUserIds, String operate) {
//        // 先更新之前的待办
//        TaskV2Model taskV2Model = updateTaskModel(jgChangeRegistrationName, operate);
//        TaskModelDto taskModelDto = new TaskModelDto();
//        taskModelDto.setTaskDesc("");
//        taskModelDto.setTaskContent(this.buildTaskContent(jgChangeRegistrationName));
//        taskV2Model.setTaskName(taskName);
//        taskModelDto.setTaskDesc("");
//        taskModelDto.setTaskCode(jgChangeRegistrationName.getApplyNo());
//        taskV2Model.setExecuteUserIds(nextUserIds);
//        taskV2Model.setRelationId(jgChangeRegistrationName.getInstanceId());
//        taskV2Model.setTaskStatus(this.getTaskStatusByName(jgChangeRegistrationName.getAuditStatus()));
//        taskV2Model.setTaskStatusLabel(jgChangeRegistrationName.getAuditStatus());
//        taskV2Model.setTaskType(BusinessTypeEnum.JG_COMPANY_CHANGE_REGISTRATION.getCode());
//        taskModelDto.setStartUser(jgChangeRegistrationName.getCreateUserName());
//        taskV2Model.setTaskTypeLabel(BusinessTypeEnum.JG_COMPANY_CHANGE_REGISTRATION.getName());
//        taskModelDto.setStartDate(jgChangeRegistrationName.getCreateDate());
//        taskModelDto.setStartUserId(jgChangeRegistrationName.getCreateUserId());
//        taskModelDto.setStartUserCompanyName(jgChangeRegistrationName.getUseUnitName());
//        taskModelDto.setExecuteUserIds(nextUserIds);
//        TaskModelDto modelDto = new TaskModelDto();
//        BeanUtil.copyProperties(taskV2Model,modelDto);
//        modelDto.setNextExecuteUser(jgChangeRegistrationName.getNextExecutorIds());
//        modelDto.setModel(jgChangeRegistrationName);
//        // 再插入新代办、数据待定
//        commonServiceImpl.buildTaskModel(Collections.singletonList(modelDto));
//    }

    private void executeOneStep(JgChangeRegistrationUnit jgChangeRegistrationName, String taskName, String nextUserIds, String operate) {
        // 先更新之前的待办
        TaskV2Model taskV2Model = updateTaskModel(jgChangeRegistrationName, operate);
        taskV2Model.setTaskDesc("");
        taskV2Model.setTaskName(taskName);
        taskV2Model.setTaskDesc("");
        taskV2Model.setTaskCode(jgChangeRegistrationName.getApplyNo());
        taskV2Model.setExecuteUserIds(nextUserIds);
        taskV2Model.setRelationId(jgChangeRegistrationName.getInstanceId());
        FlowStatusEnum flowStatusEnum = this.getTaskStatus(operate);
        taskV2Model.setTaskStatus(this.getTaskStatusByName(jgChangeRegistrationName.getStatus()));
        taskV2Model.setTaskStatusLabel(jgChangeRegistrationName.getStatus());
        taskV2Model.setFlowStatus(this.getTaskStatusByName(jgChangeRegistrationName.getStatus()));
        taskV2Model.setFlowStatusLabel(jgChangeRegistrationName.getStatus());
      //  taskV2Model.setTaskType(BusinessTypeEnum.JG_COMPANY_CHANGE_REGISTRATION.getCode());
      //  taskV2Model.setStartUser(jgChangeRegistrationName.getCreateUserName());
      //  taskV2Model.setTaskTypeLabel(BusinessTypeEnum.JG_COMPANY_CHANGE_REGISTRATION.getName());
      //  taskV2Model.setStartDate(jgChangeRegistrationName.getCreateDate());
      //  taskV2Model.setStartUserId(jgChangeRegistrationName.getCreateUserId());
      //  taskV2Model.setStartUserCompanyName(jgChangeRegistrationName.getUseUnitName());
        taskV2Model.setExecuteUserIds(nextUserIds);
        TaskModelDto modelDto = new TaskModelDto();
        BeanUtil.copyProperties(taskV2Model, modelDto);
        modelDto.setNextExecuteUser(jgChangeRegistrationName.getNextExecutorIds());
        if (jgChangeRegistrationName.getStatus().equals(WorkFlowStatusEnum.UNIT_RENAME_SUBMIT.getReject())){
            modelDto.setPageType("edit");
        }
        TaskMessageDto obj = new TaskMessageDto();
        obj.setInstanceId(jgChangeRegistrationName.getInstanceId());
        obj.setStatus(jgChangeRegistrationName.getStatus());
        obj.setPromoter(jgChangeRegistrationName.getPromoter());
        obj.setNextExecuteUserIds(jgChangeRegistrationName.getNextExecuteUserIds());
        obj.setSequenceNbr(jgChangeRegistrationName.getSequenceNbr());
        obj.setNextTaskId(jgChangeRegistrationName.getNextTaskId());
        modelDto.setModel(obj);
        // 再插入新代办、数据待定
        commonServiceImpl.buildTaskModel(Collections.singletonList(modelDto));
    }


    private TaskV2Model updateTaskModel(JgChangeRegistrationUnit jgChangeRegistrationName, String operate) {
        Map<String, Object> params = new HashMap<>();
        FlowStatusEnum flowStatusEnum = this.getTaskStatus(operate);
        params.put("relationId",jgChangeRegistrationName.getInstanceId());
        params.put("taskStatus", flowStatusEnum.getCode());
        params.put("taskStatusLabel", flowStatusEnum.getName());
        params.put("flowStatus",this.getTaskStatusByName(jgChangeRegistrationName.getStatus()));
        params.put("flowStatusLabel",jgChangeRegistrationName.getStatus());
        params.put("model",jgChangeRegistrationName);
        return commonServiceImpl.updateTaskModel(params);
    }

    private FlowStatusEnum getTaskStatus(String operate) {
        if("0".equals(operate)){
            return FlowStatusEnum.TO_BE_FINISHED;
        } else {
            return FlowStatusEnum.REJECTED;
        }
    }


    private String getNextUserOrgCode(String operate, JgChangeRegistrationUnit jgChangeRegistrationName) {
        if("0".equals(operate)){
            // 执行通过节点，单位code为接收机构单位信息
            return jgChangeRegistrationName.getReceiveOrgCode();
        }
        if(jgChangeRegistrationName.getStatus().equals(WorkFlowStatusEnum.UNIT_RENAME_RECEIVE.getPass())
                || jgChangeRegistrationName.getStatus().equals(WorkFlowStatusEnum.UNIT_RENAME_RECEIVE.getReject())
                || jgChangeRegistrationName.getStatus().equals(WorkFlowStatusEnum.UNIT_RENAME_RECEIVE.getRollBack())){
            // 驳回且当前节点为一键节点时，单位code为发起人单位信息
            return jgChangeRegistrationName.getUseUnitCreditCode();
        }
        // 2、3级驳回时，单位code为接收单位code
        return  jgChangeRegistrationName.getReceiveOrgCode();
    }
    private Integer getTaskStatusByName(String auditStatus) {
        return commonServiceImpl.getDictionaryCodeByName(auditStatus);
    }
}