package com.yeejoin.amos.boot.module.common.biz.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.common.api.dto.DutyShiftDto;
import com.yeejoin.amos.boot.module.common.api.entity.DutyShift;
import com.yeejoin.amos.boot.module.common.biz.service.impl.DutyPersonShiftServiceImpl;
import com.yeejoin.amos.boot.module.common.biz.service.impl.DutyShiftServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;


/**
 * 值班班次
 *
 * @author system_generator
 * @date 2021-07-06
 */
@RestController
@Api(tags = "值班班次Api")
@RequestMapping(value = "/common/duty-shift")
public class DutyShiftController extends BaseController {

    @Autowired
    DutyShiftServiceImpl dutyShiftServiceImpl;
   
    @Autowired
    DutyPersonShiftServiceImpl dutyPersonShiftServiceImpl;
    /**
     * 新增值班班次
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "新增值班班次", notes = "新增值班班次")
    public ResponseModel<Boolean> save(HttpServletRequest request, @RequestBody DutyShiftDto model) {
        QueryWrapper<DutyShift> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("name", model.getName());
        List<DutyShift> list = dutyShiftServiceImpl.list(queryWrapper);
        if(!list.isEmpty()) {
            return ResponseHelper.buildResponse(false);
        }
        String appKey = request.getHeader("appKey");
        model.setAppKey(appKey);
        dutyShiftServiceImpl.createWithModel(model);
        return ResponseHelper.buildResponse(true);
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新值班班次", notes = "根据sequenceNbr更新值班班次")
    public ResponseModel<DutyShiftDto> updateBySequenceNbrDutyShift(HttpServletRequest request, @RequestBody DutyShiftDto model, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        String appKey = request.getHeader("appKey");
        model.setAppKey(appKey);
        model.setSequenceNbr(sequenceNbr);
        return ResponseHelper.buildResponse(dutyShiftServiceImpl.updateWithModel(model));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除值班班次", notes = "根据sequenceNbr删除值班班次")
    public ResponseModel<Boolean> deleteBySequenceNbr(@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
    	
    	if(dutyPersonShiftServiceImpl.checkCurrentDutyIsUser(sequenceNbr)) {
    		return	ResponseHelper.buildResponse(false);
    	}
        DutyShift dutyShift = dutyShiftServiceImpl.getById(sequenceNbr);
        if (null != dutyShift) {
            dutyShift.setIsDelete(true);
        }
        return ResponseHelper.buildResponse(dutyShiftServiceImpl.updateById(dutyShift));
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个值班班次", notes = "根据sequenceNbr查询单个值班班次")
    public ResponseModel<DutyShiftDto> selectOne(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(dutyShiftServiceImpl.queryBySeq(sequenceNbr));
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "值班班次分页查询", notes = "值班班次分页查询")
    public ResponseModel<Page<DutyShiftDto>> queryForPage(HttpServletRequest request, @RequestParam(value = "current") int current, @RequestParam(value = "size") int size) {
        String appKey = request.getHeader("appKey");
        Page<DutyShiftDto> page = new Page<>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(dutyShiftServiceImpl.queryForDutyShiftPage(page, appKey,false));
    }

    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "值班班次列表全部数据查询", notes = "值班班次列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<DutyShiftDto>> selectForList(HttpServletRequest request) {
        String appKey = request.getHeader("appKey");
        return ResponseHelper.buildResponse(dutyShiftServiceImpl.queryForDutyShiftList(appKey,false));
    }
}
