package com.yeejoin.equipmanage.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.equipmanage.common.utils.CommonResponseUtil;
import com.yeejoin.equipmanage.service.IAccessRecordingService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

/**
 * <h1>
 * <h1>
 *
 * @author tiantao
 * @date 2021/3/1 11:24
 */
@RestController
@Api(tags = "仓库信息Api")
@RequestMapping(value = "/access-recording", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class AccessRecordingController extends AbstractBaseController {
	@Autowired
	private IAccessRecordingService accessRecordingService;

	/**
	 * 记录列表分页查询
	 *
	 * @return
	 */
	@RequestMapping(value = "/list", method = RequestMethod.GET)
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET", value = "列表分页查询", produces = "application/json;charset=UTF-8", notes = "列表分页查询")
	public ResponseModel listPage(@RequestParam(value = "accessPosition", required = false) String accessPosition,
			@RequestParam(value = "cardholderName", required = false) String cardholderName,
			@RequestParam(value = "cardCode", required = false) String cardCode,
			@RequestParam(value = "visitorCompany", required = false) Integer status,
			@RequestParam(value = "crossTime", required = false) Long[] crossTime,
			@RequestParam(value = "size", required = false, defaultValue = "10") Integer size,
			@RequestParam(value = "current", required = false, defaultValue = "1") Integer current) {
		Page page = new Page(current, size);
		return CommonResponseUtil.success(
				accessRecordingService.listByParams(accessPosition, cardholderName, cardCode, status, crossTime, page));
	}
}
