package com.yeejoin.equipmanage.common.entity;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 *
 *
 * @author wujiang
 * @date 2020-07-07
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("wl_equipment_detail")
@ApiModel(value = "EquipmentDetail对象", description = "")
public class EquipmentDetail extends BaseEntity {

	private static final long serialVersionUID = 1L;

	@Excel(name = "部件名称",orderNum ="1")
	@TableField("name")
	@ApiModelProperty(value = "部件名称")
	private String name;

	@TableField("code")
	@ApiModelProperty(value = "编码")
	private String code;

	@Excel(name = "装备定义id",orderNum ="14")
	@TableField("equipment_id")
	@ApiModelProperty(value = "装备定义id")
	private Long equipmentId;


	@Excel(name = "装备定义名称",orderNum ="15")
	@TableField("equipment_name")
	@ApiModelProperty(value = "装备定义名称")
	private String equipmentName;

	@TableField(exist = false)
	private Equipment equipment;

	@TableField(exist = false)
	private String categoryName;



	@TableField("creator_id")
	@ApiModelProperty(value = "创建人id")
	private Long creatorId;

	@TableField("manufacturer_id")
	@ApiModelProperty(value = "生产厂商id")
	private Long manufacturerId;

	@TableField(exist = false)
	private String manufacturerName;

	@TableField(exist = false)
	private ManufacturerInfo manufacturerInfo;


	@TableField("update_date")
	@ApiModelProperty(value = "更新时间")
	private Date updateDate;

	@TableField("agent")
	@ApiModelProperty(value = "代理商")
	private String agent;



	@TableField("contract_code")
	@ApiModelProperty(value = "合同编号")
	private String contractCode;

	@TableField("production_date")
	@ApiModelProperty(value = "生产日期")
	private Date productionDate;

	@TableField("perf_quota_str")
	@ApiModelProperty(value = "核心参数")
	private String perfQuotaStr;

	@TableField("expiry_date")
	@ApiModelProperty(value = "核心参数")
	private String expiryDate;

	@TableField("price_interregional")
	@ApiModelProperty(value = "价格区间")
	private String priceInterregional;

	@TableField("country")
	@ApiModelProperty(value = "国别")
	private String country;

	@TableField("is_import")
	@ApiModelProperty(value = "是否进口")
	private Boolean isImport;

	@TableField("supplier_id")
	@ApiModelProperty(value = "供应商id")
	private String supplierId;
	
	@TableField(exist = false)
	@ApiModelProperty(value = "设备的状态")
	private String status;

	@TableField(exist = false)
	private List<UploadFile> img;

	@TableField(exist = false)
	private List<UploadFile> video;

	@TableField(exist = false)
	private List<UploadFile> certification;

	@TableField(exist = false)
	private List<UploadFile> instruction;

	@TableField(exist = false)
	private List<EquProperty> equPropertyList;

	@TableField("org_code")
	@ApiModelProperty(value = "归属组织")
	private String orgCode;

	@TableField("company_name")
	@ApiModelProperty(value = "公司名")
	private String companyName;

	@TableField("department_orgcode")
	@ApiModelProperty(value = "部门code")
	private String departmentOrgcode;

	@TableField("department_name")
	@ApiModelProperty(value = "部门名")
	private String departmentName;

	@TableField(exist = false)
	private String countryName;

	@TableField(exist = false)
	private String unitName;


	@Excel(name = "部件编码",orderNum ="2")
	@TableField("eq_code")
	@ApiModelProperty(value = "部件编码")
	private String eqcode;

	@Excel(name = "部件型号",orderNum ="3")
	@TableField("standard")
	@ApiModelProperty(value = "部件型号")
	private String standard;

	@Excel(name = "存放位置",orderNum ="4")
	@TableField("area")
	@ApiModelProperty(value = "存放位置")
	private String area;

	@Excel(name = "生产厂家",orderNum ="5")
	@TableField("brand")
	@ApiModelProperty(value = "生产厂家")
	private String brand;

	@Excel(name = "出厂时间",orderNum ="6")
	@JsonFormat(pattern = "yyyy-MM-dd")
	@TableField("open_date")
	@ApiModelProperty(value = "出厂时间")
	private Date openDate;

	@Excel(name = "工作时间",orderNum ="7")
	@TableField("maintenance_cycle")
	@ApiModelProperty(value = "工作时间")
	private BigDecimal maintenanceCycle;


	@Excel(name = "所属单位",orderNum ="8")
	@TableField("remark")
	@ApiModelProperty(value = "所属单位")
	private String remark;

	@Excel(name = "入库时间",orderNum ="9")
	@JsonFormat(pattern = "yyyy-MM-dd")
	@TableField("join_date")
	@ApiModelProperty(value = "入库时间")
	private Date joinDate;

}
