/**
 * @Time: 2022/7/19 18:45
 * @Author: 任刚
 * @File：EquipmentParams.class
 */
package com.yeejoin.equipmanage.common.entity;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;


/**
 * 故障类型
 */
@Data
@Accessors(chain = true)
@TableName("wl_equipment_params")
@ApiModel(value = "EquipmentDetail对象", description = "")
public class EquipmentParams implements Serializable {

    @TableId(type = IdType.ID_WORKER)
    @JsonSerialize(using = ToStringSerializer.class)
    private String id;

    /**
     * 新增和更新执行
     */
    @TableField(value = "create_date", fill = FieldFill.INSERT)
    private Date createDate;

    @TableField("status")
    @ApiModelProperty(value="状态")
    @Excel(name = "状态",orderNum = "11")
    private String status;

    @TableField("detail_id")
    @ApiModelProperty(value="装备id")
    private String detailId;

    @TableField("fault_knowledge_id")
    @ApiModelProperty(value="知识库id")
    private String faultKnowledgeId;

    @TableField(exist = false)
    @ApiModelProperty(value = "故障类型")
    @Excel(name = "故障类型",orderNum = "12")
    private String type;

    @TableField(exist = false)
    @ApiModelProperty(value = "处置措施")
    @Excel(name = "处置措施",orderNum = "13")
    private String measure;

    @TableField(exist = false)
    @ApiModelProperty(value = "原因分析")
    private String reason;


/*    @TableField("code")
    @ApiModelProperty(value = "设备编码")
    private String code;*/

}
