/**
 * @Time: 2022/7/27 16:38
 * @Author: 任刚
 * @File：DetailssDTO.class
 */
package com.yeejoin.equipmanage.common.entity.dto;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.equipmanage.common.entity.EquipmentDetail;
import com.yeejoin.equipmanage.common.entity.publics.BaseDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
public class DetailssDTO extends BaseDTO<EquipmentDetail> {


    @ApiModelProperty(value = "名称")
    private String name;

    @ApiModelProperty(value = "部件编码")
    private String eqcode;

    @ApiModelProperty(value = "部件型号")
    private String standard;

    @ApiModelProperty(value = "存放位置")
    private String area;

    @ApiModelProperty(value = "生产厂家")
    private String brand;

    @JsonFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty(value = "出厂时间")
    private Date openDate;

    @ApiModelProperty(value = "工作时间")
    private BigDecimal maintenanceCycle;


    @ApiModelProperty(value = "所属单位")
    private String remark;

    @JsonFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty(value = "入库时间")
    private Date joinDate;

    @ApiModelProperty(value="状态")
    private int status;

    @ApiModelProperty(value = "原因分析")
    private String reason;

    @ApiModelProperty(value = "处置措施")
    private String measure;

    @ApiModelProperty(value = "行业编码")
    private String industryCode;

    @ApiModelProperty(value = "分类编码")
    private String equipmentClassificationCode;

    @ApiModelProperty(value = "类型 car：车辆，equipment：设备")
    private String type;
    @ApiModelProperty(value = "物联编码")
    private String iotCode;

    @ApiModelProperty(value = "判断是否导出全部")
    private Integer prop;

}
