/**
 * @Time: 2022/7/27 16:19
 * @Author: 任刚
 * @File：DetailssAmountVO.class
 */
package com.yeejoin.equipmanage.common.entity.vo;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 装备编辑界面的model
 */
@ApiModel(description = "设备数据封装VO")
@Data
public class DetailssAmountVO {


    @ApiModelProperty(value = "id")
    private Long id;

    @Excel(name = "部件名称",orderNum ="1")
    @ApiModelProperty(value = "部件名称")
    private String name;

    @Excel(name = "部件编码",orderNum ="2")
    @ApiModelProperty(value = "部件编码")
    private String eqcode;

    @Excel(name = "部件型号",orderNum ="3")
    @ApiModelProperty(value = "部件型号")
    private String standard;

    @Excel(name = "存放位置",orderNum ="4")
    @ApiModelProperty(value = "存放位置")
    private String area;

    @Excel(name = "生产厂家",orderNum ="5")
    @ApiModelProperty(value = "生产厂家")
    private String brand;

    @Excel(name = "出厂时间",orderNum ="6", format = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty(value = "出厂时间")
    private Date openDate;

    @Excel(name = "工作时间",orderNum ="7")
    @ApiModelProperty(value = "工作时间")
    private BigDecimal maintenanceCycle;


    @Excel(name = "所属单位",orderNum ="8")
    @ApiModelProperty(value = "所属单位")
    private String agencyName;

    @Excel(name = "入库时间",orderNum ="9", format = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty(value = "入库时间")
    private Date joinDate;

    @ApiModelProperty(value = "装备类型")
    private String type;

    @Excel(name = "物联编码",orderNum ="10")
    @ApiModelProperty(value = "物联编码")
    private String iotCode;


    @ApiModelProperty(value="状态")
    @Excel(name = "状态",orderNum = "11")
    private String status;

    @ApiModelProperty(value = "原因分析")
    @Excel(name = "原因分析",orderNum = "12")
    private String reason;


    @ApiModelProperty(value = "处置措施")
    @Excel(name = "处置措施",orderNum = "13")
    private String measure;

    @Excel(name = "装备定义id",orderNum ="14")
    @ApiModelProperty(value = "装备定义id")
    private Long equipmentId;


    @Excel(name = "装备定义名称",orderNum ="15")
    @ApiModelProperty(value = "装备定义名称")
    private String equipmentName;
    
    @Excel(name = "备注说明",orderNum ="16")
    @ApiModelProperty(value = "备注说明")
    private String remark;
}
