package com.yeejoin.equipmanage.common.entity.vo;

import cn.afterturn.easypoi.excel.annotation.Excel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;


/**
 * 接受故障管理查询结果
 */
@Data
public class EquipmentFaultVO implements Serializable {

    @ApiModelProperty(value = "id")
    private Long id;

    @ApiModelProperty(value = "目录编码")
    private String code;

    @Excel(name = "所属分系统",orderNum ="3")
    @ApiModelProperty(value = "装备定义名称/所属分系统")
    private String eqName;
    
    @Excel(name = "所属单位",orderNum = "2")
    @ApiModelProperty(value = "所属单位")
    private String agencyName;

    @Excel(name = "部件编码",orderNum ="4")
    @ApiModelProperty(value = "部件编码")
    private String eqCode;

    @Excel(name = "部件名称",orderNum ="1")
    @ApiModelProperty(value = "部件名称")
    private String name;

    @Excel(name = "故障类型",orderNum ="5")
    @ApiModelProperty(value = "故障类型")
    private String type;

    @Excel(name = "原因分析",orderNum ="7")
    @ApiModelProperty(value = "原因分析")
    private String reason;

    @Excel(name = "处置措施",orderNum = "8")
    @ApiModelProperty(value = "处置措施")
    private String measure;

    @Excel(name = "发生时间",orderNum = "6", format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "故障时间/发生时间")
    private Date faultOccurTime;
    

    @Excel(name = "备注",orderNum = "9")
    @ApiModelProperty(value = "备注")
    private String remark;
}
