package com.yeejoin.amos.supervision.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author DELL
 */

public enum WorkFlowBranchEnum {

    DAILY("日常检查", "company", "daily", "daily"),
    SPECIAL_C("专项检查", "company", "special", "special"),
    SPECIAL_E("专项检查", "external", "special-daily", "special"),
    SUPERVISED_DW("单位级审核", "department", "special-daily", "supervised");

    /**
     * 名称，描述
     */
    private String name;

    /**
     * 隐患类型级别
     */
    private String dangerCheckTypeLevel;

    /**
     * 计划检查类型
     */
    private String checkType;

    /**
     * 工作流分支
     */
    private String workFlowBranch;

    public String getName() {
        return name;
    }

    public String getDangerCheckTypeLevel() {
        return dangerCheckTypeLevel;
    }

    public String getCheckType() {
        return checkType;
    }

    public String getWorkFlowBranch() {
        return workFlowBranch;
    }

    WorkFlowBranchEnum(String name, String dangerCheckTypeLevel, String checkType, String workFlowBranch) {
        this.name = name;
        this.dangerCheckTypeLevel = dangerCheckTypeLevel;
        this.checkType = checkType;
        this.workFlowBranch = workFlowBranch;
    }

    public static List<Map<String,String>> getEnumList() {
        List<Map<String,String>> list = new ArrayList<>();
        for(WorkFlowBranchEnum e : WorkFlowBranchEnum.values()) {
            Map<String, String> map = new HashMap<String, String>();
            map.put("dangerCheckTypeLevel", e.getDangerCheckTypeLevel());
            map.put("name", e.getName());
            map.put("checkType", e.getCheckType());
            map.put("workFlowBranch", e.getWorkFlowBranch());
            list.add(map);
        }
        return list;
    }


}
