package com.yeejoin.equipmanage.controller;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.equipmanage.common.entity.vo.EquipmentFaultVO;
import com.yeejoin.equipmanage.common.utils.FileHelper;
import com.yeejoin.equipmanage.service.IEquipmentFaultService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import javax.servlet.http.HttpServletResponse;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;


/**
 * @Auther wff
 * @Date 2022 09 05
 **/
@RestController
@Api(tags = "故障管理 Api")
@RequestMapping(value = "/equipment-fault", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class EquipmentFaultController {

    @Autowired
    IEquipmentFaultService iEquipmentFaultService;

    @RequestMapping(value = "/listDate", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
    public IPage<EquipmentFaultVO> listPage(@RequestParam(value = "current") int pageNum,
                                            @RequestParam(value = "size") int pageSize,
                                            @RequestParam(required = false) String code,
                                            @RequestParam(required = false)String eqCode,
                                            @RequestParam(required = false)String name,
                                            @RequestParam(required = false)String faultOccurTime,
                                            @RequestParam(required = false) String type, 
                                            @RequestParam(required = false) String agencyName) {
        int start = (pageNum - 1) * pageSize;
        List<EquipmentFaultVO> list = iEquipmentFaultService.selectEquipmentFaultList(start, pageSize, code, eqCode, name, faultOccurTime, type, agencyName);
        int count = iEquipmentFaultService.selectEquipmentFaultListCount(code, eqCode, name, faultOccurTime, type, agencyName);

        Page psge = new Page(pageNum, pageSize, count);
        psge.setRecords(list);
        return psge;
    }

//    @ApiOperation(value = "导出故障清单", notes = "导出故障清单", produces = "application/octet-stream")
//    @PostMapping(value = "/export",produces = "application/json;charset=UTF-8")
//    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
//    public void exportDangerList(@RequestBody List<EquipmentFaultVO> equipmentFaultVO, @RequestParam Integer prop, HttpServletResponse response) {
//        SimpleDateFormat formatter= new SimpleDateFormat("yyyyMMdd");
//        String format = formatter.format(new Date());
//        if(prop==1){//全部导出
//            equipmentFaultVO = iEquipmentFaultService.getAll();
//            FileHelper.exportExcel(equipmentFaultVO, "故障清单", "故障清单", EquipmentFaultVO.class, format + ".xls", response);
//        }
//        else {//仅仅导出筛选结果的数据
//            FileHelper.exportExcel(equipmentFaultVO, "故障清单", "故障清单", EquipmentFaultVO.class, format + ".xls", response);
//        }
//    }

//    @ApiOperation(value = "导出故障清单", notes = "导出故障清单", produces = "application/octet-stream")
//    @PostMapping(value = "/exportData")
//    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
//    public void exportDangerList(@RequestParam Integer prop, HttpServletResponse response) {
//        SimpleDateFormat formatter= new SimpleDateFormat("yyyyMMdd");
//        String format = formatter.format(new Date());
//        List<EquipmentFaultVO> equipmentFaultVO = iEquipmentFaultService.getAll();
//        if(prop==1){//全部导出
//            FileHelper.exportExcel(equipmentFaultVO, "故障清单", "故障清单", EquipmentFaultVO.class, format + ".xls", response);
//        }
//        else {//仅仅导出筛选结果的数据
//            FileHelper.exportExcel(equipmentFaultVO, "故障清单", "故障清单", EquipmentFaultVO.class, format + ".xls", response);
//        }
//    }

    @ApiOperation(value = "导出故障清单", notes = "导出故障清单", produces = "application/octet-stream")
    @PostMapping(value = "/exportData")
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    public void exportDangerList(@RequestParam(required = false) String code,
                                 @RequestParam(required = false)String eqCode,
                                 @RequestParam(required = false)String name,
                                 @RequestParam(required = false)String faultOccurTime, 
                                 @RequestParam(required = false) String type, 
                                 @RequestParam(required = false) String agencyName,
                                 HttpServletResponse response) {
        SimpleDateFormat formatter= new SimpleDateFormat("yyyyMMdd");
        String format = formatter.format(new Date());
        List<EquipmentFaultVO> equipmentFaultVO = iEquipmentFaultService.getAll(code, eqCode, name, faultOccurTime, type, agencyName);
        FileHelper.exportExcel(equipmentFaultVO, "故障清单", "故障清单", EquipmentFaultVO.class, format + ".xls", response);
    }

}
