package com.yeejoin.equipmanage.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.equipmanage.common.entity.EquipmentFaultKnowledge;
import com.yeejoin.equipmanage.service.IEquipmentFaultKnowledgeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import java.util.List;

/**
 * @Auther tjk
 * @Date 2022 08 03
 **/

@RestController
@Api(tags = "装备故障知识库API")
@RequestMapping(value = "/equip-konwledge", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class EquipmentFaultKnowledgeController {

    @Autowired
    private IEquipmentFaultKnowledgeService iEquipmentFaultKnowledgeService;


    /**
     * 知识库的新增
     */
    /**
     * 新增
     *
     * @return
     */
    @PostMapping(value = "/save")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "新增", notes = "新增")
    public ResponseModel<Boolean> saveEquipmentDetail(@RequestBody EquipmentFaultKnowledge model) {
        boolean save = iEquipmentFaultKnowledgeService.save(model);
        return ResponseHelper.buildResponse(save);
    }

    /**
     * 根据id删除
     *
     * @param ids
     * @return
     */
    @DeleteMapping(value = "/delete")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
    public boolean deleteById( @RequestParam(name = "id") List<Long> ids) {
        //删除之前需要看一下   装备故障表中 有无该故障，没有即可以删除，有则不能进行删除操作
        boolean b=false;
        for (Long id:ids){
             b= iEquipmentFaultKnowledgeService.removeById(id);
            if(!b){
                break;
            }
        }
        return b;
    }

    /**
     * 列表分页查询
     * @param pageNum
     * @param pageSize
     * @return
     */
    @RequestMapping(value = "/listDate", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
    public IPage<EquipmentFaultKnowledge> listPage(@RequestParam(value = "current") String pageNum,
                         @RequestParam(value = "size") String pageSize) {

        Page<EquipmentFaultKnowledge> pageBean;
        IPage<EquipmentFaultKnowledge> page;
        if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
            pageBean = new Page<>(0, Long.MAX_VALUE);
        } else {
            pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
        }
        page = iEquipmentFaultKnowledgeService.page(pageBean);
        return page;
    }


    /**
     * 根据id查找
     *
     * @param id
     * @return
     */
    @GetMapping()
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "Get", value = "根据id查找", notes = "根据id查找")
    public ResponseModel<EquipmentFaultKnowledge> getById( @RequestParam(name = "id") Long id) {

        EquipmentFaultKnowledge model = iEquipmentFaultKnowledgeService.getById(id);
        return ResponseHelper.buildResponse(model);
    }

    /***
     *
     * 修改
     * **/
    @PutMapping(value = "updateById")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "PUT", value = "修改", notes = "修改")
    public ResponseModel<Boolean> updateByIdEquipmentFaultKonwledge(@RequestBody EquipmentFaultKnowledge model) {

        boolean b = iEquipmentFaultKnowledgeService.updateById(model);
        return ResponseHelper.buildResponse(b);
    }


    /**
     * 列表分页查询
     * @return
     */
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "列表查询", notes = "列表查询")
    public ResponseModel<List<EquipmentFaultKnowledge>> listEquipmentFaultKonwledge() {

        List<EquipmentFaultKnowledge> list = iEquipmentFaultKnowledgeService.list();
        return ResponseHelper.buildResponse(list);
    }

}
