package com.yeejoin.equipmanage.controller;

import com.yeejoin.equipmanage.common.utils.CommonResponseUtil;
import com.yeejoin.equipmanage.service.IEquipmentInfoOnPlanService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;

/**
 * @author keyong
 * @title: EquipmentInfoOnPlanController
 * <pre>
 * @description: TODO
 * </pre>
 * @date 2022/5/12 10:49
 */
@RestController
@Api(tags = "预案界面装备信息展示")
@RequestMapping(value = "/fire/plan")
public class EquipmentInfoOnPlanController {

    @Autowired
    private IEquipmentInfoOnPlanService equipmentInfoOnPlanService;

    @ApiOperation(httpMethod = "GET", value = "消防炮信息", notes = "消防炮信息")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value ="/monitor", method = RequestMethod.GET)
    public ResponseModel getFireMonitorInfo(@RequestParam(required=false) Long equipmentId) {
        List<Map<String, Object>> list = equipmentInfoOnPlanService.getFireMonitorInfo(equipmentId);
        return ResponseHelper.buildResponse(list);
    }

    @ApiOperation(httpMethod = "GET", value = "消防泵信息", notes = "消防泵信息")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value ="/pump")
    public ResponseModel getFirePumpInfo() {
        List<Map<String, Object>> list = equipmentInfoOnPlanService.getFirePumpInfo();
        return CommonResponseUtil.success(list);
    }

    @ApiOperation(httpMethod = "GET", value = "其他设备信息", notes = "其他设备信息")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value ="/journal")
    public ResponseModel getOtherEquipInfo() {
        List<Map<String, Object>> list = equipmentInfoOnPlanService.getOtherEquipInfo();
        return CommonResponseUtil.success(list);
    }

    @ApiOperation(httpMethod = "GET", value = "消防力量和车辆启停信息", notes = "消防力量和车辆启停信息")
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value ="/power/info")
    public ResponseModel getFirePowerAndCarInfo() {
        Map<String, Object> list = equipmentInfoOnPlanService.getFirePowerAndCarInfo();
        return CommonResponseUtil.success(list);
    }

}
