package com.yeejoin.equipmanage.mapper;

import java.util.List;

import com.yeejoin.equipmanage.common.entity.EquProperty;
import com.yeejoin.equipmanage.common.entity.vo.DetailssAmountVO;
import com.yeejoin.equipmanage.common.vo.EquipmentDate;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.equipmanage.common.entity.EquipmentCategory;
import com.yeejoin.equipmanage.common.entity.EquipmentDetail;

/**
 * Mapper 接口
 *
 * @author wujiang
 * @date 2020-07-07
 */
@Mapper
public interface EquipmentDetailMapper extends BaseMapper<EquipmentDetail> {

	List<EquipmentDetail> page(@Param("offset") long offset, @Param("size") long size,
			@Param("equip") EquipmentDetail equipmentDetail);

	int count(@Param("equip") EquipmentDetail equipmentDetail);

	List<EquipmentDetail> pageCategory(@Param("offset") long offset, @Param("size") long size,
			@Param("list") List<EquipmentCategory> list);

	int countCategory(@Param("offset") long offset, @Param("size") long size,
			@Param("list") List<EquipmentCategory> list);

	List<EquipmentDate> equpar();

	int quotaUpdate(EquProperty e);

	String getPref(@Param("id") String id);

	String checkDelete(Long id);

	List<Long> getWareId(@Param("id") Long id);

	List<DetailssAmountVO> getall();

    boolean save(EquipmentDetail equipmentDetail);
}
