package com.yeejoin.equipmanage.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.equipmanage.common.datasync.entity.FireEquipment;
import com.yeejoin.equipmanage.common.dto.EquipmentSpecificDto;
import com.yeejoin.equipmanage.common.dto.UserDto;
import com.yeejoin.equipmanage.common.entity.*;
import com.yeejoin.equipmanage.common.entity.dto.EquipmentSpecificDTO;
import com.yeejoin.equipmanage.common.entity.vo.*;
import com.yeejoin.equipmanage.common.vo.*;
import liquibase.pro.packaged.M;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 消防资源配置 Mapper 接口
 *
 * @date 2020-07-07
 */
@Mapper
public interface EquipmentSpecificMapper extends BaseMapper<EquipmentSpecific> {
    List<EquipmentSpecificVo> getEquipmentSpe(Map<String, Object> map);

    int getEquipmentSpeCount(Map<String, Object> map);

    IPage<ComplementCodeVO> selectEquipmentSpecific(Page page, EquipmentSpecificDTO equipmentSpecificDTO);

    /**
     * 获取iot_code
     *
     * @return
     */
    List<EquipmentSpecificVo> getEquipmentSpecificIotCode();

    /**
     * @Return: List<String>
     * @Throws
     * @Date 2020/11/13 9:19
     */
    List<EquipmentSpecificVo> getEquipIotCodeLists();

    List<PointTreeVo> getPointData();


    List<PointTreeVo> getSystemEquList(@Param("orgCode") String orgCode, @Param("id") Long id);

    List<EquipmentSpecificVo> getEquipOrCarByIotCode(@Param("iotCode") String iotCode);

    String getFirstCanvas(@Param("orgCode") String orgCode);

    String getSceneName(String id);

    List<PointTreeVo> getSystemmeanLsit();

    List<PointTreeVo> getSceList(@Param("orgCode") String orgCode);

    List<EquipmentSpecificIndex> getEquipMentStatus(@Param("id") String id);
    
    List<EquipmentSpecificIndex> getEquipIndexLatestStatus();
    
    /**
     * 根据画布id获取画布绑定设备最新指标状态
     * @param sceneId
     * @return
     */
    List<EquipmentSpecificIndex> getEquipLatestStatusBySceneId(String sceneId);

    List<String> getEquipmentIotCodeLists();

    List<HashMap<String, Object>> getEquipBySourceId(@Param("sourceIds") List<Long> sourceIds, @Param("categoryId") List<Long> categoryId, @Param("equipCode") String equipCode, @Param("equipName") String equipName);

    List getMenuChildren(@Param("id") Long id);

    List findAllParents();

    List findAllMenuChildren();

    Long getEquipBySourceIdBycount(@Param("sourceId") String sourceId, @Param("categoryId") String categoryId, @Param("equipCode") String equipCode, @Param("equipName") String equipName);

    EquipmentSpecificVo getEquipmentNameByIotCode(@Param("iotCode") String iotCode);

    /**
     * 拼接组态使用消防装备卡品
     */
    List<Map<String, String>> getOneCard(Long id);

    Map<String, String> getQrCodeAndPic(Long id);

    List<String> getIotCodeList(@Param("id") String id);

    List<Map<String, Object>> getEquipmentList(String alarmSystemCode);

    List<Map<String, Object>> getAlarmEquipmentById(Long id, String alarmSystemCode);

    List<String> selectSystemList(Long id);

    List<String> selectBuildList(Long id);

    SourceNameByEquipSpeIdVO getSourceNameByEquipSpeId(Long id);

    IPage<SourceNameByEquipSpeIdVO> getSourceNameList(IPage page, Long warehouseStructureId, Long sourceId, String equipmentName, String equipmentCode);

    FireEquipment getEquipSpecificDetail(Long id);

    List<EquipmentCategory> getEquipSpeTypeByQrcode(@Param("qrCode") String qrCode);

    List<FireEquipment> getEquipSpecificDetailsByEquipmentId(Long equipmentId);

    /**
     * 获取设备台账统计信息
     *
     * @param systemId 系统id
     * @return List<EquipCategoryVo>
     */
    List<EquipCategoryVo> selectEquipCategoryNumber(Long systemId);

    List<EquipmentSpecific3dVo> get3dFightingSysEquipList(Long id, String name);

    List<EquipmentSpecific3dVo> listPage(@Param("equipment") EquipFor3DVO equipment, @Param("start") long start, @Param("size") long size);

    int listCount(@Param("equipment") EquipFor3DVO equipment);

    List<LinkedHashMap> get3dFightingSysEquipCount(Long id, Integer status, String name);

    /**
     * @param like   设备名称或编码code
     * @param split  wl_equipment_category，code不包含（右%），多个用英文逗号隔开
     * @param status wl_stock_detail.status
     * @return
     */
    List<EquipmentOnCarVo> getAirEquipSpecificList(@Param("like") String like, @Param("arr") String[] split, @Param("status") Integer status);

    IPage<EquipmentOnCarVo> onCarVoIPage(Page<EquipmentSpecificDto> page, @Param("vo") EquipmentSpecificDto equipmentSpecificDto);

    EquipmentDetailVo getAirEquipSpecificDetail(Long stockDetailId);

    /**
     * 根据已有设备获取系统设备分类集合，未关联设备归为其他
     * wl_equipment_detail.id，f_fire_fighting_system.id分组
     *
     * @return
     */
    List<MaintenanceResourceDataVo> getSysEquipClassifyList();

    List<MaintenanceResourceData> getSysEquipClassifyDataList();

    IPage<MaintenanceResourceDataVo> getSysEquipClassifyDataPage(Page page, Long fireFightSysId, String fireFacilityName, String classifyId, Long fireFacilityId, List<Long> buildingId);

    IPage<MaintenanceResourceDataVo> getEquipClassifyDataPage(Page page, Long fireFightSysId, String fireFacilityName, String classifyId, Long fireFacilityId, List<Long> buildingId);

    List<UserDto> getEquipSpecificLocationInfo(Long equipmentSpecificId, String[] fieldName);
    
    Map<String, Object> getEquipSpeInfo(@Param("equipmentSpecificId") Long equipmentSpecificId);

    /**
     * 根据specificId删除装备相关数据
     * @param specificId specificId
     */
    void deleteEquipDataBySpecificId(@Param("specificId") Long specificId);

    /**
     * 根据库存id删除装备相关库存数据
     * @param stockDetailId 库存明细id
     * @param specificId specificId
     */
    void deleteEquipDataByStockDetailId(@Param("stockDetailId") Long stockDetailId, @Param("specificId") Long specificId);

    /**
     * 获取雨淋阀室指标详情
     * @return 指标详情
     */
    List<Map<String, String>> getRainRoomIndexDetails();

    /**
     * 消防管网指标详情
     * @return 指标详情
     */
    List<Map<String, String>> getTropicsIndexDetails();

    /**
     * 选择阀室指标详情
     * @return 指标详情
     */
    List<Map<String, String>> getChoiceRoomIndexDetails();

    /**
     * 消防炮伴热带指标详情
     * @return 指标详情
     */
    List<Map<String, String>> getBoxTropicsIndexDetails();

    String getEquipmentBySpecificId(@Param("specificId") Long specificId);
    
    
    List<Map<String,String>> getStationInfo();

    List<EquiplistSpecificBySystemVO> getListByWarehouseStructureId(Long floorId);

    List<Map<String, Object>> getFireMonitorInfo(@Param("equipmentId") Long fireEquipmentId, @Param("list") String[] strings);

    List<Map<String, Object>> getFirePumpInfo(@Param("list") String[] strings);

}
