package com.yeejoin.equipmanage.service.impl;

import com.yeejoin.equipmanage.common.entity.vo.EquipmentFaultVO;
import com.yeejoin.equipmanage.mapper.EquipmentFaultMapper;
import com.yeejoin.equipmanage.service.IEquipmentFaultService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;


@Service
public class EquipmentFaultServiceImpl implements IEquipmentFaultService {

    @Autowired
    EquipmentFaultMapper equipmentFaultMapper;

    @Override
    public List<EquipmentFaultVO> selectEquipmentFaultList(int pageNum, int pageSize, String code, String eqCode, String name, String faultOccurTime,  String type, String agencyName) {
        String newCode = "";
        if (code != null){
            char[] chars = code.toCharArray();
            for (int i = chars.length - 1; i >= 0; i--) {
                if ("0".equals(String.valueOf(chars[i]))) {
                    newCode = code.substring(0, i);
                } else {
                    break;
                }
            }
        }
        return equipmentFaultMapper.selectEquipmentFaultList(pageNum, pageSize, newCode, eqCode, name, faultOccurTime, type, agencyName);
    }

    @Override
    public int selectEquipmentFaultListCount(String code, String eqCode, String name, String faultOccurTime,  String type, String agencyName) {
        String newCode = "";
        if (code != null){
            char[] chars = code.toCharArray();
            for (int i = chars.length - 1; i >= 0; i--) {
                if ("0".equals(String.valueOf(chars[i]))) {
                    newCode = code.substring(0, i);
                } else {
                    break;
                }
            }
        }
        return equipmentFaultMapper.selectEquipmentFaultListcount(newCode, eqCode, name, faultOccurTime, type, agencyName);
    }

    @Override
    public List<EquipmentFaultVO> getAll(String code, String eqCode, String name, String faultOccurTime,  String type, String agencyName) {
        return equipmentFaultMapper.getAll(code, eqCode, name, faultOccurTime, type, agencyName);
    }

}
