package com.yeejoin.amos.supervision.business.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.alibaba.fastjson.JSON;
import com.yeejoin.amos.supervision.business.param.MsgInfoPageParam;
import com.yeejoin.amos.supervision.core.common.request.CommonPageable;
import com.yeejoin.amos.supervision.core.common.request.CommonRequest;

public class MsgParamUtils {

	public static MsgInfoPageParam fillMsgInfoParam(List<CommonRequest> queryRequests,
                                                    CommonPageable commonPageable, HashMap<String, Object> perMap) {
		MsgInfoPageParam param = new MsgInfoPageParam();
		for (int i = 0; i < queryRequests.size(); i++) {
			String name = queryRequests.get(i).getName();
			if ("startTime".equals(name)) {
				param.setBeginDate(toString(queryRequests.get(i).getValue()));
			} else if ("endTime".equals(name)) {
				param.setEndDate(toString(queryRequests.get(i).getValue()));
			} else if ("userName".equals(name)) {
				param.setUserName(toString(queryRequests.get(i).getValue()));
			} else if ("msgType".equals(name)) {
				param.setMsgType(toString(queryRequests.get(i).getValue()));
			}
		}
		param.setOrgCode(perMap.get("orgCode") == null ? null : perMap.get("orgCode").toString());
		param.setUserId(perMap.get("userId") == null ? null : perMap.get("userId").toString());
		if (commonPageable != null) {
			param.setPageNumber(commonPageable.getPageNumber());
			param.setPageSize(commonPageable.getPageSize());
		}
		return param;
	}
	
	private static String toString(Object value) {
		if (null == value || value == "") {
			return null;
		} else {
			return value.toString();
		}
	}

	public static String instedParams(String content, Object msgObj) {
		Map<String, Object> strengthMap = JSON.parseObject(JSON.toJSONString(msgObj), Map.class);
		for (String key : strengthMap.keySet())
			content = content.replaceAll("\\$\\{" + key + "}", String.valueOf(strengthMap.get(key)));
		return content;
	}
}
