package com.yeejoin.precontrol.common.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;

/**
 * 作业活动Vo
 *
 * @author duanwei
 * @date 2020-07-01
 */
@Data
public class ProjectHistroyDto extends BaseDto{
    private static final long serialVersionUID = 1L;
    private Long id;


    @ApiModelProperty(value = "开始时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startDate;
    @ApiModelProperty(value = "结束时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endDate;
    @ApiModelProperty(value = "人员ID")
    private Long personId;

    /**
     * 项目id集合
     */
    private List<Long> ids;


}
