package com.yeejoin.amos.fas.business.controller;


import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.fas.business.param.MessageParam;
import com.yeejoin.amos.fas.business.service.intfc.IBizMessageService;
import com.yeejoin.amos.fas.core.common.request.CommonPageable;
import com.yeejoin.amos.fas.core.util.CommonResponse;
import com.yeejoin.amos.fas.core.util.CommonResponseUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

@RestController
@RequestMapping(value = "/api/message")
@Api(tags="水资源API")
public class BizMessageController extends AbstractBaseController{


    @Autowired
    IBizMessageService iBizMessageService;

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    //@Authorization(ingore = true)
    @ApiOperation(httpMethod = "GET",value = "分页查询消息", notes = "分页查询消息")
    @RequestMapping(value = "/page", produces = "application/json;charset=UTF-8", method = RequestMethod.GET)
    public CommonResponse forPage(
            @ApiParam(value = "日期") @RequestParam(required = false)String  time,
            @ApiParam(value = "类型") @RequestParam(required = false)String  type,
            @ApiParam(value = "标题") @RequestParam(required = false)String  title,
                                    @RequestParam int pageNumber,
                                    @RequestParam  int pageSize
    ) {

		ReginParams reginParams =getSelectedOrgInfo();
		String compCode=getOrgCode(reginParams);
        CommonPageable commonPageable = new CommonPageable(pageNumber,pageSize);
        return CommonResponseUtil.success(iBizMessageService.queryForPage(StringUtils.trimToNull(time), StringUtils.trimToNull(type), StringUtils.trimToNull(title),StringUtils.trimToNull( compCode), commonPageable));
    }
    
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST",value = "分页查询消息", notes = "分页查询消息")
    @RequestMapping(value = "/page", produces = "application/json;charset=UTF-8", method = RequestMethod.POST)
    public CommonResponse forPagePOST(
    		@RequestBody MessageParam params
    ) {

		ReginParams reginParams =getSelectedOrgInfo();
		String compCode=getOrgCode(reginParams);
        CommonPageable commonPageable = new CommonPageable(params.getPageNumber(),params.getPageSize());
        return CommonResponseUtil.success(iBizMessageService.queryForPage(StringUtils.trimToNull(params.getTime()), StringUtils.trimToNull(params.getType()), StringUtils.trimToNull(params.getTitle()),StringUtils.trimToNull( compCode), commonPageable));
    }

}
