package com.yeejoin.amos.patrol.business.dao.mapper;

import com.yeejoin.amos.patrol.business.param.PlanInfoPageParam;
import com.yeejoin.amos.patrol.dao.entity.Plan;
import org.apache.ibatis.annotations.Param;

import java.util.HashMap;
import java.util.List;

public interface PlanMapper extends BaseMapper {

	Plan getPlanEntityById(String id);

	Long getMaxId();

	void updPlanStatusOrGenDate(HashMap<String,Object> id);

	/**
	 * 根据路线id获取关联的计划
	 * 
	 * @param routeId
	 * @return
	 */
	List<Plan> getPlanByRouteId(@Param(value = "routeId") Long routeId);
	/**
	 * 统计巡检计划数量
	 * @param param
	 * @return
	 */
	long countPlanInfoData(PlanInfoPageParam param);
	/**
	 * 按照查询巡检计划概要列表
	 * @param param
	 * @return
	 */
	List<HashMap<String, Object>> getPlanInfo(PlanInfoPageParam param);
	/**
	 * 按照查询巡检计划概不分页
	 * @param param
	 * @return
	 */
	List<HashMap<String, Object>> getPlanInfoNoPage(PlanInfoPageParam param);

	/**
	 *	 查询计划列表
	 * @param loginOrgCode
	 * @return
	 */
	List<HashMap<String, Object>> queryPlanListByOrgCode(@Param("orgCode") String loginOrgCode);
	

	/**
	 * 初始化计划状态
	 */
	void initUpdatePlanStatus();
	
	/**
	 * 初始化计划下次执行时间
	 */
	void initUpdatePlanNextGenDate();
}
