package com.yeejoin.amos.patrol.business.feign;

import com.yeejoin.amos.patrol.business.dto.UserDetailsDto;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;

/**
 * @author DELL
 */
@FeignClient(name = "${tzs.feign.name}", path = "tcm", configuration = {FeignConfiguration.class})
public interface TzsFeign {

    /**
     * 根据用户组id获取用户
     * @param groupId 用户组id
     * @return
     */
    @RequestMapping(value = "/userInfo/getGroupAndPersonInfo", method = RequestMethod.GET ,consumes="application/json")
    ResponseModel<List<UserDetailsDto>> getGroupAndPersonInfo(@RequestParam(value = "groupId", required = false) Long groupId);

    @RequestMapping(value = "/baseEnterprise/getEnterpriseType", method = RequestMethod.GET ,consumes="application/json")
    ResponseModel<List<Map<String,Object>>> getEnterpriseType();

    @RequestMapping(value = "/baseEnterprise/getEquipType", method = RequestMethod.GET ,consumes="application/json")
    ResponseModel<List<Map<String,Object>>> getEquipType();
}
