package com.yeejoin.amos.patrol.business.service.intfc;

import com.yeejoin.amos.boot.biz.common.bo.DepartmentBo;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.patrol.business.dto.CheckDto;
import com.yeejoin.amos.patrol.business.entity.mybatis.*;
import com.yeejoin.amos.patrol.business.param.*;
import com.yeejoin.amos.patrol.business.util.CheckDetailInputPageParam;
import com.yeejoin.amos.patrol.business.util.Toke;
import com.yeejoin.amos.patrol.business.vo.CheckAnalysisVo;
import com.yeejoin.amos.patrol.business.vo.CheckInfoVo;
import com.yeejoin.amos.patrol.core.common.response.AppPointCheckRespone;
import com.yeejoin.amos.patrol.core.common.response.CommonPage;
import com.yeejoin.amos.patrol.core.common.response.GraphInitDataResponse;
import com.yeejoin.amos.patrol.core.common.response.QueryCriteriaRespone;
import com.yeejoin.amos.patrol.dao.entity.CheckShot;
import com.yeejoin.amos.patrol.exception.YeeException;
import org.springframework.data.domain.Page;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface ICheckService {
    /**
     * 计划执行记录查询
     *
     * @param commonPageable
     * @param param
     * @return
     */
    Page<CheckInfoVo> getCheckInfo(String toke,String product,String appKey,CheckInfoPageParam param);

    void saveCheckImg(List<CheckShot> imgList);

    CheckDto saveCheckRecord(CheckRecordParam requestParam, AgencyUserModel user, DepartmentBo departmentModel, Toke token);
    CheckDto saveCheckRecordNew(CheckRecordParam requestParam, Toke token);
    /**
     * 巡检记录删除
     *
     * @param ids
     */
    @Transactional(rollbackFor = {YeeException.class, Exception.class})

    void delCheckById(List<Long> ids);

    void delCheckByTaskId(Long id, List<Long> ids, Long pointId);

    List<Map<String, Object>> selectCheckById(Long id, Long pointId);

    /**
     * 获取检查结果中所有不合格检查项
     *
     * @param checkId
     * @return
     */
    List<Map> queryUnqualifiedInputItem(int checkId);


    /**
     * 检查该店时候已经巡检完成
     *
     * @param requestParam
     * @return
     */
    int checkHasRecord(CheckRecordParam requestParam);

    AppPointCheckRespone queryCheckPointDetail(String toke,String product,String appKey,long checkId);

    AppPointCheckRespone queryCheckPointDetailInVersion2(String toke,String product,String appKey,long checkId);
    AppPointCheckRespone queryCheckPointDetailInVersion2New(long checkId);

    /**
     * 巡检统计
     *
     * @param requestParam
     * @return
     */
    Map<String, Object> checkCalendar(CheckRecordParam requestParam);

    /**
     * 巡检统计
     *
     * @param requestParam
     * @return
     */
    Map<String, Object> checkCalendarNew(String time, String orgCode,String type,String userId);

    /**
     * 根据点ID查询点巡检记录 手机APP
     *
     * @param req
     * @return
     */
    Map<String, Object> queryRecordByPointId(HashMap<String, Object> req);

    /**
     * 查询巡检记录详情
     *
     * @param checkId
     * @return
     */
    Map<String, Object> queryRecordById(int checkId);

    List<CheckInfoVo> getCheckInfoList(String toke,String product,String appKey,CheckInfoPageParam param);

    /**
     * 查询巡检记录所有图片
     *
     * @param param
     * @return
     */
    List<Map<String, Object>> getCheckInfoImgsList(CheckInfoPageParam param);

    /**
     * 根据巡检ID获取图片
     *
     * @param ids
     * @return
     */
    List<Map<String, Object>> getCheckInfoImgsList(Long[] ids);

    /**
     * 根据id获取巡检记录
     *
     * @param ids
     * @return
     */
    List<CheckInfoVo> getSelectedCheckInfoList(String toke,String product,String appKey,Long[] ids);

    /**
     * 本月隐患治理趋势统计
     *
     * @param paramMap
     * @param dateMonth
     * @return
     */
    List<HashMap<String, Object>> getCountMonthChkByRole(HashMap<String, Object> paramMap, String dateMonth);
    List<HashMap<String, Object>> getCountMonthChkByRoleNew(String orgcode);

    /**
     * 风险点信息列表查询条件
     *
     * @param companyId
     * @param userInfo
     * @return
     */
    QueryCriteriaRespone getQueryCriteriaInit(String toke,String product,String appKey,String loginOrgCode, String roleTypeName, String departmentId, String companyId);

    List<HashMap<String, String>> getCalCountChkInfo(HashMap<String, Object> paramMap);

    /**
     * 获取用户
     *
     * @param paramsMap
     * @return
     */
    List<CheckUserBo> getAuthUserInfo(HashMap<String, Object> paramsMap);

    /**
     * 根据参数获取巡检记录巡检项
     *
     * @param param
     * @return
     */
    CommonPage<CheckInputBo> getCheckInputByCheckId(CheckDetailInputPageParam param);

    /**
     * 根据参数获取装备巡检记录巡检项
     *
     * @param param
     * @return
     */
    List<HashMap<String,Object>> getEquipInputByCheckId(CheckDetailInputPageParam param);
    /**
     * 根据巡检记录ID和巡检点ID获取巡检记录详情
     *
     * @param param
     * @return
     */
    CheckDetailBo getCheckDetailById(String toke,String product,String appKey,CheckDetailInputPageParam param);

    /**
     * 根据巡检记录ID获取巡检记录图片信息
     *
     * @param checkID
     * @return
     */
    List<String> getCheckInputPhotoById(Long checkID);

    /**
     * 获取巡检轨迹
     *
     * @param params
     * @return
     */
    Page<CheckTraListBo> getCheckTraList(CheckPtListPageParam params);


    /**
     * 计划路线点最新巡检记录查询
     *
     * @param params
     * @return
     */
    List<PlanRoutePointBo> getRoutePlanPointList(CheckPtListPageParam params);

    /**
     * 根据类型初始化查询条件
     *
     * @param type
     * @param user
     * @return
     */
    QueryCriteriaRespone findCheckSystemInit(String toke,String product,String appKey,String type, String orgCode, String roleTypeName, String departmentId, String companyId);

    /**
     * 巡检记录查询
     *
     * @param params
     * @return
     */
    Page<CheckInfoBo> getCheckInfoList(CheckInfoListPageParam params);

    Page<Map<String, Object>> getCheckInfoList1(String toke,String product,String appKey,CheckInfoListPageParam params);

    /**
     * 视图模块初始化数据
     *
     * @return
     */
    public GraphInitDataResponse getViewModuleInitData();

    /**
     * 巡检情况统计分析
     *
     * @param queryRequests
     * @return
     */
    List<CheckAnalysisVo> getCheckStatisticalAnalysis(String toke,String product,String appKey,CheckStatisticalParam queryRequests);

    /**
     * 根据orgcODE获取巡检累计个数
     *
     * @param loginOrgCode
     * @return
     */
    long getCumulativeCheckCountByOrgCode(String loginOrgCode);

    /**
     * 根据条件查询日巡检统计情况
     *
     * @param param
     * @return
     */
    List<Long> getCheckDataCount(HashMap<String, Object> param);

    List<String> getCheckPhotosByCheckAndInputId(int checkId, int checkInputId,int classifyId);

    List<String> getLivePhotos(Long checkID);

    List<Long> getPlanCheckDataCount(HashMap<String, Object> param);
    /**
     * 查询巡检装备
     *
     * @param param
     * @return
     */
    List<HashMap<String,Object>> getEquipByCheckId(CheckDetailInputPageParam param);

    Page<CheckInfoVo> getCheckInfoNew(String toke,String product,String appKey,CheckInfoPageParam param);

    Page<CheckInfoVo> getPeoplePatrolPage(CheckInfoPageParam param);

    Map<String, Object> getPeopleStatistic(String bizOrgCode, String userId);
}
