package com.yeejoin.precontrol.controller.hk;

import com.yeejoin.precontrol.common.entity.hk.model.dto.HKRequestDto;
import com.yeejoin.precontrol.common.service.hk.HkPlatFormService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Author: songLei
 * @Description: 海康平台前端控制器
 * @Date: 2021/4/29 11:40
 * @Version: 1.0
 */
@RestController
@RequestMapping("/hkPlatForm")
public class HkPlatFormController {
    @Autowired
    private HkPlatFormService hkPlatFormService;
    /**
     * @Author songLei
     * @Version  1.0
     * @Description 根据区域编号获取下级监控点列表
     * 根据指定的区域编号获取该区域下的监控点列表信息，返回结果分页展示。
     * 注：返回的监控点不包括下级区域的。
     * @Date 2021年4月30日10:20:11
     */
    @GetMapping("/monitoringPointChildren")
    public Object getMonitoringPointChildren(HKRequestDto dto){
        return hkPlatFormService.getMonitoringPointChildren(dto);
    }
    /**
     * @Author songLei
     * @Version  1.0
     * @Description 获取监控点预览取流URL
     * @Date 2021/4/29 11:58
     */
    @GetMapping("/monitoringPointPreviewURL")
    public Object getMonitoringPointPreviewURL(HKRequestDto dto){
        return hkPlatFormService.getMonitoringPointPreviewURL(dto);
    }
    /**
     * @Author songLei
     * @Version  1.0
     * @Description 分页获取监控点资源
     * 获取监控点列表接口可用来全量同步监控点信息，返回结果分页展示。
     * @Date 2021年4月30日10:06:42
     */
    @GetMapping("/getMonitoringPointPage")
    public Object getMonitoringPointPage(HKRequestDto dto) {
        return hkPlatFormService.getMonitoringPointPage(dto);
    }
    /**
     * @Author songLei
     * @Version  1.0
     * @Description 获取根区域信息
     * @Date 2021年9月15日17:26:13
     */
    @GetMapping("/getRootZone")
    public Object getRootZone() {
        return hkPlatFormService.getRootZone();
    }
    /**
     * @Author songLei
     * @Version  1.0
     * @Description 分页获取区域列表
     * @Date 2021年9月15日17:26:13
     */
    @GetMapping("/getRegions")
    public Object getRegions (HKRequestDto dto){
        dto.setPageNo(1);
        dto.setPageSize(1000);
        return hkPlatFormService.getRegions(dto);
    }
}
