package com.yeejoin.amos.avic.face.model;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import javax.activation.DataSource;

public class InputStreamDataSource implements DataSource{
	private InputStream inputStream; 

    public InputStreamDataSource(InputStream inputStream) { 
     this.inputStream = inputStream; 
    } 

    @Override 
    public InputStream getInputStream() throws IOException { 
     return inputStream; 
    } 

    @Override 
    public OutputStream getOutputStream() throws IOException { 
    	return parse(inputStream); 
    } 
    
    private ByteArrayOutputStream parse(final InputStream in) throws IOException {
        final ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
        int ch;
        while ((ch = in.read()) != -1) {
            swapStream.write(ch);
        }
        return swapStream;
    }

    @Override 
    public String getContentType() { 
     return "application/octet-stream";
    } 

    @Override 
    public String getName() { 
     return "InputStreamDataSource"; 
    } 
} 
