package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.utils.DateUtils;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jg.api.dto.JgTransferNoticeDto;
import com.yeejoin.amos.boot.module.jg.api.dto.TaskMessageDto;
import com.yeejoin.amos.boot.module.jg.api.dto.TaskModelDto;
import com.yeejoin.amos.boot.module.jg.api.dto.WorkflowResultDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgTransferNotice;
import com.yeejoin.amos.boot.module.jg.api.entity.JgTransferNoticeEq;
import com.yeejoin.amos.boot.module.jg.api.enums.BusinessTypeEnum;
import com.yeejoin.amos.boot.module.jg.api.mapper.JgTransferNoticeEqMapper;
import com.yeejoin.amos.boot.module.jg.api.mapper.JgTransferNoticeMapper;
import com.yeejoin.amos.boot.module.jg.api.service.IJgTransferNoticeService;
import com.yeejoin.amos.boot.module.jg.biz.feign.TzsServiceFeignClient;
import com.yeejoin.amos.boot.module.jg.biz.service.ICmWorkflowService;
import com.yeejoin.amos.boot.module.jg.biz.utils.ImageUtils;
import com.yeejoin.amos.boot.module.jg.biz.utils.WordTemplateUtils;
import com.yeejoin.amos.boot.module.ymt.api.entity.RegistrationInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.TzBaseUnitLicence;
import com.yeejoin.amos.boot.module.ymt.api.enums.ApplicationFormTypeEnum;
import com.yeejoin.amos.boot.module.ymt.api.enums.FlowStatusEnum;
import com.yeejoin.amos.boot.module.ymt.api.mapper.*;
import com.yeejoin.amos.feign.systemctl.model.TaskV2Model;
import com.yeejoin.amos.feign.workflow.model.ActWorkflowBatchDTO;
import com.yeejoin.amos.feign.workflow.model.ActWorkflowStartDTO;
import com.yeejoin.amos.feign.workflow.model.ProcessTaskDTO;
import com.yeejoin.amos.feign.workflow.model.TaskResultDTO;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.text.ParseException;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 移装造告知服务实现类
 *
 * @author system_generator
 * @date 2023-12-19
 */
@Service
public class JgTransferNoticeServiceImpl extends BaseService<JgTransferNoticeDto, JgTransferNotice, JgTransferNoticeMapper> implements IJgTransferNoticeService {

    private static final String SUBMIT_TYPE_FLOW = "1";
    private static final String PROCESS_DEFINITION_KEY = "transferNotice";
    private static final String TABLE_PAGE_ID = "transferNoticeAdd";

    @Autowired
    EquipmentCategoryMapper equipmentCategoryMapper;
    @Autowired
    JgTransferNoticeEqMapper jgTransferNoticeEqMapper;
    @Autowired
    private JgTransferNoticeMapper jgTransferNoticeMapper;
    @Autowired
    RegistrationInfoMapper tzsJgRegistrationInfoMapper;


    @Autowired
    private CommonServiceImpl commonService;

    @Autowired
    OtherInfoMapper tzsJgOtherInfoMapper;
    @Autowired
    TzsServiceFeignClient tzsServiceFeignClient;
    @Autowired
    SupervisoryCodeInfoMapper supervisoryCodeInfoMapper;
    @Autowired
    RedisUtils redisUtils;

    @Autowired
    private TzBaseUnitLicenceMapper baseUnitLicenceMapper;

    @Autowired
    ICmWorkflowService iCmWorkflowService;

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return 移装告知
     */
    @Override
    public Map<String, Map<String, Object>> queryBySequenceNbr(Long sequenceNbr) {
        // 移装告知信息
        JgTransferNotice notice = jgTransferNoticeMapper.selectById(sequenceNbr);
        if (Objects.isNull(notice)) {
            return null;
        }
        Map<String, Object> transferNotice = BeanUtil.beanToMap(notice);
        transferNotice.put("province", notice.getProvince() + "_" + notice.getProvinceName());
        transferNotice.put("city", notice.getCity() + "_" + notice.getCityName());
        transferNotice.put("county", notice.getCounty() + "_" + notice.getCountyName());
        transferNotice.put("useUnitCreditCode", notice.getUseUnitCreditCode() + "_" + notice.getUseUnitName());
        transferNotice.put("receiveOrgCode", notice.getReceiveOrgCode() + "_" + notice.getReceiveOrgName());
        if (!ValidationUtil.isEmpty(notice.getFactoryUseSiteStreet()) && !ValidationUtil.isEmpty(notice.getStreetName())) {
            transferNotice.put("factoryUseSiteStreet", notice.getFactoryUseSiteStreet() + "_" + notice.getStreetName());
        }
        if (!ValidationUtil.isEmpty(notice.getConstructionManagerId()) && !ValidationUtil.isEmpty(notice.getConstructionManager())) {
            transferNotice.put("constructionManagerId", notice.getConstructionManagerId() + "_" + notice.getConstructionManager());
        }
        String[] fields = {"productPhoto", "designDoc", "designStandard", "factoryStandard",
                "productQualityYieldProve", "insUseMaintainExplain", "inspectReport",
                "proxyStatementAttachment", "installContractAttachment", "powerOfAttorney", "constructionContract"};
        // 设备信息
        List<Map<String, Object>> equipmentInfos = jgTransferNoticeMapper.queryEquipInformation(sequenceNbr);

        for (String s : fields) {
            if (transferNotice.containsKey(s)) {
                if ("powerOfAttorney".equalsIgnoreCase(s)) {
                    transferNotice.put("powerOfAttorneyList", ObjectUtils.isEmpty(transferNotice.get(s)) ? new JSONArray() : JSON.parseArray(transferNotice.get(s).toString()));
                } else if ("constructionContract".equalsIgnoreCase(s)) {
                    transferNotice.put("constructionContractList", ObjectUtils.isEmpty(transferNotice.get(s)) ? new JSONArray() : JSON.parseArray(transferNotice.get(s).toString()));
                } else {
                    transferNotice.put(s, ObjectUtils.isEmpty(transferNotice.get(s)) ? new JSONArray() : JSON.parseArray(transferNotice.get(s).toString()));
                }
            }
            if (equipmentInfos.get(0).containsKey(s)) {
                equipmentInfos.get(0).put(s, JSON.parseArray(equipmentInfos.get(0).get(s).toString()));
            }
        }
        Map<String, Object> map = equipmentInfos.get(0);
        BeanUtil.copyProperties(transferNotice, map, "equList", "supervisoryCode");
        return new HashMap<String, Map<String, Object>>() {{
            this.put("transferNoticeInfo", map);
        }};
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean deleteForBatch(Long[] sequenceNbrs) {
        if (Objects.isNull(sequenceNbrs) || sequenceNbrs.length == 0) {
            return false;
        }
        Collection<JgTransferNotice> jgTransferNotices = this.listByIds(Arrays.asList(sequenceNbrs));
        jgTransferNotices.forEach(notice -> {
            if (StringUtils.hasText(notice.getInspectionUnitCreditCode())) {
                throw new IllegalStateException("所选数据已存在流程，不能删除！");
            }
            notice.setIsDelete(true);
        });
        return this.updateBatchById(jgTransferNotices);
    }

    /**
     * 打印移装告知单
     *
     * @param sequenceNbr 主键
     * @return pdf文件路径
     */
    @Override
    public String generateTransferNoticeReport(Long sequenceNbr) {
        if (Objects.isNull(sequenceNbr)) {
            throw new IllegalArgumentException("参数不能为空");
        }

        JgTransferNotice jgTransferNotice = this.getById(sequenceNbr);
        List<Map<String, Object>> informationList = jgTransferNoticeMapper.queryEquipInformation(sequenceNbr);
        if (Objects.isNull(jgTransferNotice) || CollectionUtils.isEmpty(informationList)) {
            throw new IllegalArgumentException("移装告知单不存在");
        }
        Map<String, Object> maintain = informationList.get(0);

        String useCode = String.valueOf(maintain.get("installUnitCreditCode"));
        LambdaQueryWrapper<TzBaseUnitLicence> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(TzBaseUnitLicence::getUnitCode, useCode);
        List<TzBaseUnitLicence> list = baseUnitLicenceMapper.selectList(wrapper);

        ArrayList<String> installLicenseNoList = new ArrayList<>();
        ArrayList<String> installLicenseExpirationDateList = new ArrayList<>();
        if (!CollectionUtils.isEmpty(list)) {
            list.forEach(tzBaseUnitLicence -> {
                // 因模板许可证编号配置最多支持三个，再多样式混乱，目前返回三个
                if (installLicenseNoList.size() < 3) {
                    installLicenseNoList.add(tzBaseUnitLicence.getCertNo());
                    installLicenseExpirationDateList.add(DateUtils.convertDateToString(tzBaseUnitLicence.getExpiryDate(), DateUtils.DATE_PATTERN));
                }
            });
        }

        Function<String, String> getValue = key -> maintain.getOrDefault(key, "").toString();

        // 组装模板变量
        Map<String, Object> placeholders = new HashMap<>();
        placeholders.put("sequenceNbr", getValue.apply("sequenceNbr"));
        placeholders.put("installUnitName", getValue.apply("installUnitName"));
        placeholders.put("applyNo", getValue.apply("applyNo"));
        placeholders.put("productName", getValue.apply("productName"));
        placeholders.put("equipType", getValue.apply("equType"));
        placeholders.put("equipCode", getValue.apply("equRegisterCode"));
        placeholders.put("produceCode", getValue.apply("factoryNum")); // TODO: 制造编号 - 设备出厂编号
        placeholders.put("produceUnitName", getValue.apply("produceUnitName"));
        placeholders.put("produceLicenseNum", getValue.apply("produceLicenseNum"));
        placeholders.put("fullAddress", getValue.apply("provinceName") + getValue.apply("cityName") + getValue.apply("countyName") + getValue.apply("streetName") + getValue.apply("address"));
        placeholders.put("installStartDate", getValue.apply("installStartDate"));
        placeholders.put("installType", "移装"); // TODO: 施工类别
        placeholders.put("installLicenseNo", "");
        placeholders.put("installLicenseExpirationDate", "");
        placeholders.put("installLeaderName", getValue.apply("installLeaderName"));// 施工负责人
        placeholders.put("installLeaderPhone", getValue.apply("installLeaderPhone"));// 施工负责人手机
        placeholders.put("installUnitAddress", getValue.apply("provinceName") + getValue.apply("cityName") + getValue.apply("countyName") + getValue.apply("streetName") + getValue.apply("address")); // TODO: 施工单位地址
        placeholders.put("useUnitName", getValue.apply("useUnitName"));
        placeholders.put("useUnitLeaderName", getValue.apply("safetyManager"));
        placeholders.put("useUnitLeaderPhone", getValue.apply("safetyManagerPhone"));
        placeholders.put("useUnitLeaderAddress", getValue.apply("useUnitProvinceName") + getValue.apply("useUnitCityName") + getValue.apply("useUnitCountyName") + getValue.apply("streetName") + getValue.apply("useUnitAddress"));
        // 生成二维码
        String qrCode = ImageUtils.generateQRCode(getValue.apply("applyNo"), 300, 300);
        placeholders.put("qrCode", qrCode);

        placeholders.put("installLicenseNoList", installLicenseNoList);
        placeholders.put("installLicenseExpirationDateList", installLicenseExpirationDateList);
        String tempFileName = "安装告知单_" + System.currentTimeMillis() + "_temp";
        String url = WordTemplateUtils.templateToPdf(tempFileName, "installation-notification-report.ftl", placeholders);

        // 更新到数据库
        jgTransferNotice.setNoticeReportUrl(url);
        this.updateById(jgTransferNotice);

        return url;
    }


    /**
     * 更新移装告知
     *
     * @param noticeDto 移装告知
     */
    @SuppressWarnings({"rawtypes", "Duplicates"})
    @Transactional
    public JgTransferNoticeDto updateTransferNotice(String submitType, JgTransferNoticeDto noticeDto, String op) {
        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        if (Objects.isNull(noticeDto) || StringUtils.isEmpty(submitType)) {
            throw new IllegalArgumentException("参数不能为空");
        }
        // 字段转换
        this.convertField(noticeDto);
        noticeDto.setPromoter(reginParams.getUserModel().getUserId());

        JgTransferNotice notice = this.getById(noticeDto.getSequenceNbr());
        if (SUBMIT_TYPE_FLOW.equals(submitType)) {
            if (!StringUtils.hasText(noticeDto.getInstanceId())) {
                // 发起流程
                ProcessTaskDTO processTaskDTO = new ProcessTaskDTO();
                WorkflowResultDto workflowResultDto = new WorkflowResultDto();
                // 如果没有实例ID，说明是启动并执行一步
                // 直接调用工作流 启动并执行API  -  可以拿到两个节点的信息，用于填充业务字段
                ActWorkflowBatchDTO actWorkflowBatchDTO = new ActWorkflowBatchDTO();
                List<ActWorkflowStartDTO> list = new ArrayList<>();
                ActWorkflowStartDTO dto = new ActWorkflowStartDTO();
                dto.setProcessDefinitionKey(PROCESS_DEFINITION_KEY);
                dto.setBusinessKey(noticeDto.getSequenceNbr().toString());
                dto.setCompleteFirstTask(Boolean.TRUE);
                //下一节点执行人单位（下节点接收机构code）
                dto.setNextExecuteUserCompanyCode(notice.getReceiveOrgCode());
                list.add(dto);
                actWorkflowBatchDTO.setProcess(list);
                processTaskDTO = iCmWorkflowService.startBatch(actWorkflowBatchDTO).get(0);
                // 提取节点等信息
                workflowResultDto = commonService.buildWorkFlowInfo(Collections.singletonList(processTaskDTO)).get(0);
                BeanUtils.copyProperties(noticeDto, notice);
                if (!ObjectUtils.isEmpty(notice.getInstanceStatus())) {
                    notice.setInstanceStatus(notice.getInstanceStatus() + "," + workflowResultDto.getNextExecutorRoleIds());
                } else {
                    notice.setInstanceStatus(workflowResultDto.getNextExecutorRoleIds());
                }
                notice.setPromoter(RequestContext.getExeUserId());
                notice.setNextExecuteIds(String.join(",", workflowResultDto.getNextExecutorRoleIds()));
                notice.setNoticeStatus(String.valueOf(FlowStatusEnum.TO_BE_PROCESSED.getCode()));
                notice.setNextTaskId(workflowResultDto.getNextTaskId());
                notice.setInstanceId(workflowResultDto.getInstanceId());
                jgTransferNoticeMapper.updateById(notice);
                // 如果为保存并提交，则创建代办
                buildTask(Collections.singletonList(notice), Collections.singletonList(workflowResultDto), Boolean.TRUE);
            } else {
                ProcessTaskDTO processTaskDTO = new ProcessTaskDTO();
                WorkflowResultDto workflowResultDto = new WorkflowResultDto();
                // 只调用执行API，返回下个节点信息，用于填充业务字段
                //组装信息
                TaskResultDTO dto = new TaskResultDTO();
                dto.setResultCode("approvalStatus");
                dto.setTaskId(notice.getNextTaskId());
                HashMap<String, Object> commMap = new HashMap<>();
                if (notice.getNoticeStatus().equals("6614") || notice.getNoticeStatus().equals("6615")) {
                    commMap.put("approvalStatus", "提交");
                } else {
                    commMap.put("approvalStatus", op);
                }
                dto.setVariable(commMap);
                dto.setNextExecuteUserCompanyCode(notice.getReceiveOrgCode());
                processTaskDTO = iCmWorkflowService.complete(notice.getNextTaskId(), dto);
                // 提取节点等信息
                workflowResultDto = commonService.buildWorkFlowInfo(Collections.singletonList(processTaskDTO)).get(0);
                BeanUtils.copyProperties(noticeDto, notice);
                if (!ObjectUtils.isEmpty(notice.getInstanceStatus())) {
                    notice.setInstanceStatus(notice.getInstanceStatus() + "," + workflowResultDto.getNextExecutorRoleIds());
                } else {
                    notice.setInstanceStatus(workflowResultDto.getNextExecutorRoleIds());
                }
                notice.setPromoter(RequestContext.getExeUserId());
                notice.setNextExecuteIds(String.join(",", workflowResultDto.getNextExecutorRoleIds()));
                notice.setNoticeStatus(String.valueOf(FlowStatusEnum.TO_BE_PROCESSED.getCode()));
                notice.setNextTaskId(workflowResultDto.getNextTaskId());
                jgTransferNoticeMapper.updateById(notice);
                // 上个代办改为已办
                HashMap<String, Object> map = new HashMap<>();
                map.put("taskStatus", FlowStatusEnum.TO_BE_PROCESSED.getCode());
                map.put("taskStatusLabel", FlowStatusEnum.TO_BE_PROCESSED.getName());
                map.put("relationId", notice.getInstanceId());
                map.put("flowStatus", FlowStatusEnum.TO_BE_PROCESSED.getCode());
                map.put("flowStatusLabel", FlowStatusEnum.TO_BE_PROCESSED.getName());
                TaskV2Model taskV2Model = commonService.updateTaskModel(map);
                if (ObjectUtils.isEmpty(taskV2Model)) {
                    // 如果为保存并提交，则创建代办
                    buildTask(Collections.singletonList(notice), Collections.singletonList(workflowResultDto), Boolean.FALSE);
                } else {
                    TaskModelDto taskModelDto = new TaskModelDto();
                    BeanUtils.copyProperties(taskV2Model, taskModelDto);
                    // 创建新的代办
                    taskModelDto.setTaskName(workflowResultDto.getNextTaskName());
                    taskModelDto.setExecuteUserIds(workflowResultDto.getNextExecutorUserIds());
                    taskModelDto.setFlowStatus(FlowStatusEnum.TO_BE_PROCESSED.getCode());
                    taskModelDto.setFlowStatusLabel(FlowStatusEnum.TO_BE_PROCESSED.getName());
                    taskModelDto.setFlowCode(notice.getNextTaskId());
                    taskModelDto.setNextExecuteUser(workflowResultDto.getNextExecutorRoleIds());
                    TaskMessageDto taskMessageDto = new TaskMessageDto();
                    BeanUtils.copyProperties(notice, taskMessageDto);
                    taskModelDto.setModel(taskMessageDto);
                    commonService.buildTaskModel(Collections.singletonList(taskModelDto));
                }
            }
        } else {
            JgTransferNotice bean = new JgTransferNotice();
            BeanUtils.copyProperties(noticeDto, bean);
            jgTransferNoticeMapper.updateById(bean);
        }
        return noticeDto;
    }

    /**
     * 分页查询
     */
    public Page<JgTransferNoticeDto> queryForJgTransferNoticePage(Page<JgTransferNotice> page, JgTransferNoticeDto model, String type, ReginParams reginParams) {
        String orgCode;
        orgCode = reginParams.getCompany().getCompanyCode();
        model.setReceiveOrgCode(orgCode);
        Page<JgTransferNotice> noticePage = jgTransferNoticeMapper.queryForPage(page, model, type, orgCode);

        // 将Page<JgTransferNotice>转化为Page<JgTransferNoticeDto>
        Page<JgTransferNoticeDto> noticeDtoPage = new Page<>();
        BeanUtils.copyProperties(noticePage, noticeDtoPage, "records");
        List<JgTransferNoticeDto> records = noticePage.getRecords().stream().map(notice -> {
            JgTransferNoticeDto noticeDto = new JgTransferNoticeDto();
            BeanUtils.copyProperties(notice, noticeDto);
            if (Objects.nonNull(notice.getNoticeStatus())) {
                String noticeStatusDesc = FlowStatusEnum.getNameByType(Long.valueOf(notice.getNoticeStatus()));
                noticeDto.setNoticeStatusDesc(noticeStatusDesc);
            }
            return noticeDto;
        }).collect(java.util.stream.Collectors.toList());
        noticeDtoPage.setRecords(records);

        return noticeDtoPage;
    }

    @Override
    @SuppressWarnings({"Duplicates", "rawtypes"})
    @Transactional(rollbackFor = Exception.class)
    public void saveNotice(String submitType, Map<String, Object> jgTransferNoticeDtoMap, ReginParams reginParams) {
        JgTransferNoticeDto model = JSON.parseObject(JSONObject.toJSONString(jgTransferNoticeDtoMap.get(TABLE_PAGE_ID)), JgTransferNoticeDto.class);
        // 字段转换
        convertField(model);
        // 获取告知设备列表
        List<Map<String, Object>> deviceList = model.getDeviceList();
        if (CollectionUtils.isEmpty(deviceList)) {
            return;
        }
        // 获取告知单号
        ResponseModel<List<String>> responseModel = tzsServiceFeignClient.applicationFormCode(ApplicationFormTypeEnum.YZGZ.getCode(), deviceList.size());
        if (CollectionUtils.isEmpty(responseModel.getResult())) {
            return;
        }
        // 启动工作流并返回信息
        List<WorkflowResultDto> workflowResultList = workFlowInfo(submitType, deviceList, model.getReceiveOrgCode());
        List<JgTransferNotice> list = new ArrayList<>();
        List<JgTransferNoticeEq> equipList = new ArrayList<>();
        //业务数据组装等
        businessData(submitType, reginParams, model, deviceList, responseModel, workflowResultList, list, equipList);
        jgTransferNoticeMapper.insertBatchSomeColumn(list);
        // 如果为保存并提交，则创建代办
        if (SUBMIT_TYPE_FLOW.equals(submitType)) {
            buildTask(list, workflowResultList, Boolean.TRUE);
        } else {
            // 暂存任务
            buildTaskDraft(list);
        }
        List<JgTransferNoticeEq> jgRelationEquipList = equipList.stream().map(jgRelationEquip -> {
            List<JgTransferNotice> collect = list.stream().filter(JgTransferNotice -> jgRelationEquip.getEquipTransferId().equals(JgTransferNotice.getApplyNo())).collect(Collectors.toList());
            Long sequenceNbr = collect.get(0).getSequenceNbr();
            return jgRelationEquip.setEquipTransferId(String.valueOf(sequenceNbr));
        }).collect(Collectors.toList());

        jgTransferNoticeEqMapper.insertBatchSomeColumn(jgRelationEquipList);
    }

    /**
     * 暂存任务生成待办
     * @param list 业务信息
     */
    private void buildTaskDraft(List<JgTransferNotice> list) {
        List<TaskModelDto> modelDtos = new ArrayList<>();
        list.forEach(obj -> {
            TaskModelDto dto = new TaskModelDto();
            //行数据
            TaskMessageDto taskMessageDto = new TaskMessageDto();
            BeanUtils.copyProperties(obj, taskMessageDto);
            dto.setModel(taskMessageDto);
            //摘要 按原有规则组装
            dto.setTaskContent(String.format("来自%s【%s】的业务办理，【申请单号：%s】", obj.getEquList(), obj.getSupervisoryCode(), obj.getApplyNo()));
            //申请单号
            dto.setTaskCode(obj.getApplyNo());
            //业务类型枚举code值
            dto.setTaskType(BusinessTypeEnum.JG_ADVICE_REMOVAL.getCode());
            ////业务主键
            dto.setRelationId(obj.getSequenceNbr() + "");
            modelDtos.add(dto);
        });
        commonService.buildTaskModel(modelDtos);
    }

    /**
     * 组装业务数据
     */
    private void businessData(String submitType, ReginParams reginParams, JgTransferNoticeDto model, List<Map<String, Object>> deviceList, ResponseModel<List<String>> responseModel, List<WorkflowResultDto> workflowResultList, List<JgTransferNotice> list, List<JgTransferNoticeEq> equipList) {
        deviceList.forEach(obj -> {
            JgTransferNoticeEq jgRelationEquip = new JgTransferNoticeEq();
            JgTransferNotice dto = new JgTransferNotice();
            BeanUtils.copyProperties(model, dto);
            dto.setCreateUserCompanyName(reginParams.getCompany().getCompanyName());
            int i = deviceList.indexOf(obj);
            String applyNo = responseModel.getResult().get(i);
            dto.setPromoter(reginParams.getUserModel().getUserId());
            dto.setApplyNo(applyNo);
            dto.setNoticeDate(new Date());
            if (SUBMIT_TYPE_FLOW.equals(submitType)) {
                dto.setNextExecuteIds(workflowResultList.get(i).getNextExecutorRoleIds());
                dto.setInstanceStatus(workflowResultList.get(i).getNextExecutorRoleIds() + "," + workflowResultList.get(i).getExecutorRoleIds());
                dto.setPromoter(reginParams.getUserModel().getUserId());
                dto.setNextTaskId(workflowResultList.get(i).getNextTaskId());
            }
            dto.setEquList(obj.get("EQU_LIST").toString());
            dto.setSupervisoryCode(obj.get("SUPERVISORY_CODE").toString());
            dto.setInstallUnitName(reginParams.getCompany().getCompanyName());
            dto.setInstallUnitCreditCode(reginParams.getCompany().getCompanyCode());
            jgRelationEquip.setEquId(String.valueOf(obj.get("SEQUENCE_NBR")));
            jgRelationEquip.setEquipTransferId(applyNo);
            if (!CollectionUtils.isEmpty(workflowResultList)) {
                dto.setInstanceId(workflowResultList.get(i).getInstanceId());
                dto.setNoticeStatus(String.valueOf(FlowStatusEnum.TO_BE_PROCESSED.getCode()));
            } else {
                dto.setNoticeStatus(String.valueOf(FlowStatusEnum.TO_BE_SUBMITTED.getCode()));
            }
            dto.setCreateUserName(reginParams.getUserModel().getRealName());
            dto.setCreateUserId(reginParams.getUserModel().getUserId());
            list.add(dto);
            equipList.add(jgRelationEquip);
        });
    }


    /**
     * 插入代办
     */
    private void buildTask(List<JgTransferNotice> list, List<WorkflowResultDto> workflowResultList, Boolean isDeleteDraft) {
        List<TaskModelDto> taskModelDtoList = new ArrayList<>();
        WorkflowResultDto workflowResultDto = workflowResultList.get(0);
        list.forEach(item -> {
            TaskModelDto taskModelDto = new TaskModelDto();
            taskModelDto.setFlowCreateDate(item.getCreateDate());
            taskModelDto.setTaskName(workflowResultDto.getNextTaskName()); // 工作流API返回
            taskModelDto.setTaskCode(item.getApplyNo());
            taskModelDto.setTaskType(BusinessTypeEnum.JG_ADVICE_REMOVAL.getCode());
            taskModelDto.setTaskTypeLabel(BusinessTypeEnum.JG_ADVICE_REMOVAL.getName());
            taskModelDto.setRelationId(item.getInstanceId());
            taskModelDto.setExecuteUserIds(workflowResultDto.getNextExecutorUserIds()); // 工作流API返回
            taskModelDto.setTaskStatusLabel(FlowStatusEnum.TO_BE_PROCESSED.getName());
            taskModelDto.setFlowStatus(commonService.getDictionaryCodeByName(FlowStatusEnum.TO_BE_PROCESSED.getName())); // 流程状态枚举
            taskModelDto.setFlowStatusLabel(FlowStatusEnum.TO_BE_PROCESSED.getName());
            taskModelDto.setFlowCode(item.getNextTaskId());
            taskModelDto.setStartUserId(item.getCreateUserId());
            taskModelDto.setStartUser(item.getCreateUserName());
            taskModelDto.setStartUserCompanyName(item.getCreateUserCompanyName()); // 任务发起人所在单位
            taskModelDto.setStartDate(item.getCreateDate());
            taskModelDto.setNextExecuteUser(item.getNextExecuteIds());
            taskModelDto.setTaskContent(String.format("来自%s【%s】的业务办理，【申请单号：%s】", item.getEquList(), item.getSupervisoryCode(), item.getApplyNo()));
            TaskMessageDto taskMessageDto = new TaskMessageDto();
            BeanUtils.copyProperties(item, taskMessageDto);
            taskModelDto.setModel(taskMessageDto);
            taskModelDtoList.add(taskModelDto);
            if (isDeleteDraft) {
                // 删除暂存时生成的待办
                commonService.deleteTaskModel(item.getSequenceNbr()+"");
            }
        });
        commonService.buildTaskModel(taskModelDtoList);
    }

    /**
     * 工作流启动并执行
     *
     * @param submitType 是否提交
     * @param deviceList 设备信息
     * @return 工作流返回相关数据
     */
    private List<WorkflowResultDto> workFlowInfo(String submitType, List<Map<String, Object>> deviceList, String receiveOrgCode) {
        if (SUBMIT_TYPE_FLOW.equals(submitType)) {
            ActWorkflowBatchDTO actWorkflowBatchDTO = new ActWorkflowBatchDTO();
            List<ActWorkflowStartDTO> list = new ArrayList<>();
            deviceList.forEach(item -> {
                ActWorkflowStartDTO dto = new ActWorkflowStartDTO();
                dto.setProcessDefinitionKey(PROCESS_DEFINITION_KEY);
                dto.setBusinessKey(item.get("SEQUENCE_NBR").toString());
                dto.setCompleteFirstTask(Boolean.TRUE);
                //下一节点执行人单位（下节点接收机构code）
                dto.setNextExecuteUserCompanyCode(receiveOrgCode);
                list.add(dto);
            });
            actWorkflowBatchDTO.setProcess(list);
            List<ProcessTaskDTO> processTaskDTOS = iCmWorkflowService.startBatch(actWorkflowBatchDTO);
            // 组装工作流返回的数据
            return commonService.buildWorkFlowInfo(processTaskDTOS);
        }
        return new ArrayList<>();
    }


    /**
     * 页面数据转换
     */
    private void convertField(JgTransferNoticeDto model) {
        // 处理图片
        if (!ValidationUtil.isEmpty(model.getConstructionContractList())) {
            model.setConstructionContract(JSON.toJSONString(model.getConstructionContractList()));
        }
        if (!ValidationUtil.isEmpty(model.getPowerOfAttorneyList())) {
            model.setPowerOfAttorney(JSON.toJSONString(model.getPowerOfAttorneyList()));
        }
        // 分割省市区字段
        String province = model.getProvince();
        if (!ObjectUtils.isEmpty(province)) {
            String[] provinceList = province.split("_");
            if (provinceList.length > 1) {
                model.setProvince(provinceList[0]);
                model.setProvinceName(provinceList[1]);
            }
        }
        String city = model.getCity();
        if (!ObjectUtils.isEmpty(city)) {
            String[] cityList = city.split("_");
            if (cityList.length > 1) {
                model.setCity(cityList[0]);
                model.setCityName(cityList[1]);
            }
        }
        String county = model.getCounty();
        if (!ObjectUtils.isEmpty(county)) {
            String[] countyList = county.split("_");
            if (countyList.length > 1) {
                model.setCounty(countyList[0]);
                model.setCountyName(countyList[1]);
            }
        }
        // 分割单位
        String useUnitId = model.getUseUnitCreditCode();
        if (!ObjectUtils.isEmpty(useUnitId)) {
            String[] useUnitList = useUnitId.split("_");
            if (useUnitList.length > 1) {
                model.setUseUnitCreditCode(useUnitList[0]);
                model.setUseUnitName(useUnitList[1]);
            }
        }
        String receiveOrgId = model.getReceiveOrgCode();
        if (!ObjectUtils.isEmpty(receiveOrgId)) {
            String[] receiveOrgIdList = receiveOrgId.split("_");
            if (receiveOrgIdList.length > 1) {
                model.setReceiveOrgCode(receiveOrgIdList[0]);
                model.setReceiveOrgName(receiveOrgIdList[1]);
            }
        }

        String constructionManagerId = model.getConstructionManagerId();
        if (!ObjectUtils.isEmpty(constructionManagerId)) {
            String[] constructionManagerIdList = constructionManagerId.split("_");
            if (constructionManagerIdList.length > 1) {
                model.setConstructionManagerId(constructionManagerIdList[0]);
                model.setConstructionManager(constructionManagerIdList[1]);
            }
        }

        String factoryUseSiteStreet = model.getFactoryUseSiteStreet();
        if (!ObjectUtils.isEmpty(factoryUseSiteStreet)) {
            String[] factoryUseSiteStreetList = factoryUseSiteStreet.split("_");
            if (factoryUseSiteStreetList.length > 1) {
                model.setFactoryUseSiteStreet(factoryUseSiteStreetList[0]);
                model.setStreetName(factoryUseSiteStreetList[1]);
            }
        }
    }


    @Transactional
    public void cancel(JgTransferNoticeDto noticeDto) {
        JgTransferNotice jgInstallationNotice = this.baseMapper.selectById(noticeDto.getSequenceNbr());
        ProcessTaskDTO processTaskDTO = iCmWorkflowService.rollBack(jgInstallationNotice.getInstanceId());
        // 提取节点等信息
        WorkflowResultDto workflowResultDto = commonService.buildWorkFlowInfo(Collections.singletonList(processTaskDTO)).get(0);
        jgInstallationNotice.setPromoter("");
        jgInstallationNotice.setNextExecuteIds(workflowResultDto.getNextExecutorRoleIds());
        jgInstallationNotice.setNoticeStatus(String.valueOf(FlowStatusEnum.ROLLBACK.getCode()));
        jgInstallationNotice.setNextTaskId(workflowResultDto.getNextTaskId());
        jgTransferNoticeMapper.updateById(jgInstallationNotice);
        JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(jgInstallationNotice));
        jsonObject.put("taskType", BusinessTypeEnum.JG_ADVICE_REMOVAL.getCode());
        jsonObject.put("nextExecuteUser", jgInstallationNotice.getNextExecuteIds());
        jsonObject.put("flowStatusLabel", FlowStatusEnum.ROLLBACK.getName());
        jsonObject.put("flowStatus", FlowStatusEnum.ROLLBACK.getCode());
        commonService.rollbackTask(jgInstallationNotice.getInstanceId(), jsonObject);
    }

    @Transactional
    public void accept(JgTransferNoticeDto dto, String op, String opinion) {

        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        JgTransferNotice jgTransferNotice = this.jgTransferNoticeMapper.selectById(dto.getSequenceNbr());
        // 组装设备注册代码
        StringBuffer stringBuffer = new StringBuffer();
        String ym = null;
        try {
            ym = DateUtils.dateFormat(new Date(), DateUtils.DATE_PATTERN_MM);
        } catch (ParseException e) {
            log.error("日期转换失败：{}", e);
        }
        // 执行工作流并返回组装好的工作流信息
        WorkflowResultDto workflowResultDto = getWorkflowResultDto(op, opinion, jgTransferNotice);

        jgTransferNotice.setPromoter(reginParams.getUserModel().getUserId());
        TaskV2Model taskV2Model = new TaskV2Model();
        if ("0".equals(op)) {
            if (StringUtils.isEmpty(workflowResultDto.getNextExecutorRoleIds())) {
                LambdaQueryWrapper<JgTransferNoticeEq> queryWrapper = new LambdaQueryWrapper<>();
                queryWrapper.eq(JgTransferNoticeEq::getEquipTransferId, dto.getSequenceNbr());
                JgTransferNoticeEq jgTransferNoticeEq = jgTransferNoticeEqMapper.selectOne(queryWrapper);
                LambdaQueryWrapper<RegistrationInfo> queryWrapper2 = new LambdaQueryWrapper<>();
                queryWrapper2.eq(RegistrationInfo::getRecord, jgTransferNoticeEq.getEquId());
                RegistrationInfo tzsJgRegistrationInfo = tzsJgRegistrationInfoMapper.selectOne(queryWrapper2);
                stringBuffer.append(tzsJgRegistrationInfo.getEquCategory()).append(jgTransferNotice.getCity()).append(ym);
                jgTransferNotice.setPromoter("");
                jgTransferNotice.setHandleDate(new Date());
                jgTransferNotice.setNoticeStatus(String.valueOf(FlowStatusEnum.TO_BE_FINISHED.getCode()));
                this.generateTransferNoticeReport(jgTransferNotice.getSequenceNbr());
                // 上个代办改为已办
                HashMap<String, Object> taskMap = new HashMap<>();
                taskMap.put("taskStatus", FlowStatusEnum.TO_BE_FINISHED.getCode());
                taskMap.put("taskStatusLabel", FlowStatusEnum.TO_BE_FINISHED.getName());
                taskMap.put("relationId", jgTransferNotice.getInstanceId());
                taskMap.put("flowStatus", FlowStatusEnum.TO_BE_FINISHED.getCode());
                taskMap.put("flowStatusLabel", FlowStatusEnum.TO_BE_FINISHED.getName());
                TaskMessageDto taskMessageDto = new TaskMessageDto();
                BeanUtils.copyProperties(jgTransferNotice, taskMessageDto);
                taskMap.put("model", taskMessageDto);
                taskV2Model = commonService.updateTaskModel(taskMap);
            } else {
                jgTransferNotice.setNextExecuteIds(workflowResultDto.getNextExecutorRoleIds());
                if (!ObjectUtils.isEmpty(jgTransferNotice.getInstanceStatus())) {
                    jgTransferNotice.setInstanceStatus(jgTransferNotice.getInstanceStatus() + "," + workflowResultDto.getNextExecutorRoleIds());
                } else {
                    jgTransferNotice.setInstanceStatus(workflowResultDto.getNextExecutorRoleIds());
                }
                jgTransferNotice.setNoticeStatus(String.valueOf(FlowStatusEnum.TO_BE_PROCESSED.getCode()));
                // 上个代办改为已办
                HashMap<String, Object> taskMap = new HashMap<>();
                taskMap.put("taskStatus", FlowStatusEnum.TO_BE_PROCESSED.getCode());
                taskMap.put("taskStatusLabel", FlowStatusEnum.TO_BE_PROCESSED.getName());
                taskMap.put("flowStatus", FlowStatusEnum.TO_BE_PROCESSED.getCode());
                taskMap.put("flowStatusLabel", FlowStatusEnum.TO_BE_PROCESSED.getName());
                taskMap.put("relationId", jgTransferNotice.getInstanceId());
                taskV2Model = commonService.updateTaskModel(taskMap);
                TaskModelDto taskModelDto = new TaskModelDto();
                BeanUtils.copyProperties(taskV2Model, taskModelDto);
                // 创建新的代办
                taskModelDto.setTaskName(workflowResultDto.getNextTaskName());
                taskModelDto.setExecuteUserIds(workflowResultDto.getNextExecutorUserIds());
                taskModelDto.setFlowStatus(FlowStatusEnum.TO_BE_PROCESSED.getCode());
                taskModelDto.setFlowStatusLabel(FlowStatusEnum.TO_BE_PROCESSED.getName());
                taskModelDto.setFlowCode(workflowResultDto.getNextTaskId());
                taskModelDto.setTaskStatusLabel(FlowStatusEnum.TO_BE_PROCESSED.getName());
                taskModelDto.setNextExecuteUser(workflowResultDto.getNextExecutorRoleIds());
                TaskMessageDto taskMessageDto = new TaskMessageDto();
                BeanUtils.copyProperties(jgTransferNotice, taskMessageDto);
                taskModelDto.setModel(taskMessageDto);
                commonService.buildTaskModel(Collections.singletonList(taskModelDto));
            }
        } else {
            jgTransferNotice.setPromoter("");
            jgTransferNotice.setNoticeStatus(String.valueOf(FlowStatusEnum.REJECTED.getCode()));
            // 上个代办改为已办
            HashMap<String, Object> taskMap = new HashMap<>();
            taskMap.put("taskStatus", jgTransferNotice.getNoticeStatus());
            taskMap.put("taskStatusLabel", FlowStatusEnum.REJECTED.getName());
            taskMap.put("relationId", jgTransferNotice.getInstanceId());
            taskMap.put("flowStatus", FlowStatusEnum.REJECTED.getCode());
            taskMap.put("flowStatusLabel", FlowStatusEnum.REJECTED.getName());
            taskV2Model = commonService.updateTaskModel(taskMap);
            TaskModelDto taskModelDto = new TaskModelDto();
            BeanUtils.copyProperties(taskV2Model, taskModelDto);
            // 创建新的代办
            taskModelDto.setTaskName(workflowResultDto.getNextTaskName());
            taskModelDto.setExecuteUserIds(workflowResultDto.getNextExecutorUserIds());
            taskModelDto.setFlowStatus(FlowStatusEnum.REJECTED.getCode());
            taskModelDto.setFlowStatusLabel(FlowStatusEnum.REJECTED.getName());
            taskModelDto.setFlowCode(workflowResultDto.getNextTaskId());
            taskModelDto.setNextExecuteUser(workflowResultDto.getNextExecutorRoleIds());
            taskModelDto.setPageType("edit");
            TaskMessageDto taskMessageDto = new TaskMessageDto();
            BeanUtils.copyProperties(jgTransferNotice, taskMessageDto);
            taskModelDto.setModel(taskMessageDto);
            commonService.buildTaskModel(Collections.singletonList(taskModelDto));
        }
        jgTransferNotice.setNextTaskId(workflowResultDto.getNextTaskId());
        jgTransferNoticeMapper.updateById(jgTransferNotice);

    }

    /**
     * 执行工作流并返回组装好的工作流信息
     *
     * @param op               是否通过
     * @param opinion          备注信息
     * @param jgTransferNotice 业务信息
     * @return 返回组装好的工作流信息
     */
    private WorkflowResultDto getWorkflowResultDto(String op, String opinion, JgTransferNotice jgTransferNotice) {
        ProcessTaskDTO processTaskDTO = new ProcessTaskDTO();
        WorkflowResultDto workflowResultDto = new WorkflowResultDto();
        // 只调用执行API，返回下个节点信息，用于填充业务字段
        //组装信息
        TaskResultDTO workDto = new TaskResultDTO();
        workDto.setResultCode("approvalStatus");
        workDto.setTaskId(jgTransferNotice.getNextTaskId());
        HashMap<String, Object> commMap = new HashMap<>();
        if (jgTransferNotice.getNoticeStatus().equals("6614") || jgTransferNotice.getNoticeStatus().equals("6615")) {
            commMap.put("approvalStatus", "提交");
        } else {
            commMap.put("approvalStatus", op);
        }
        workDto.setNextExecuteUserCompanyCode(jgTransferNotice.getReceiveOrgCode());
        workDto.setNextExecuteUserCompanyCode("1".equals(op) ? jgTransferNotice.getInstallUnitCreditCode() : jgTransferNotice.getReceiveOrgCode());
        workDto.setVariable(commMap);
        workDto.setComment(opinion);
        processTaskDTO = iCmWorkflowService.complete(jgTransferNotice.getNextTaskId(), workDto);
        // 提取节点等信息
        workflowResultDto = commonService.buildWorkFlowInfo(Collections.singletonList(processTaskDTO)).get(0);
        return workflowResultDto;
    }

}