package com.yeejoin.amos.boot.module.jyjc.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * ProjectName: amos-boot-biz
 * PackageName: com.yeejoin.amos.boot.module.jyjc.api.enums
 *
 * @author yangyang
 * @version v1.0
 * @date 2023/12/15 16:25
 */
@Getter
@AllArgsConstructor
public enum BizTypeEnum {

    SUPERVISE("supervise", "监督检验"),
    FIRST_INSPECTION("firstinspect", "定检"),
    DETECTION("detection", "检测"),
    BUSINESS_OPEN("businessOpen", "开通");

    private String code;
    private String name;

    public static List<String> getEnumNameList() {
        List<String> codeList = new ArrayList<String>();
        for (BizTypeEnum c : BizTypeEnum.values()) {
            codeList.add(c.getCode());
        }
        return codeList;
    }


    public static String getNameByCode(String code) {
        for (BizTypeEnum c : BizTypeEnum.values()) {
            if (c.getCode().equals(code)){
                return c.getName();
            }
        }
        return null;
    }
}
