package com.yeejoin.amos.boot.module.jyjc.api.model;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.amos.boot.module.common.api.dto.AttachmentDto;
import com.yeejoin.amos.boot.module.ymt.api.dto.TzBaseUnitLicenceDto;
import com.yeejoin.amos.boot.module.ymt.api.dto.TzsUserInfoDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;
import org.typroject.tyboot.core.rdbms.model.BaseModel;
import java.util.Date;
import java.util.List;

/**
 * @author system_generator
 * @date 2023-12-13
 */
@Data
@EqualsAndHashCode (callSuper = true)
@ApiModel (value = "JyjcOpeningApplicationModel", description = "")
public class JyjcOpeningApplicationModel extends BaseModel {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty (value = "单位编码")
    private String unitCode;
    @ApiModelProperty (value = "单位地址")
    private String unitAddress;

    @ApiModelProperty (value = "单位编码Name")
    private String unitCodeName;

    @ApiModelProperty (value = "检测区域编码")
    @TableField(value = "detection_region", typeHandler = FastjsonTypeHandler.class)
    private List<String> detectionRegion;

    @ApiModelProperty (value = "检测区域名称（冗余）")
    private String detectionRegionName;

    @ApiModelProperty (value = "申请单号")
    private String applicationSeq;

    @ApiModelProperty (value = "检验结果方式")
    private String resultType;

    @ApiModelProperty (value = "有效期至")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date expiryDate;

    @ApiModelProperty (value = "受理日期（接收日期）")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date acceptDate;

    @ApiModelProperty (value = "状态")
    private String status;

    @ApiModelProperty (value = "状态Name")
    private String statusName;

    @ApiModelProperty (value = "备注")
    private String remark;

    @ApiModelProperty (value = "申请时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    private Date applyTime;

    @ApiModelProperty (value = "工作流执行角色")
    private String workflowRole;

    @ApiModelProperty (value = "工作流实例ID")
    private String workflowProstanceId;

    @ApiModelProperty (value = "工作流节点")
    private String workflowActiveKey;

    @ApiModelProperty(value = "下一执行节点ids")
    private String nextExecuteIds;

    @ApiModelProperty(value = "发起人id用于撤回操作")
    private String promoter;

    @ApiModelProperty(value = "创建人ID")
    private String createUserId;
    /* ----------------  -------------- */
    @ApiModelProperty (value = "企业资质信息")
    List<TzBaseUnitLicenceDto> baseUnitLicences;

    @ApiModelProperty (value = "检验人员信息")
    List<TzsUserInfoDto> userInfos;

    @ApiModelProperty (value = "使用单位联系人")
    private String useContact;

    @ApiModelProperty (value = "联系人联系电话")
    private String contactPhone;

    @ApiModelProperty (value = "行业主管部门")
    private String industrySupervisor;

    @ApiModelProperty (value = "单位地理坐标经度")
    private String longitude;

    @ApiModelProperty (value = "单位地理坐标纬度")
    private String latitude;

    @ApiModelProperty (value = "单位地理坐标")
    private JyjcGeographicModel geographic;

    @ApiModelProperty ("企业营业执照")
    private List<AttachmentDto> unitBusinessLicense;


    @ApiModelProperty ("下个任务id")
    private String nextTaskId;

    @ApiModelProperty ("下个任务执行人ids")
    private String nextExecuteUserIds;
}
