package com.yeejoin.amos.boot.module.jyjc.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.map.MapBuilder;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.biz.common.workflow.feign.WorkflowFeignService;
import com.yeejoin.amos.boot.module.common.api.dto.AttachmentDto;
import com.yeejoin.amos.boot.module.common.biz.utils.CommonResponseUtil;
import com.yeejoin.amos.boot.module.jyjc.api.entity.*;
import com.yeejoin.amos.boot.module.jyjc.api.enums.BizTypeEnum;
import com.yeejoin.amos.boot.module.jyjc.api.enums.DocumentEnum;
import com.yeejoin.amos.boot.module.jyjc.api.enums.ResultStatusEnum;
import com.yeejoin.amos.boot.module.jyjc.api.mapper.JyjcInspectionApplicationEquipMapper;
import com.yeejoin.amos.boot.module.jyjc.api.mapper.JyjcInspectionApplicationMapper;
import com.yeejoin.amos.boot.module.jyjc.api.model.*;
import com.yeejoin.amos.boot.module.jyjc.api.service.IJyjcInspectionApplicationService;
import com.yeejoin.amos.boot.module.jyjc.biz.feign.JgFeignClient;
import com.yeejoin.amos.boot.module.jyjc.biz.feign.TzsServiceFeignClient;
import com.yeejoin.amos.boot.module.jyjc.biz.service.impl.handler.JyjcInspectionApplicationHandlerFactory;
import com.yeejoin.amos.boot.module.ymt.api.enums.ApplicationFormTypeEnum;
import com.yeejoin.amos.boot.module.ymt.api.enums.FlowStatusEnum;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.component.feign.utils.FeignUtil;
import com.yeejoin.amos.feign.privilege.Privilege;
import com.yeejoin.amos.feign.systemctl.model.TaskV2Model;
import com.yeejoin.amos.feign.workflow.Workflow;
import com.yeejoin.amos.feign.workflow.model.ActWorkflowStartDTO;
import com.yeejoin.amos.feign.workflow.model.AjaxResult;
import com.yeejoin.amos.feign.workflow.model.TaskResultDTO;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.exception.BaseException;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.*;
import java.util.stream.Collectors;


import static com.alibaba.fastjson.JSON.parseArray;
import static com.yeejoin.amos.boot.biz.common.service.impl.WorkflowExcuteServiceImpl.buildOrderNo;

/**
 * 服务实现类
 *
 * @author system_generator
 * @date 2023-12-14
 */
@Service
@Slf4j
public class JyjcInspectionApplicationServiceImpl extends BaseService<JyjcInspectionApplicationModel, JyjcInspectionApplication, JyjcInspectionApplicationMapper> implements IJyjcInspectionApplicationService {

    @Autowired
    private JyjcInspectionResultServiceImpl inspectionResultService;
    @Autowired
    private JyjcInspectionApplicationEquipServiceImpl applicationEquipService;
    @Autowired
    TzsServiceFeignClient tzsServiceFeignClient;
    @Autowired
    private WorkflowHelper workflowHelper;
    /**
     * 分页查询
     */

    @Autowired
    JyjcInspectionApplicationAttachmentServiceImpl jyjcInspectionApplicationAttachmentService;
    @Autowired
    JyjcInspectionApplicationEquipServiceImpl jyjcInspectionApplicationEquipService;
    @Autowired
    JyjcInspectionApplicationPushLogServiceImpl jyjcInspectionApplicationPushLogService;

    @Autowired
    JyjcOpeningApplicationServiceImpl jyjcOpeningApplicationService;
    @Autowired
    WorkflowFeignService workflowFeignService;
    @Autowired
    CommonserviceImpl commonservice;
    @Value("classpath:/json/bizTypeInfo.json")
    private Resource bizTypeInfo;

    @Autowired
    private JyjcInspectionApplicationEquipMapper jyjcInspectionApplicationEquipMapper;

    @Autowired
    JgFeignClient jgFeignClient;
    @Autowired
    private RedisUtils redisUtils;

    public JyjcInspectionApplicationModel save(@RequestBody JSONObject obj) {
        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);

        //接口通用 部分页面按钮无法分开配置类型 所以根据业务情况 将带有工作流实例id的数据 接口类型设置为2 走编辑逻辑
        JyjcInspectionApplicationModel model = JSONObject.parseObject(JSON.toJSONString(obj), JyjcInspectionApplicationModel.class);
        if (CharSequenceUtil.isNotEmpty(model.getProcessInstanceId()) && model.getOperationType().equals("0")){
            model.setOperationType("2");
        }

        if (!model.getOperationType().equals("2")) {
            String taskName = "";
            if (model.getOperationType().equals("0")) {

                ActWorkflowStartDTO dto = new ActWorkflowStartDTO();
                dto.setProcessDefinitionKey( model.getProcessKey());
                dto.setBusinessKey(buildOrderNo());
                try {
                    //开启报检流程工作流
                    FeignClientResult ajaxResult = Workflow.taskV2Client.startByVariable(dto);
                    String id = JSON.parseObject(JSON.toJSONString(ajaxResult.getResult())) .get("id").toString();
             //       String id = ((Map) ajaxResult.getResult()).get("id").toString();
                    model.setProcessInstanceId(id);
                    execueFlow(MapBuilder.<String, Object>create().put("op", "提交").put("instanceId", id).put("comments", "").build());


                    // region 获取下一个流程节点的数据
                    Map<String, Object> nextNodeInfo = workflowHelper.getNextWorkflowNode(model.getProcessInstanceId());
                    String role = (String) nextNodeInfo.get("role");
                    taskName = (String) nextNodeInfo.get("taskName");
                    model.setNextExecuteIds(role);
                    if (!org.springframework.util.ObjectUtils.isEmpty(model.getWorkflowRole())) {
                        model.setWorkflowRole(model.getWorkflowRole() + "," + role);
                    } else {
                        model.setWorkflowRole(role);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }


             model.setStatus(String.valueOf(FlowStatusEnum.TO_SUBMITTED.getCode())); //6611 对应数据字典 检验流程状态 待受理
            } else if (model.getOperationType().equals("1")) {
                model.setStatus(String.valueOf(FlowStatusEnum.TO_BE_SUBMITTED.getCode()));
            }

            LambdaQueryWrapper<JyjcOpeningApplication> wa = new LambdaQueryWrapper<JyjcOpeningApplication>().eq(JyjcOpeningApplication::getUnitCode, model.getInspectionUnitCode()).eq(JyjcOpeningApplication::getStatus, FlowStatusEnum.TO_BE_FINISHED.getCode());
            List<JyjcOpeningApplication> jyjcOpeningApplications = jyjcOpeningApplicationService.getBaseMapper().selectList(wa);
            if (CollectionUtils.isNotEmpty(jyjcOpeningApplications)){
                //检验检测结果方式
                if (jyjcOpeningApplications.get(0).getResultType()!= null) {
                    model.setResultType(jyjcOpeningApplications.get(0).getResultType());
                }
            }

            List<String> codes = tzsServiceFeignClient.applicationFormCode(ApplicationFormTypeEnum.JY.getCode(), 1).getResult();
      //       List<String> codes = createCodeService.createApplicationFormCode(ApplicationFormTypeEnum.JY.getCode(), 1).getResult();

            model.setApplicationNo(codes.get(0));
            model.setApplicationDate(new Date());
            model.setPromoter(reginParams.getUserModel().getUserId());


            jyjcInspectionApplicationEquipService.getBaseMapper().deleteByApplicationSeq(model.getSequenceNbr());
            List<JyjcInspectionApplicationEquip>  equipInfos = new ArrayList<>();
            if (null != model.getEquip() && model.getEquip().size() > 0) {
                List<JyjcInspectionApplicationEquipDto> equips = JSONObject.parseArray(JSON.toJSONString(model.getEquip()), JyjcInspectionApplicationEquipDto.class);
                for (JyjcInspectionApplicationEquipDto equip : equips) {
                    JyjcInspectionApplicationEquip equipInfo = new JyjcInspectionApplicationEquip();
                    equipInfo.setEquDefine(equip.getEquDefineCode());
                    equipInfo.setEquList(equip.getEquListCode());
                    equipInfo.setEquipUnicode(equip.getSequenceNbr());
                    equipInfo.setEquCategory(equip.getEquCategoryCode());
                 //   equipInfo.setApplicationSeq(model.getSequenceNbr());
                    equipInfos.add(equipInfo);
                }
            }
            model.setCreateUserId(reginParams.getUserModel().getUserId());
            model.setNumberOfEquip(equipInfos.size());
            // endregion

            if (null == model.getSequenceNbr()){
                model = this.createWithModel(model);
            }else {
                model = this.updateWithModel(model);
            }
            String json = null;
            try {
                json = IOUtils.toString(bizTypeInfo.getInputStream(), java.lang.String.valueOf(StandardCharsets.UTF_8));
            } catch (IOException e) {
                e.printStackTrace();
            }
            List<Map> list = parseArray(json, Map.class);
            String url = null;
            for (Map map : list) {
                if (map.get("type").equals(model.getBizType() )&& "look".equals(map.get("pageType"))){
                    url = map.get("url").toString();
                }
            }

          // Map<String, Object> userOrgRoleMap = FeignUtil.remoteCall(() -> Privilege.userOrgRoleClient.getme());
          // List<String> userOrgRoleList = (List<String>) userOrgRoleMap.get("roleId");
          // String roleIds = String.join(",", userOrgRoleList);
            String urlParams = null;
            try {
                model.setEquip(null);
                urlParams = commonservice.toQueryParams(model);
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            if (StringUtils.isNotBlank(model.getProcessInstanceId())){
                commonservice.buildTaskModel(MapBuilder.<String, Object>create().put("instanceId", model.getProcessInstanceId()).put("startDate",new Date())
                        .put("agencyCode",reginParams.getUserModel().getAgencyCode()).put("userId",reginParams.getUserModel().getUserId()).put("startUser",reginParams.getUserModel().getUserId()).put("startUserId",reginParams.getUserModel().getUserId())
                        .put("taskStatus",FlowStatusEnum.TO_BE_PROCESSED.getCode()).put("taskStatusLabel",FlowStatusEnum.TO_BE_PROCESSED.getName()).put("taskName",taskName).put("taskType", model.getBizType()).put("taskTypeLabel", BizTypeEnum.getNameByCode(model.getBizType())).put("taskContent","")
                        .put("taskTitle",reginParams.getUserModel().getUserName()+"发起了"+taskName).put("taskDesc","").put("taskCode",model.getApplicationNo())
                        .put("extras",JSON.toJSONString(model)).put("createUserId",reginParams.getUserModel().getUserName()).put("startUserId",reginParams.getUserModel().getUserId())
                        .put("routePath",url.replace("{userId}",reginParams.getUserModel().getUserId()).replace("{roleIds}",model.getNextExecuteIds())+"&"+urlParams)
                        .build());
            }

            //保存报检装备监管码
            for (JyjcInspectionApplicationEquip equipInfo : equipInfos) {
                equipInfo.setApplicationSeq(model.getSequenceNbr());
            }
            applicationEquipService.saveBatch(equipInfos);
    //        Map<String, Object> map = BeanUtil.beanToMap(model);
            // 附件保存
            List<String> enumNameList = DocumentEnum.getEnumNameList();
            List<JyjcInspectionApplicationAttachmentModel> attachmentModels = new ArrayList<>();
            for (String code : enumNameList) {
                if (obj.containsKey(code)) {
                    JyjcInspectionApplicationAttachment attachments = new JyjcInspectionApplicationAttachment();
                    attachments.setAttachmentType(code);
                    attachments.setAttachmentUrl(JSONObject.toJSONString(obj.get(code)));
                    attachments.setApplicationSeq(model.getSequenceNbr());
                    jyjcInspectionApplicationAttachmentService.getBaseMapper().insert(attachments);
                }
            }
        } else {
            LambdaQueryWrapper<JyjcOpeningApplication> wa = new LambdaQueryWrapper<JyjcOpeningApplication>().eq(JyjcOpeningApplication::getUnitCode, model.getInspectionUnitCode()).eq(JyjcOpeningApplication::getStatus, FlowStatusEnum.TO_BE_FINISHED.getCode());
            List<JyjcOpeningApplication> jyjcOpeningApplications = jyjcOpeningApplicationService.getBaseMapper().selectList(wa);
            if (CollectionUtils.isNotEmpty(jyjcOpeningApplications)){
                //检验检测结果方式
                if (jyjcOpeningApplications.get(0).getResultType()!= null) {
                    model.setResultType(jyjcOpeningApplications.get(0).getResultType());
                }
            }

            //更新报检装备监管码
            jyjcInspectionApplicationEquipService.getBaseMapper().deleteByApplicationSeq(model.getSequenceNbr());
            if (model.getEquip().size() > 0) {
               // List<Map<String, Object>> equip = model.getEquip();
               // List<String> jgm = equip.stream().map(e -> e.get("equipUnicode").toString()).collect(Collectors.toList());
                List<JyjcInspectionApplicationEquipDto> equips = JSONObject.parseArray(JSON.toJSONString(model.getEquip()), JyjcInspectionApplicationEquipDto.class);
                int num = equips.size();
                model.setNumberOfEquip(num);
                for (JyjcInspectionApplicationEquipDto equip : equips) {
                    JyjcInspectionApplicationEquip equipInfo = new JyjcInspectionApplicationEquip();
                    equipInfo.setEquDefine(equip.getEquDefineCode());
                    equipInfo.setEquList(equip.getEquListCode());
                    equipInfo.setEquipUnicode(equip.getSequenceNbr());
                    equipInfo.setEquCategory(equip.getEquCategoryCode());
                    equipInfo.setApplicationSeq(model.getSequenceNbr());
                    jyjcInspectionApplicationEquipService.save(equipInfo);
                }
            }

        //    Map<String, Object> map = BeanUtil.beanToMap(model);
            // 附件更新
            List<String> enumNameList = DocumentEnum.getEnumNameList();
            List<JyjcInspectionApplicationAttachmentModel> attachmentModels = new ArrayList<>();

            jyjcInspectionApplicationAttachmentService.getBaseMapper().deleteByApplicationSeq(model.getSequenceNbr());
            for (String code : enumNameList) {
                if (obj.containsKey(code)) {
                    JyjcInspectionApplicationAttachment attachments = new JyjcInspectionApplicationAttachment();
                    attachments.setAttachmentType(code);
                    attachments.setAttachmentUrl(JSONObject.toJSONString(obj.get(code)));
                    attachments.setApplicationSeq(model.getSequenceNbr());
                    jyjcInspectionApplicationAttachmentService.getBaseMapper().insert(attachments);
                }
            }
            model.setStatus(String.valueOf(FlowStatusEnum.TO_SUBMITTED.getCode())); //6611 对应数据字典 检验流程状态 待受理
            execueFlow(MapBuilder.<String, Object>create().put("op", "提交").put("instanceId", model.getProcessInstanceId()).put("comments", "").build());
            Map<String, Object> nextNodeInfo = workflowHelper.getNextWorkflowNode(model.getProcessInstanceId());
            String role = (String) nextNodeInfo.get("role");
            String taskName = (String) nextNodeInfo.get("taskName");
            model.setNextExecuteIds(role);
            model.setPromoter(reginParams.getUserModel().getUserId());
            if (!org.springframework.util.ObjectUtils.isEmpty(model.getWorkflowRole())) {
                model.setWorkflowRole(model.getWorkflowRole() + "," + role);
            } else {
                model.setWorkflowRole(role);
            }
            this.updateWithModel(model);


            String json = null;
            try {
                json = IOUtils.toString(bizTypeInfo.getInputStream(), java.lang.String.valueOf(StandardCharsets.UTF_8));
            } catch (IOException e) {
                e.printStackTrace();
            }
            List<Map> list = parseArray(json, Map.class);
            String url = null;
            for (Map map : list) {
                if (map.get("type").equals(model.getBizType() )&& "look".equals(map.get("pageType"))){
                    url = map.get("url").toString();
                }
            }
            Map<String,Object> params = new HashMap<>();
            params.put("relationId",model.getProcessInstanceId());
            params.put("taskStatus",FlowStatusEnum.TO_BE_FINISHED.getCode());
            params.put("taskStatusLabel",FlowStatusEnum.TO_BE_FINISHED.getName());
            TaskV2Model taskV2Model = commonservice.updateTaskModel(params);

          // Map<String, Object> userOrgRoleMap = FeignUtil.remoteCall(() -> Privilege.userOrgRoleClient.getme());
          // List<String> userOrgRoleList = (List<String>) userOrgRoleMap.get("roleId");
          // String roleIds = String.join(",", userOrgRoleList);
            String urlParams = null;
            try {
                model.setEquip(null);
                urlParams = commonservice.toQueryParams(model);
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            commonservice.buildTaskModel(MapBuilder.<String, Object>create().put("instanceId", model.getProcessInstanceId()).put("startDate",new Date())
                        .put("agencyCode",reginParams.getUserModel().getAgencyCode()).put("userId",reginParams.getUserModel().getUserId()).put("startUser",reginParams.getUserModel().getUserId()).put("startUserId",reginParams.getUserModel().getUserId())
                        .put("taskStatus",FlowStatusEnum.TO_BE_PROCESSED.getCode()).put("taskStatusLabel",FlowStatusEnum.TO_BE_PROCESSED.getName()).put("taskName",taskName).put("taskType", model.getBizType()).put("taskTypeLabel", BizTypeEnum.getNameByCode(model.getBizType())).put("taskContent","")
                        .put("taskTitle",reginParams.getUserModel().getUserName()+"发起了"+taskName).put("taskDesc","").put("taskCode",model.getApplicationNo())
                        .put("extras",JSON.toJSONString(model)).put("createUserId",reginParams.getUserModel().getUserName()).put("startUserId",reginParams.getUserModel().getUserId())
                        .put("routePath",url.replace("{userId}",reginParams.getUserModel().getUserId()).replace("{roleIds}",model.getNextExecuteIds())+"&"+urlParams)
                     //   .put("routePath",url.replace("{sequenceNbr}",String.valueOf(model.getSequenceNbr())).replace("{userId}",reginParams.getUserModel().getUserId()).replace("{roleIds}",roleIds))
                        .build());

        }
        return model;
    }


    public Boolean deleteBatchData(List<Long> sequenceNbr) {

//        List<JyjcInspectionApplication> jyjcInspectionApplications = this.getBaseMapper().selectBatchIds(sequenceNbr);
////        long count = jyjcInspectionApplications.stream().filter(e ->
////                e.getStatus().equals(String.valueOf(FlowStatusEnum.TO_BE_FINISHED.getCode()))
////                        || e.getStatus().equals(String.valueOf(FlowStatusEnum.TO_SUBMITTED.getCode()))
////                       ).count();
////
////        if (count > 0) {
////            throw new BadRequest("存在 已完成、待受理状态的报检单 不可删除!");
////        }

        this.deleteBatchSeq(sequenceNbr);
        for (Long seq : sequenceNbr) {
            jyjcInspectionApplicationEquipService.getBaseMapper().deleteByApplicationSeq(seq);
            jyjcInspectionApplicationAttachmentService.getBaseMapper().deleteByApplicationSeq(seq);
            jyjcInspectionApplicationPushLogService.getBaseMapper().deleteByApplicationSeq(seq);
        }
        return true;

    }

    public Page<JyjcInspectionApplicationEquipModel> listByCategory(Page<JyjcInspectionApplicationEquipModel> page, String equipClassify) {
        return getBaseMapper().listByCategory(page, equipClassify);
    }


    public Page<JyjcInspectionApplicationModel> queryForJyjcInspectionApplicationPage(Page<JyjcInspectionApplication> page,
                                                                                 String applicationNo,
                                                                                 String inspectionClassify,
                                                                                 String applicationUnitCode,
                                                                                 String equipClassify,
                                                                                 String inspectionUnitCode,
                                                                                 String applicationUnitName,
                                                                                 String inspectionUnitName,
                                                                                 String applicationDate,
                                                                                 String acceptDate,
                                                                                 String inspectionChargePerson,
                                                                                 String status, String bizType ) {

//        return this.getBaseMapper().queryForDataList(page, applicationNo, inspectionClassify, applicationUnitCode, applicationUnitName, equipClassify, inspectionUnitCode, inspectionUnitName, applicationDate, acceptDate, inspectionChargePerson, status, bizType,roleIds);
        return this.getBaseMapper().queryForDataList(page, applicationNo, inspectionClassify, applicationUnitCode, applicationUnitName, equipClassify, inspectionUnitCode, inspectionUnitName, applicationDate, acceptDate, inspectionChargePerson, status, bizType );

    }

    /**
     * 列表查询 示例
     */
    public List<JyjcInspectionApplicationModel> queryForJyjcInspectionApplicationList() {
        return this.queryForList("", false);
    }

    public Map<String, Object> selectBySeq(Long sequenceNbr) {

        JyjcInspectionApplicationModel model = this.getBaseMapper().selectDataBySeq(sequenceNbr);
        Map<String, Object> map = BeanUtil.beanToMap(model);
        List<Map<String, Object>> dataByApplicationSeq = jyjcInspectionApplicationAttachmentService.getBaseMapper().getDataByApplicationSeq(sequenceNbr);
        Map<String, Object> attMap = new HashMap<>();
        for (Map<String, Object> maps : dataByApplicationSeq) {
            List<AttachmentDto> data = JSONArray.parseArray(maps.get("attachment_url").toString(), AttachmentDto.class);
            attMap.put(maps.get("attachment_type").toString(), data);
        }
        LambdaQueryWrapper<JyjcInspectionApplicationEquip> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(JyjcInspectionApplicationEquip::getApplicationSeq, sequenceNbr);
        List<JyjcInspectionApplicationEquip> jyjcInspectionApplicationEquips = jyjcInspectionApplicationEquipMapper.selectList(wrapper);
        String collect = jyjcInspectionApplicationEquips.stream().map(JyjcInspectionApplicationEquip::getEquipUnicode).distinct().collect(Collectors.joining(","));
        HashMap<String, Object> hashMap = new HashMap<>();
        hashMap.put("number", 1);
        hashMap.put("size", jyjcInspectionApplicationEquips.size());
        hashMap.put("SEQUENCE_NBR", collect);
        FeignClientResult<Page<JSONObject>> response = jgFeignClient.queryForPage(hashMap);
        if (200 == response.getStatus() && ObjectUtils.isNotEmpty(response.getResult())) {
            List<JSONObject> records = response.getResult().getRecords();
            ArrayList<Map<String, Object>> arrayList = new ArrayList<>();
            records.forEach(item -> {
               // item.remove("SEQUENCE_NBR");
                HashMap<String, Object> objectHashMap = new HashMap<>();
                for (Map.Entry<String, Object> stringObjectEntry : item.entrySet()) {
                    objectHashMap.put(stringObjectEntry.getKey(), stringObjectEntry.getValue());
                    String s = stringObjectEntry.getKey().toLowerCase();
                    objectHashMap.put(CharSequenceUtil.toCamelCase(s), stringObjectEntry.getValue());
                }
                arrayList.add(objectHashMap);
            });
            map.put("equip", arrayList);
        }
        map.putAll(attMap);
        return map;
    }

    /**
     * 接收
     *
     * @param params params
     * @return {@link }
     * @throws
     * @author yangyang
     * @date 2023/12/15 15:14
     */
    @Transactional(rollbackFor = Exception.class)
    public void doReceive(Map<String, Object> params) {
        execueFlow(params);
        // 执行接收业务
        String type = (String) params.get("type");
        Long sequenceNbr = Long.parseLong(params.get("sequenceNbr") + "");
        JyjcInspectionApplicationModel inspectionApplicationModel = this.queryBySeq(sequenceNbr);
        params.put("status", FlowStatusEnum.TO_BE_FINISHED.getCode() + "");
        String op = params.get("op").toString();
        Boolean rollBack = "1".equals(op) ? true : false;
        updateModelByInstanceId(sequenceNbr, inspectionApplicationModel.getProcessInstanceId(), params, rollBack);
        List<JyjcInspectionApplicationEquipModel> applicationEquipModels = applicationEquipService.listApplicationEquipByApplicationSeq(sequenceNbr);
        if (inspectionApplicationModel == null || ValidationUtil.isEmpty(applicationEquipModels)) {
            log.warn("JyjcInspectionApplicationModel Not Found！");
            return;
        }

        params.put("relationId",inspectionApplicationModel.getProcessInstanceId());
        params.put("taskStatus",FlowStatusEnum.TO_BE_FINISHED.getCode());
        params.put("taskStatusLabel",FlowStatusEnum.TO_BE_FINISHED.getName());
        TaskV2Model taskV2Model = commonservice.updateTaskModel(params);

        List<JyjcInspectionResult> resultModels = new ArrayList(applicationEquipModels.size());
        //List<String> codes = createCodeService.createApplicationFormCode(ApplicationFormTypeEnum.JG.getCode(), applicationEquipModels.size());
        List<String> codes = tzsServiceFeignClient.applicationFormCode(ApplicationFormTypeEnum.JG.getCode(), applicationEquipModels.size()).getResult();


        for (int i = 0; i < applicationEquipModels.size(); i++) {
            JyjcInspectionResult resultModel = new JyjcInspectionResult();
            resultModel.setInspectionUnitCode(inspectionApplicationModel.getInspectionUnitCode());
            resultModel.setApplicationNo(inspectionApplicationModel.getApplicationNo());
            resultModel.setApplicationUnitCode(inspectionApplicationModel.getApplicationUnitCode());
            resultModel.setResultStatus(ResultStatusEnum.NO_RESULT.getCode());
            resultModel.setApplicationDate(inspectionApplicationModel.getApplicationDate());
            resultModel.setResultType(inspectionApplicationModel.getResultType());
            //resultModel.setResultType("input");
            resultModel.setInspectionType(inspectionApplicationModel.getInspectionType());
            // 解析设备
            resultModel.setBizType(inspectionApplicationModel.getBizType());
            resultModel.setResultNo(codes.get(i));
            resultModel.setEquipUnicode(applicationEquipModels.get(i).getEquipUnicode());//设备唯一标识
            resultModel.setEquDefine(applicationEquipModels.get(i).getEquDefine());
            resultModel.setEquCategory(applicationEquipModels.get(i).getEquCategory());
            resultModel.setEquList(applicationEquipModels.get(i).getEquList());
            resultModels.add(resultModel);
        }
        inspectionResultService.saveOrUpdateBatch(resultModels);
        // 通知对应的检验机构
        Map<String, Object> thiryPartParams = MapBuilder.<String, Object>create().put("inspectionApplication", inspectionApplicationModel).put("applicationEquips", applicationEquipModels).build();
        JyjcInspectionApplicationHandlerFactory.apply(type).notifyInspectionUnit(thiryPartParams);
    }

    /**
     * 退回
     *
     * @param params params
     * @return {@link }
     * @throws
     * @author yangyang
     * @date 2023/12/15 15:14
     */
    public Boolean doReject(Map<String, Object> params) {
        execueFlow(params);
        String instanceId = Optional.ofNullable(params.get("instanceId")).orElse("").toString();
        String op = params.get("op").toString();
        Long sequenceNbr = Long.parseLong(params.get("sequenceNbr") + "");

        params.put("relationId",instanceId);
        params.put("taskStatus",FlowStatusEnum.TO_BE_FINISHED.getCode());
        params.put("taskStatusLabel",FlowStatusEnum.TO_BE_FINISHED.getName());
        TaskV2Model taskV2Model = commonservice.updateTaskModel(params);
        JyjcInspectionApplicationModel model = this.queryBySeq(sequenceNbr);
        String json = null;
        try {
            json = IOUtils.toString(bizTypeInfo.getInputStream(), java.lang.String.valueOf(StandardCharsets.UTF_8));
        } catch (IOException e) {
            e.printStackTrace();
        }
        List<Map> list = parseArray(json, Map.class);
        String url = null;
        for (Map map : list) {
            if (map.get("type").equals(model.getBizType() )&& "edit".equals(map.get("pageType"))){
                url = map.get("url").toString();
            }
        }
        taskV2Model.setRoutePath(url);
        Map<String, Object> nextNodeInfo = workflowHelper.getNextWorkflowNode(instanceId);
        String role = (String) nextNodeInfo.get("role");
        taskV2Model.setExecuteUserIds(role);
        Map<String, Object> map = BeanUtil.beanToMap(taskV2Model);
        map.put("instanceId",taskV2Model.getRelationId());
        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);

        map.put("userId",reginParams.getUserModel().getUserId());
        map.put("executeUserIds",taskV2Model.getStartUserId());
        commonservice.buildTaskModel(map);

        params.put("status", FlowStatusEnum.REJECTED.getCode() + "");
        Boolean rollBack = "1".equals(op) ? true : false;
        updateModelByInstanceId(sequenceNbr, instanceId, params, rollBack);
        return true;
    }

    /**
     * 接收/驳回通知检验单
     */
    public void execueFlow(Map<String, Object> params) {
        String op = params.get("op").toString();
        String instanceId = params.get("instanceId").toString();
        String comments = params.get("comments").toString();
        try {
            AjaxResult ajaxResult = Workflow.taskClient.getTaskNoAuth(instanceId);
            JSONObject dataObject = JSON.parseObject(JSON.toJSONString(ajaxResult.get("data")));
            if (ValidationUtil.isEmpty(dataObject)) {
                log.warn("流程已结束, instanceId => {}", instanceId);
                return;
            }
            String taskId = dataObject.getString("id");
            //组装信息
            TaskResultDTO dto = new TaskResultDTO();
            dto.setResultCode("approvalStatus");
            dto.setTaskId(taskId);
            HashMap<String, Object> varibalble = new HashMap<>();
            varibalble.put("approvalStatus", op);
            dto.setVariable(varibalble);
            dto.setComment(comments);
            // 执行流程
            AjaxResult ajaxResult1 = Workflow.taskClient.completeByTask(taskId, dto);

        } catch (Exception e) {
            e.printStackTrace();
            log.error("执行工作流错误, => {}", params, e);
            throw new  BaseException("该项流程发生变化，刷新查看状态后重试","400","");
        }
    }

    /**
     * 撤回流程办理单
     */
    public Boolean doRollback(String sequenceNbr) {
        JyjcInspectionApplicationModel inspectionApplicationModel = this.queryBySeq(Long.valueOf(sequenceNbr));
        if (inspectionApplicationModel == null) {
            log.warn("JyjcInspectionApplicationModel Not Found！sequenceNbr => " + sequenceNbr);
            return false;
        }
        try {
            // 撤回流程
            JSONObject jsonObject = workflowHelper.rollBack(inspectionApplicationModel.getProcessInstanceId());
            if (ObjectUtils.isEmpty(jsonObject) || 200 != jsonObject.getInteger("status")) {
                log.error("撤回工作流错误, => {}", jsonObject);
                return false;
            }
            updateModelByInstanceId(inspectionApplicationModel.getSequenceNbr(), inspectionApplicationModel.getProcessInstanceId(), MapBuilder.<String, Object>create().put("status", FlowStatusEnum.ROLLBACK.getCode() + "").build(), true);
            commonservice.deleteTaskModel(inspectionApplicationModel.getProcessInstanceId());
            return true;
        } catch (Exception e) {
            e.printStackTrace();
            log.error("撤回工作流错误, => {}", inspectionApplicationModel.getProcessInstanceId(), e);
            return false;
        }
    }

    public void updateModelByInstanceId(Long sequenceNbr, String instanceId, Map<String, Object> params, Boolean rollBack) {
        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        LambdaQueryWrapper<JyjcInspectionApplication> lambda = new QueryWrapper<JyjcInspectionApplication>().lambda();
        lambda.eq(JyjcInspectionApplication::getSequenceNbr, sequenceNbr);
        JyjcInspectionApplication entity = this.getBaseMapper().selectOne(lambda);
        // JyjcInspectionApplication entity = this.lambdaQuery().eq(JyjcInspectionApplication::getProcessInstanceId, instanceId).one();
        if (entity == null) {
            return;
        }
        String status = (String) params.get("status");
        List<String> persons = JSONArray.parseArray(JSON.toJSONString(params.get("inspectionChargePerson")), String.class);
       // List<String> phones = JSONArray.parseArray(JSON.toJSONString(params.get("inspectionChargePhone")), String.class);

        String inspectionChargePerson = persons == null?"":String.join(",",persons);
        String inspectionChargePhone = (String)params.get("inspectionChargePhone");
        String processDescription =  (String)params.get("comments");
        if (StringUtils.isNotBlank(inspectionChargePerson)) {
            entity.setInspectionChargePerson(inspectionChargePerson);
        }
        if (StringUtils.isNotBlank(inspectionChargePhone)) {
            entity.setInspectionChargePhone(inspectionChargePhone);
        }
        if (StringUtils.isNotBlank(processDescription)) {
            entity.setProcessDescription(processDescription);
        }
        Map<String, Object> nextNodeInfo = workflowHelper.getNextWorkflowNode(instanceId);
        String role = (String) nextNodeInfo.get("role");
        entity.setNextExecuteIds(role);
        entity.setPromoter(reginParams.getUserModel().getUserId());
        if (!org.springframework.util.ObjectUtils.isEmpty(entity.getWorkflowRole())) {
            entity.setWorkflowRole(entity.getWorkflowRole() + "," + role);
        } else {
            entity.setWorkflowRole(role);
        }
        entity.setStatus(status);
       //此处自己撤销也赋予了办理日期 存在问题 与驳回 通过区分处理
        if (rollBack) {
            this.getBaseMapper().updatePromoter(entity.getSequenceNbr());
        }
        //逻辑变更为 通过后才对办理时间赋值
        if (status.equals(String.valueOf(FlowStatusEnum.TO_BE_FINISHED.getCode()))){
            entity.setAcceptDate(new Date());
            entity.setInnerPersonCode(params.getOrDefault("innerPersonCode","").toString());
        }
        this.updateById(entity);

    }
}